/*
 * $Id: kom-types.h,v 1.7 2000/10/02 17:22:58 linus Exp $
 * Copyright (C) 1991  Lysator Academic Computer Association.
 *
 * This file is part of the LysKOM server.
 * 
 * LysKOM is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by 
 * the Free Software Foundation; either version 1, or (at your option) 
 * any later version.
 * 
 * LysKOM is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with LysKOM; see the file COPYING.  If not, write to
 * Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
 * or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
 * MA 02139, USA.
 *
 * Please mail bug reports to bug-lyskom@lysator.liu.se. 
 */
/*
 *  KOM-types.h  --  Types used by both server and client of LysKOM
 *
 *
 *  Copyright (C) 1990, 1991, 1992, 1993, 1994, 1995, 1996	Lysator Computer Club,
 *			Linkoping University,  Sweden
 *
 *  Everyone is granted permission to copy, modify and redistribute
 *  this code, provided the people they give it to can.
 *
 *
 *  Filecreator: Thomas Bellman
 *		  Lysator Computer Club
 *		  Linkoping University
 *		  Sweden
 *
 *  email:	  Bellman@Lysator.LiU.SE
 */



#ifndef  KOM_TYPES_H_ALREADY_INCLUDED__

#define  KOM_TYPES_H_ALREADY_INCLUDED__

#include <sys/types.h>
#include <limits.h>

#ifdef TIME_WITH_SYS_TIME
#include <sys/time.h>
#include <time.h>
#else /* TIME_WITH_SYS_TIME */
#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#else
#include <time.h>
#endif /* HAVE_SYS_TIME */
#endif /* TIME_WITH_SYS_TIME */

#include <s-string.h>
#include "misc-types.h"

typedef		unsigned short 	Pers_no;
typedef		unsigned short	Conf_no;
typedef 	unsigned long	Text_no;
typedef		unsigned long	Local_text_no;
typedef		unsigned long	Session_no;

#ifdef PROT_a

/*
 * To uniquely identify a person, conference or text, three numbers
 * are used: Universe, Site and X_{recpt,person,text}. The universe is
 * omitted when it is LysKOM, or is implied by a echo conference.
 */
/*
 * LysKOM, RFC-822, FidoNet, News are examples of universes.
 */
/*typedef		unsigned long		Universe;*/

/*
 * JAKOM, lysator.liu.se, 2:504/113, foo.bar.com are examples of sites
 * in the above universes. (Note that comp.lang.c is _not_ a site in
 * the News universe).
 */
/*typedef		unsigned long		Site;*/

/*
 * Fritt Forum, ceder, Per Cederqvist, comp.lang.c are examples of
 * x_recpt in the above universes.
 */

/*
 * But for now, we have a System_id (sum of Universe and Site) and a
 * Global_x.
 */

typedef		unsigned long		System_id;
typedef		unsigned long		Global_recpt;
typedef		unsigned long		Global_person;
typedef		unsigned long		Global_text;

#endif


#if USHRT_MAX < 0xFFFF
#define	MAX_PERS_NO		((Pers_no) USHRT_MAX)
#define MAX_CONF_NO		((Conf_no) USHRT_MAX)
#else
#define MAX_PERS_NO		((Pers_no) 0xFFFF)
#define MAX_CONF_NO		((Conf_no) 0xFFFF)
#endif

#if ULONG_MAX < 0xFFFFFFFF
#define MAX_TEXT_NO		((Text_no) ULONG_MAX)
#define	MAX_LOCAL_TEXT_NO	((Local_text_no) ULONG_MAX)
#else
#define MAX_TEXT_NO		((Text_no) 0xFFFFFFFF)
#define MAX_LOCAL_TEXT_NO	((Local_text_no) 0xFFFFFFFF)
#endif


typedef		struct tm	Time;
#ifdef STRUCT_TM_HAS_11_ARGUMENTS
#  define NULL_TIME_i   { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
#else
#  define NULL_TIME_i   { 0, 0, 0, 0, 0, 0, 0, 0, 0 }
#endif



/*
 * The privilige bits:  says what priviliges a person has.  E g
 *  if he is allowed to read texts he normally shouldn't be allowed
 *  to read. See file doc/security-levels.txt
 */
typedef	struct {
	unsigned int	wheel	: 1;
	unsigned int	admin	: 1;
	unsigned int	statistic : 1;
	unsigned int	create_pers: 1;
	unsigned int	create_conf: 1;
	unsigned int	change_name: 1;
	unsigned int	extern_gw : 1;
	unsigned int	flg8	: 1;	/* For future use. */
	unsigned int	flg9    : 1;
	unsigned int	flg10   : 1;
	unsigned int	flg11   : 1;
	unsigned int	flg12	: 1;
	unsigned int	flg13	: 1;
	unsigned int	flg14	: 1;
	unsigned int	flg15	: 1;
	unsigned int	flg16	: 1;
} Priv_bits;

#	define DEFAULT_PRIV_BITS_i				\
	{	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,		\
		0, 0, 0, 0, 0					\
	}
extern  const Priv_bits		DEFAULT_PRIV_BITS;



/*
 * Flags in the Person struct.
 */
typedef struct {
    unsigned int  unread_is_secret : 1;/* FALSE if everyone is allowed to ask
					  how many unread texts you have. */
    unsigned int  flg2	: 1;
    unsigned int  flg3	: 1;
    unsigned int  flg4	: 1;
    unsigned int  flg5	: 1;
    unsigned int  flg6	: 1;
    unsigned int  flg7	: 1;
    unsigned int  flg8	: 1;
} Personal_flags;

#define DEFAULT_PERSONAL_FLAGS_i					\
					 { 0, 0, 0, 0, 0, 0, 0, 0 }
extern const Personal_flags DEFAULT_PERSONAL_FLAGS;



/* See file doc/misc_items */
typedef enum {
    recpt     = 0,	/* 0 Recipient (conference) */
    cc_recpt  = 1,	/* 1 Carbon Copy recipient (extra kopia) */
    comm_to   = 2,	/* 2 Comment to (text) */
    comm_in   = 3,	/* 3 Commented in (text) */
    footn_to  = 4,	/* 4 This is a footnote to (text) */
    footn_in  = 5,	/* 5 Footnote to this text in (text) */
#ifdef PROT_a
    x_author  = 10,	/* 10 External author (Global_name). */
#endif
    
    loc_no    = 6,	/* 6 Sequence number within conference */
    rec_time  = 7,	/* 7 Received at (time) */
    sent_by   = 8,	/* 8 Sent by (person) */
    sent_at   = 9	/* 9 Sent at (time) */
#ifdef PROT_a
	,
    x_person  = 11,	/* 11 External person id. (Global_name). */
    x_recpt   = 12,	/* 12 External recipient. (Global_name). */
    x_text    = 13,	/* 13 External text. (Global_text). */
    x_system  = 14	/* 14 External system identification (System_id). */
#endif
} Info_type;

#ifdef PROT_a
typedef String Global_name;
#endif

typedef	union {
		Conf_no		recipient;
		Conf_no		cc_recipient;
		Text_no		comment_to;
		Text_no		commented_in;
		Text_no		footnote_to;
		Text_no		footnoted_in;

#ifdef PROT_a
		Global_name	x_author; /* Protocol a. */
#endif

		Local_text_no	local_no;
		Time		received_at;
		Pers_no		sender;
		Time		sent_at;

#ifdef PROT_a
		Global_name	global_person;
		Global_name	global_recpt;
		Global_text	global_text;
		System_id	system_id;
#endif
} Info_datum;


/*  This struct contains miscellaneous information about a text.  */
typedef	struct {
	Info_type	type;
	Info_datum	datum;
} Misc_info;


/*  Fields of this type is supposed to tell the garbage collector
 *  which texts it should remove first.
 */
typedef unsigned long	Garb_nice;


/*  Struct for text status  */
typedef struct {
	Time		  creation_time;
	Pers_no		  author;
	unsigned short	  no_of_lines;
	String_size	  no_of_chars;
	unsigned short	  no_of_marks;	/* Antal markeringar */
	unsigned short	  no_of_misc;	/* Recipients, times, comments, ... */
	Misc_info	* misc_items;	/* List of miscellaneous info. */
} Text_stat;

#define	EMPTY_TEXT_STAT_i	{  NULL_TIME_i, 0, 0, 0, 0, 0, NULL  }

extern const Text_stat EMPTY_TEXT_STAT;



typedef	struct {
	unsigned int	rd_prot	: 1;	/* !(Can anyone become a member?) */
	unsigned int	original : 1;	/* Comments forbidden? */
	unsigned int	secret : 1;	/* Secret conference? */
					/* Note: if a letterbox is secret it
					 * will be very hard for that person
					 * to log in, since he can't map his
					 * name to a pers_no. He must either
					 * know his pers_no, or have another
					 * identity which is his supervisor.
					 */
	unsigned int	letter_box : 1;	/* Is this a letter box? */
	unsigned int    allow_anon : 1; /* do we accept anonymous messages */
	unsigned int	reserved1 : 1;
	unsigned int	reserved2 : 1;
	unsigned int	reserved3 : 1;
} Conf_type;

#define	NULL_CONF_TYPE_i		{  0, 0, 0, 0, 0, 0, 0, 0  }
extern  const Conf_type	NULL_CONF_TYPE;



typedef struct {
	Pers_no		member;
} Member;


/* Struct for marks */
typedef struct {
	Text_no		text_no;
	unsigned char	mark_type;	/* It's up to the clients to decide the
					   meaning of this field. */
} Mark;



/*  Information about a person's membership in a conference  */
typedef struct {
	Conf_no		conf_no;
	unsigned char	priority;	/* Interrupt priority */
	Time		last_time_read;	/* Updated every time a text in this
					   conf. is marked as read.	*/
	Local_text_no	last_text_read;	/* All texts before and inclusive this
					   are read	*/
	unsigned short	no_of_read;
	Local_text_no * read_texts;	/* Texts after last_text_read. Sorted
					   in ascending order */
} Membership;

#define	EMPTY_MEMBERSHIP_i	{  0, 0, NULL_TIME_i, 0, 0, NULL  }
extern  const Membership EMPTY_MEMBERSHIP;



/* Some structs to handle variable-sized arrays. */

typedef struct {
	unsigned short	  no_of_marks;
	Mark		* marks;	/* Pointer to an array of marks. */
} Mark_list;

#define	EMPTY_MARK_LIST_i	{  0, NULL  }
extern const Mark_list EMPTY_MARK_LIST;


typedef struct {
    unsigned short no_of_confs;
    Conf_no	  *conf_nos;
} Conf_no_list;

#define EMPTY_CONF_NO_LIST_i	{ 0, NULL  }
extern const Conf_no_list EMPTY_CONF_NO_LIST;
   

typedef struct {
	unsigned short	  no_of_members;
	Member		* members;
} Member_list;

#define EMPTY_MEMBER_LIST_i	{  0, NULL  }
extern const Member_list EMPTY_MEMBER_LIST;



typedef  struct {
	Local_text_no	  first_local_no;
    	unsigned long	  no_of_texts;
	Text_no		* texts;
}  Text_list;

#define EMPTY_TEXT_LIST_i	{  1, 0, NULL  }
extern const Text_list	EMPTY_TEXT_LIST;


/* Membership_list. */
typedef struct {
	unsigned short	    no_of_confs;
	Membership	  * confs;
} Membership_list;

#define EMPTY_MEMBERSHIP_LIST_i		{  0, NULL  }
extern  const Membership_list		EMPTY_MEMBERSHIP_LIST;


typedef struct {
	int		       length;
        long                  *data;
} Number_list;


/* The Info struct */
typedef struct {
	long		version;
	Conf_no		conf_pres_conf; /* Presentation of new confs */
	Conf_no		pers_pres_conf;	/* Presentation of new persons */
	Conf_no		motd_conf; 	/* Conf that receive motds */
	Conf_no		kom_news_conf;  /* News about kom */
	Text_no		motd_of_lyskom; /* To be displayed after login */
	/* and maybe more... */
} Info;



typedef	struct {
	Pers_no		creator;
	Time		creation_time;
	Text_no		presentation;
	Conf_no		supervisor;	/* Organisat|r f|r m|tet */
	Conf_no		permitted_submitters;	/* People who are allowed
					   to submit texts to this conf. 
					   0 -> anyone may submit. */
	Conf_no		super_conf;	/* Send unallowed submissions to
					   the super_conf. 
					   0 -> unallowed submissions bounce */
	Conf_type	type;		/* secret, rd_prot etc */
	Time		last_written;	/* Time of latest text in this conf. */
	Text_no		msg_of_day;	/* Message to be displayed when this
					   conf is referenced by the user. */
	Garb_nice	nice;		/* How long do texts in this
					   conf live? */
	String		name;		/* Name of conference */
	unsigned short	no_of_members;
	Local_text_no	first_local_no;
	unsigned long	no_of_texts;
} Conference;


#	define	EMPTY_CONFERENCE_i				\
	{	0, NULL_TIME_i, 0, 0, 0, 0, NULL_CONF_TYPE_i,	\
		NULL_TIME_i, 0, 0, EMPTY_STRING_i, 0, 0, 0	\
	}
extern const Conference	EMPTY_CONFERENCE;

typedef struct {
	String		name;		/* Name of conference */
	Conf_type	type;		/* secret, rd_prot etc */
	Local_text_no	highest_local_no; /* highest local text no */
	Garb_nice	nice;	        /* Number of days to live */
} Small_conf;

typedef struct {
	String      name;
	Conf_type   type;
	Conf_no     conf_no;
} Conf_z_info;

#define EMPTY_CONF_Z_INFO_i		{ EMPTY_STRING_i, NULL_CONF_TYPE_i, 0 }
extern const Conf_z_info		EMPTY_CONF_Z_INFO;

typedef struct {
	unsigned short    no_of_confs;
	Conf_z_info     * confs;
} Conf_z_info_list;

#define EMPTY_CONF_Z_INFO_LIST_i	{  0, NULL  }
extern const Conf_z_info_list		EMPTY_CONF_Z_INFO_LIST;



/*  Struct for persons  */
typedef struct {
	Text_no		user_area;	/* Misc info the clients might want to
					   store. 0 = not used. */
	Priv_bits	privileges;
	Personal_flags	flags;
	Time		last_login; 	/* Or logout */
	unsigned long	total_time_present; /* Number of seconds. */
	unsigned long	sessions;	/* Number of sessions */
	unsigned long	created_lines;	/* No. of created lines (statistics) */
	unsigned long	created_bytes;	/* No. of created bytes (statistics) */
	unsigned long	read_texts;	/* No. of read texts (statistics) */
	unsigned long	no_of_text_fetches; /* (statistics) */
	unsigned short	created_persons; /* (statistics) */
	unsigned short	created_confs;	/* (statistics) */
	String		username;	/* User-name & hostname */
	Local_text_no	first_created_text; /* The first text that still
					     * exists. */
	unsigned long	no_of_created_texts;
	unsigned short	no_of_marks;	/* This many marked texts */
	unsigned short	no_of_confs;	/* Member in this many confs */
} Person;

#	define EMPTY_PERSON_i					\
	{	0, DEFAULT_PRIV_BITS_i,				\
		DEFAULT_PERSONAL_FLAGS_i, NULL_TIME_i, 0, 0,	\
		0, 0, 0, 0, 0, 0, EMPTY_STRING_i, 0, 0, 0, 0	\
	}
extern  const Person	EMPTY_PERSON;



/*
 * This struct is arriving with the 'i_am_on' call.
 */
typedef struct {
	Pers_no		person;
	String		what_am_i_doing;
	String		username;           /* Userid and hostname. */
	Conf_no		working_conference;
	Session_no	session_no;         /* Serial number of connection. */
} Who_info;

#define	EMPTY_WHO_INFO_i	{  0, EMPTY_STRING_i, EMPTY_STRING_i, 0, 0 }
extern const Who_info		EMPTY_WHO_INFO;


typedef struct {
	Pers_no		person;
	String		what_am_i_doing;
	String		username;            /* Userid and hostname. */
	Conf_no		working_conference;
	Session_no	session;             /* Serial number of connection. */
	Time		connection_time;     /* Not logintime. */
	unsigned long	idle_time; 	     /* Seconds. */
} Session_info;

#define EMPTY_SESSION_INFO_i			{ 0, EMPTY_STRING_i,    \
						  EMPTY_STRING_i, 0, 0, \
						  NULL_TIME_i, 0 }

extern const Session_info	EMPTY_SESSION_INFO;

typedef struct {
    unsigned int  invisible : 1;
    unsigned int  user_active_used : 1;
    unsigned int  user_absent : 1;
    unsigned int  reserved3 : 1;
    unsigned int  reserved4 : 1;
    unsigned int  reserved5 : 1;
    unsigned int  reserved6 : 1;
    unsigned int  reserved7 : 1;
} Session_flags;

#define EMPTY_SESSION_FLAGS_i { 0, 0, 0, 0, 0, 0, 0, 0 }
    
typedef struct {
	Session_no     session;
	Pers_no        person;
	Conf_no        working_conference;
	unsigned long  idle_time;
	Session_flags  flags;
	String         what_am_i_doing;
} Dynamic_session_info;

typedef struct {
	long		          no_of_sessions;
    	Dynamic_session_info	* sessions;
} Dynamic_session_info_list;	

typedef struct {
	String  username;
	String  hostname;
	String  ident_user;
	Time    connection_time;
} Static_session_info;

#define EMPTY_DYNAMIC_SESSION_INFO_i 	{ 0, 0, 0, 0L, EMPTY_SESSION_FLAGS_i, EMPTY_STRING_i }
extern const Dynamic_session_info	EMPTY_DYNAMIC_SESSION_INFO;

#define EMPTY_DYNAMIC_SESSION_INFO_LIST_i	{ 0, NULL }
extern const Dynamic_session_info_list	EMPTY_DYNAMIC_SESSION_INFO_LIST;

#define EMPTY_STATIC_SESSION_INFO_i	{ EMPTY_STRING_i, EMPTY_STRING_i, EMPTY_STRING_i, NULL_TIME_i }
extern const Static_session_info	EMPTY_STATIC_SESSION_INFO;


#define EMPTY_tm_i		0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, 0

typedef struct {
        unsigned long protocol_version;
        String        server_name;
        String        server_version;
} Version_info;


#endif	/*  ifndef  KOM_TYPES_H_ALREADY_INCLUDED__  */
