/*
 * arg.c -- argument processing functions for lslk
 *
 * See the LSLK_VERSION #define in ./lslk.h for the current revision
 * number.  If no lslk.h has yet been generated, see ./version.
 *
 * V. Abell
 * Purdue University Computing Center
 */


/*
 * Copyright 1996 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell.
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */
#ifndef lint
static char copyright[] =
"@(#) Copyright 1996 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: arg.c,v 1.6 99/11/10 14:55:21 abe Exp $";
#endif
 

#include "lslk.h"
#include "version.h"


/*
 * Local prototypes
 */

_PROTOTYPE(static char *isnullstr,(char *s));


/*
 * enter_nwad() -- enter network address selections
 */

int
enter_nwad(opt)
	char *opt;			/* option characters */
{
	unsigned long a;
	char *hn;
	size_t len;
	static int na = 0;

	if (opt == NULL) {
	    (void) fprintf(stderr, "%s: no network address specified\n",
		Pn);
	    return(1);
	}
/*
 * Process the Internet addresses (1.2.3.4) or host name.
 */
	if (isdigit(*opt)) {
	    if ((a = inet_addr(opt)) == -1) {
		(void) fprintf(stderr, "%s: invalid network address: %s\n",
		    Pn, opt);
		return(1);
	    }
	    hn = (char *)NULL;
	} else {
	    hn = opt;
	    a = 0l;
	}
/*
 * Allocate network address table space, as required.
 */
	if (NNwad >= na) {
	    na += NWADAU;
	    len = (size_t)(na * sizeof(struct nwad));
	    if (Nwad)
		Nwad = (struct nwad *)realloc(Nwad, len);
	    else
		Nwad = (struct nwad *)malloc(len);
	    if (!Nwad) {
		(void) fprintf(stderr,
		    "%s: no space for %d network addresses: %s\n", Pn, na, opt);
		Exit(1);
	    }
	}
/*
 * Allocate host name space, as required.
 */
	if (hn) {
	    if ((Nwad[NNwad].hn = (char *)malloc(strlen(hn)+1)) == NULL) {
		(void) fprintf(stderr, "%s: no space for host name: %s\n",
		    Pn, hn);
		Exit(1);
	    }
	    (void) strcpy(Nwad[NNwad].hn, hn);
	} else
	    Nwad[NNwad].hn = (char *)NULL;
	Nwad[NNwad].chn = (char *)NULL;
/*
 * Store network address.
 */
	Nwad[NNwad++].na = a;
	return(0);
}


/*
 * enter_pid() -- enter Process ID selection numbers
 */

int
enter_pid(opt)
	char *opt;			/* option characters */
{
	char *cp;
	int i;
	size_t len;
	static int na = 0;
	unsigned long p;

	if (opt == NULL) {
	    (void) fprintf(stderr, "%s: no PIDs specified\n", Pn);
	    return(1);
	}
/*
 * Convert and store the list of PIDs.
 */
	for (cp = opt; *cp;) {

	/*
	 * Convert and store the next PID.
	 */
	    for (p = 0l; *cp && *cp != ','; *cp++) {
		if (!isdigit(*cp)) {
		    (void) fprintf(stderr, "%s: illegal PID: %s\n", Pn, opt);
		    return(1);
		}
		p = (p * 10) + *cp - '0';
	    }
	    if (*cp)
		cp++;
	/*
	 * Don't enter duplicates.
	 */
	    for (i = 0; i < NPid; i++) {
		if (Pid[i] == p)
		    break;
	    }
	    if (i < NPid)
		continue;
	/*
	 * Allocate Pid table space, as required.
	 */
	    if (NPid >= na) {
		na += PIDAU;
		len = (size_t)(na * sizeof(pid_t));
		if (Pid)
		    Pid = (unsigned long *)realloc(Pid, len);
		else
		    Pid = (unsigned long *)malloc(len);
		if (!Pid) {
		    (void) fprintf(stderr,
			"%s: no space for %d PID numbers\n",
			Pn, na);
		}
	    }
	/*
	 * Store PID.
	 */
	    Pid[NPid++] = p;
	}
	return(0);
}


/*
 * isnullstr() -- is it a null string?
 */

static char *
isnullstr(s)
	char *s;			/* string pointer */
{
	if (!s)
		return((char *)NULL);
	while (*s) {
		if (*s != ' ')
			return(s);
		s++;
	}
	return((char *)NULL);
}


/*
 * usage() -- display usage and exit
 */

void
usage(xv)
	int xv;				/* exit value */
{
	char *cp, *cp1, *cp2;

	if (Ohelp || xv) {

	/*
	 * Display basic usage in response to -h or error.
	 */
	  (void) fprintf(stderr,
	    "%s %s usage: [-abhnOvw] [-p pid] [-i netaddr] %s[-S tm] [paths]\n",
	    Pn, LSLK_VERSION,

#if	defined(HASKOPT)
	    "[-k nlist] "
#else	/* !defined(HASKOPT) */
	    ""
#endif	/* defined(HASKOPT) */

	    );
	}
	if (Ohelp) {

	/*
	 * Display extensive usage in response to -h.
	 */
	  (void) fprintf(stderr,
	    "  -a          AND selection options\n");
	  (void) fprintf(stderr,
	    "  -b          avoid kernel blocks\n");
	  (void) fprintf(stderr,
	    "  -h          display help (this output)\n");
	  (void) fprintf(stderr,
	    "  -i netaddr  list locks from specified host name or address\n");
	  (void) fprintf(stderr,
	    "              (specify more netaddr's with more -i options)\n");

#if	defined(HASKOPT)
	  (void) fprintf(stderr,
	    "  -k nlist    set kernel name list path (default = %s)\n",
	    Nmlst ? Nmlst

# if	defined(N_UNIX)
	          : N_UNIX
# else	/* !defined(N_UNIX) */
	          : (Nmlst = get_nlist_path(1)) ? Nmlst
						: "not yet determined"
# endif	/* defined(N_UNIX) */
	    );
#endif	/* defined(HASKOPT) */

	  (void) fprintf(stderr,
	    "  -O          avoid fork overhead *RISKY*\n");
	  (void) fprintf(stderr,
	    "  -S tm       readlink()/stat() timeout (default = %d)\n",
	    TMLIMIT);
	  (void) fprintf(stderr,
	    "  -p pid      list locks for comma-separated PID number list\n");
	  (void) fprintf(stderr,
	    "  -n          don't convert host names to addresses\n");
	  (void) fprintf(stderr,
	    "  -v          display version information\n");
	  (void) fprintf(stderr,
	    "  -w          suppress warning messages\n");
	  (void) fprintf(stderr,
	    "  paths       list locks on specified file path(s)\n");
	}
	if (Overs) {

	/*
	 * Display version information in response to -v.
	 */
	  (void) fprintf(stderr, "%s version information:\n", Pn);
	  (void) fprintf(stderr, "\trevision: %s\n", LSLK_VERSION);
	  if ((cp = isnullstr(LSLK_CCDATE)))
	    (void) fprintf(stderr, "\tconstructed: %s\n", cp);
	  cp = isnullstr(LSLK_HOST);
	  if (!(cp1 = isnullstr(LSLK_LOGNAME)))
	  cp1 = isnullstr(LSLK_USER);
	  if (cp || cp1) {
	    if (cp && cp1)
	      cp2 = "by and on";
	    else if (cp)
	      cp2 = "on";
	    else
	      cp2 = "by";
	    (void) fprintf(stderr, "\tconstructed %s: %s%s%s\n",
	      cp2, cp1 ? cp1 : "", cp1 ? "@" : "", cp  ? cp  : "");
	  }
	  if ((cp = isnullstr(LSLK_CC)))
	    (void) fprintf(stderr, "\tcompiler: %s\n", cp);
	  if ((cp = isnullstr(LSLK_CCV)))
	    (void) fprintf(stderr, "\tcompiler version: %s\n", cp);
	  if ((cp = isnullstr(LSLK_CCFLAGS)))
	    (void) fprintf(stderr, "\tcompiler flags: %s\n", cp);
	  if ((cp = isnullstr(LSLK_LDFLAGS)))
	    (void) fprintf(stderr, "\tloader flags: %s\n", cp);
	  if ((cp = isnullstr(LSLK_SYSINFO)))
	    (void) fprintf(stderr, "\tsystem info: %s\n", cp);
	}
	Exit(xv);
}
