#ifndef _UTILS_H_
#define _UTILS_H_

#include <stdio.h>
#include <gtk/gtk.h>

#if defined(G_DIR_SEPARATOR)
# define DIR_SEP  G_DIR_SEPARATOR
#else
# warning "G_DIR_SEPARATOR is not defined"
# define DIR_SEP  '/'
#endif

#ifdef WORDS_BIGENDIAN
#define BSWAP16(x) ((((x) & 0xff) << 8) | (((x) >> 8) & 0xff))
#define BSWAP32(x) (((x) << 24) | (((x) & 0x0000ff00) << 8) | ((x) >> 24) | (((x) & 0x00ff0000) >> 8))
#else
#define BSWAP16(x) (x)
#define BSWAP32(x) (x)
#endif

#if __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ > 4)
# define ATTR_UNUSED __attribute__((unused))
# define ATTR_NORETURN __attribute__((noreturn))
# define ATTR_PRINTFLIKE(fmt,var) __attribute__((format(printf,fmt,var)))
#else
# define ATTR_UNUSED
# define ATTR_NORETURN
# define ATTR_PRINTFLIKE(fmt,var)
#endif

#define l_strcasecmp    g_strcasecmp
#define l_strncasecmp   g_strncasecmp
#define l_malloc        g_malloc
#define l_free          g_free
#define l_strdup        g_strdup
#define l_strdup_printf g_strdup_printf
#define l_realloc       g_realloc

#ifndef INADDR_NONE
#define INADDR_NONE ((u_long)-1)
#endif


unsigned long extract_bytes    (char* string);
int           extract_duration (char* string);

char* print_bytes      (char *str, unsigned long bytes);
char* print_duration   (char* str, int seconds);
char* print_size       (char *str, double bytes);
char* print_time_short (char *str, int secs);
char* print_time       (char *str, int secs);
char* print_time_unit  (char *str, int secs);
char* print_speed      (char *str, long bytes, int withdot);

char* get_last_dir          (char *filename);
char* get_file_name         (char *filename);
char* get_short_name        (char *longname);
char* local_to_napster      (char *name);
char* unix_to_win           (char *name);
char* local_to_napster_hide (char *name);
char* napster_to_local      (char *name);
void  convert_local_name    (char *fname);
void  convert_quotes        (char *string);
char* rename_file           (char *filename);

char* arg        (char *data, int flags);
void  qfprintf   (FILE *f, const char *fmt, ...);
char* mfgets     (char *buf, int size, FILE *f);
int   create_dir (char *dir);

#endif
