/* Copyright (C) 2000/2001 sgop@users.sourceforge.net
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include "support.h"

// show the splash screen
GtkWidget *splash_screen(void)
{
  GtkWidget *splash_win;
  GtkWidget *pixmap;
  GtkWidget *frame;
  GtkWidget *frame2;
  GtkWidget *vbox;
  GtkWidget *label;
  GtkWidget *progressbar;

  splash_win = gtk_window_new(GTK_WINDOW_DIALOG);
  gtk_window_set_title(GTK_WINDOW(splash_win), "Lopster");
  gtk_window_set_policy(GTK_WINDOW(splash_win), FALSE, FALSE, TRUE);
  gtk_widget_realize(splash_win);
  if (splash_win->window)
    gdk_window_set_decorations(splash_win->window, 0);

  // center it on the screen
  gtk_window_set_position(GTK_WINDOW(splash_win), GTK_WIN_POS_CENTER);

  frame2 = gtk_frame_new(NULL);
  gtk_widget_show(frame2);
  gtk_container_add(GTK_CONTAINER(splash_win), frame2);
  gtk_frame_set_shadow_type(GTK_FRAME(frame2), GTK_SHADOW_OUT);

  frame = gtk_frame_new(NULL);
  gtk_widget_show(frame);
  gtk_container_add(GTK_CONTAINER(frame2), frame);
  gtk_container_set_border_width(GTK_CONTAINER(frame), 5);
  gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_IN);

  vbox = gtk_vbox_new(FALSE, 0);
  gtk_widget_show(vbox);
  gtk_container_add(GTK_CONTAINER(frame), vbox);

  pixmap = create_pixmap(splash_win, "logo1.xpm");
  gtk_box_pack_start(GTK_BOX(vbox), pixmap, TRUE, TRUE, 0);
  gtk_widget_show(pixmap);

  label = gtk_label_new("");
  gtk_widget_show(label);
  gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);
  gtk_object_set_data(GTK_OBJECT(splash_win), "label", label);

  progressbar = gtk_progress_bar_new();
  gtk_widget_show(progressbar);
  gtk_box_pack_start(GTK_BOX(vbox), progressbar, FALSE, FALSE, 0);
  gtk_progress_configure(GTK_PROGRESS(progressbar), 0, 0, 10);
  gtk_object_set_data(GTK_OBJECT(splash_win), "progress", progressbar);

  gtk_widget_show(splash_win);

  // force it to draw now.
  gdk_flush();

  // go into main loop, processing events.
  while (gtk_events_pending() || !GTK_WIDGET_REALIZED(pixmap))
    gtk_main_iteration();

  return splash_win;
}
