package Lire::Config::StringSpec;


=pod

=head1 NAME

Lire::Config::StringSpec - String parameter.

=head1 DESCRIPTION


Lire::Config::TypeSpec that represents any string of characters Values
of this type can be any string. The specification can have a
'valid-re' attribute which will make sure that the value matches the
given regular expression.

=cut

use base qw/Lire::Config::ScalarSpec/;

=pod

=head2 new( 'name' => $name, [ 'valid-re' => $valid_re ], ... );

Creates a new StringSpec. The 'valid-re' parameter can be used
to initialize the valid_re attribute.

=cut

sub new {
    my $self = shift->SUPER::new( @_ );
    my %args = @_;

    $self->valid_re( $args{'valid-re'} )
      if exists $args{'valid-re'};

    return $self;
}

=pod

=head2 valid_re( [ $new_valid_re ] )

Returns (and optionally change) the validation regular expression that
values from this spec should match.

=cut

sub valid_re {
    my $self = $_[0];

    if ( @_ == 2 ) {
        $self->{'_valid_re'} = $_[1];
        $self->{'_compiled_re'} = defined $_[1] ? qr/$_[1]/ : undef;
    }

    return $self->{'_valid_re'};
}

sub is_valid {
    my ( $self, $value ) = @_;

    return !$self->required() unless defined $value;

    return 1 unless defined $self->{'_compiled_re'};

    return scalar $value =~ /$self->{'_compiled_re'}/;
}

sub normalize {
    return $_[1];
}

1;
__END__

=pod

=head1 VERSION

$Id: StringSpec.pm,v 1.3 2004/07/21 21:28:30 flacoste Exp $

=head1 AUTHORS

Francis J. Lacoste <flacoste@logreport.org>
Wessel Dankers <wsl@logreport.org>
Wolfgang Sourdeau <wolfgang@logreport.org>

=head1 COPYRIGHT

Copyright (C) 2002-2004  Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=cut
