/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "JT6MLevelGraph.h"

#include "jt6m/JT6MDefs.h"

BEGIN_EVENT_TABLE(CJT6MLevelGraph, wxWindow)
	EVT_PAINT(CJT6MLevelGraph::onPaint)
END_EVENT_TABLE()

CJT6MLevelGraph::CJT6MLevelGraph(wxWindow* parent, int id, const wxPoint& pos, const wxSize& size, long style, const wxString& name) :
wxWindow(parent, id, pos, size, style, name),
m_bitmap(NULL),
m_palette(NULL)
{
	m_bitmap = new wxBitmap(JT6M_GRAPH_WIDTH, JT6M_GRAPH_HEIGHT);

	createPalette();

	// Flood the graph area with black to start with
	clearGraph();
}

CJT6MLevelGraph::~CJT6MLevelGraph()
{
	delete   m_bitmap;
	delete[] m_palette;
}

void CJT6MLevelGraph::addData(CJT6MLevels* levels)
{
	wxASSERT(levels != NULL);

	clearGraph();

	wxMemoryDC memoryDC;
	memoryDC.SelectObject(*m_bitmap);
	memoryDC.BeginDrawing();

	const int thirdHeight = JT6M_GRAPH_HEIGHT / 3;

	int lastAudioX = 0, lastSyncX = 0;
	int lastAudioY = 0, lastSyncY = 0;

	for (int x = 0; x < JT6M_GRAPH_WIDTH; x++) {
		for (int n = 0; n < (JT6M_ALPHABET_COUNT + 1); n++) {
			double level = levels->getSpectrumData(n, x);

			int y = JT6M_GRAPH_HEIGHT - (2 * thirdHeight) - n * 2;

			int col = int((double(JT6M_NUM_COLOURS) / 200.0) * level);

			if (col >= JT6M_NUM_COLOURS)
				col = JT6M_NUM_COLOURS - 1;

			if (col < 0)
				col = 0;

			wxPen pen(*m_palette[col], 1, wxSOLID);
			wxBrush brush(*m_palette[col], wxSOLID);

			memoryDC.SetPen(pen);
			memoryDC.SetBrush(brush);
			memoryDC.DrawRectangle(x, y, 1, 1);
		}

		double audio = levels->getAudioData(x);

		int yAudio = (0 * thirdHeight) + int(audio * double(thirdHeight));

		if (yAudio > (1 * thirdHeight))
			yAudio = 1 * thirdHeight - 1;

		int y = JT6M_GRAPH_HEIGHT - yAudio;

		if (x > 0) {
			memoryDC.SetPen(*wxGREEN_PEN);
			memoryDC.DrawLine(lastAudioX, lastAudioY, x, y);
		}

		lastAudioX = x;
		lastAudioY = y;

		double sync = levels->getSyncData(x);

		int ySync = (1 * thirdHeight) + int(sync * double(thirdHeight));

		if (ySync > (2 * thirdHeight))
			ySync = 2 * thirdHeight - 1;

		y = JT6M_GRAPH_HEIGHT - ySync;

		if (x > 0) {
			memoryDC.SetPen(*wxRED_PEN);
			memoryDC.DrawLine(lastSyncX, lastSyncY, x, y);
		}

		lastSyncX = x;
		lastSyncY = y;
	}

	memoryDC.EndDrawing();
	memoryDC.SelectObject(wxNullBitmap);

	wxClientDC clientDC(this);
	show(clientDC);
}

void CJT6MLevelGraph::onPaint(wxPaintEvent& event)
{
	wxPaintDC dc(this);

	show(dc);
}

void CJT6MLevelGraph::show(wxDC& dc)
{
	dc.BeginDrawing();
	dc.DrawBitmap(*m_bitmap, 0, 0, false);
	dc.EndDrawing();
}

void CJT6MLevelGraph::createPalette()
{
	m_palette = new wxColour*[JT6M_NUM_COLOURS];

	int val = 255 / JT6M_NUM_COLOURS;

	for (int i = 0; i < JT6M_NUM_COLOURS; i++) {
		int r = i * val + val;
		int g = i * val + val;
		int b = i * val + val;

		m_palette[i] = new wxColour(r, g, b);
	}
}

void CJT6MLevelGraph::clearGraph()
{
	// Flood the graph area with black to start with
	wxMemoryDC dc;
	dc.SelectObject(*m_bitmap);
	dc.BeginDrawing();

	dc.SetBackground(*wxBLACK_BRUSH);
	dc.Clear();

	dc.EndDrawing();
}
