/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "JT6MLevels.h"

#include <wx/wx.h>

#include "JT6MDefs.h"

#include "common/Average.h"

CJT6MLevels::CJT6MLevels() :
m_audioData(NULL),
m_syncData(NULL),
m_spectrumData(),
m_level(Audio_OK)
{
	m_audioData = new double[JT6M_GRAPH_WIDTH];
	m_syncData  = new double[JT6M_GRAPH_WIDTH];
	for (int i = 0; i < (JT6M_ALPHABET_COUNT + 1); i++)
		m_spectrumData[i] = new double[JT6M_GRAPH_WIDTH];

	for (int i = 0; i < JT6M_GRAPH_WIDTH; i++) {
		m_audioData[i] = 0.0;
		m_syncData[i]  = 0.0;

		for (int j = 0; j < (JT6M_ALPHABET_COUNT + 1); j++)
			m_spectrumData[j][i] = 0.0;
	}
}

CJT6MLevels::~CJT6MLevels()
{
	delete[] m_audioData;
	delete[] m_syncData;

	for (int i = 0; i < (JT6M_ALPHABET_COUNT + 1); i++)
		delete[] m_spectrumData[i];
}

void CJT6MLevels::setAudioData(double* data, int count)
{
	wxASSERT(data != NULL);
	wxASSERT(count > 0);

	double scale = double(JT6M_GRAPH_WIDTH) / double(JT6M_MAX_AUDIO_DATA);

	fillinData(data, count, scale, m_audioData);
}

void CJT6MLevels::setSyncData(double* data, int count)
{
	wxASSERT(data != NULL);
	wxASSERT(count > 0);

	double scale = double(JT6M_GRAPH_WIDTH) / double(count);

	fillinData(data, count, scale, m_syncData);
}

void CJT6MLevels::setSpectrumData(int n, double* data, int count)
{
	wxASSERT(n >= 0 && n < (JT6M_ALPHABET_COUNT + 1));
	wxASSERT(data != NULL);
	wxASSERT(count > 0);

	double scale = double(JT6M_GRAPH_WIDTH) / double(count);

	fillinData(data, count, scale, m_spectrumData[n]);
}

void CJT6MLevels::setLevel(int level)
{
	m_level = level;
}

double CJT6MLevels::getAudioData(int pixel) const
{
	wxASSERT(pixel >= 0 && pixel < JT6M_GRAPH_WIDTH);

	return m_audioData[pixel];
}

double CJT6MLevels::getSyncData(int pixel) const
{
	wxASSERT(pixel >= 0 && pixel < JT6M_GRAPH_WIDTH);

	return m_syncData[pixel];
}

double CJT6MLevels::getSpectrumData(int n, int pixel) const
{
	wxASSERT(n >= 0 && n < (JT6M_ALPHABET_COUNT + 1));
	wxASSERT(pixel >= 0 && pixel < JT6M_GRAPH_WIDTH);

	return m_spectrumData[n][pixel];
}

int CJT6MLevels::getLevel() const
{
	return m_level;
}

void CJT6MLevels::fillinData(double* data, int count, double scale, double*& member)
{
	int lastPixel = 0;
	CAverage value;

	for (int i = 0; i < count; i++) {
		int pixel = int(scale * double(i));

		if (pixel == lastPixel) {
			value.addValue(data[i] * data[i]);
		} else {
			member[lastPixel] = value.getMaximum();
			value.clear();

			value.addValue(data[i] * data[i]);
			lastPixel = pixel;
		}
	}

	member[lastPixel] = value.getMaximum();
}
