import commands
from linda import libchecks, checks
from linda.funcs import run_external_cmd

class DpkgCheck(libchecks.LindaChecker):
    'Checks that relate to dpkg, or features of it.'
    def check_binary_1(self):
        self.newer_feature()

    def newer_feature(self):
        ar_output = run_external_cmd('ar t %s' % self.file).split('\n')
        for x in ar_output:
            if x in ('data.tar', 'data.tar.bz2'):
                self.signal_error('newer-feature-than-allowed')
        
checks.register(DpkgCheck)
