//
//
// Copyright 2002 Rob Tougher <robt@robtougher.com>
//
// This file is part of xmlrpc.
//
// xmlrpc is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// xmlrpc is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with xmlrpc; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//



#ifndef _threads_thread_group_class_
#define _threads_thread_group_class_


#include <vector>
#include "thread.hpp"


namespace threads
{

  //
  // thread_group - lets you create a variable
  // number of threads, all with the same type
  // of funtion object, _F.
  //
  template<typename _F>
  class thread_group
  {

  public:

    thread_group(){}

    //
    // Destroy all of the objects we created in add_thead()
    //
    ~thread_group()
    {
      for ( std::vector<thread<_F>*>::const_iterator it = m_threads.begin();
	    it != m_threads.end();
	    it++ )
	{
	  thread<_F> * p = (*it);
	  delete p;
	}

      m_threads.clear();
    }


    //
    // create a new thread object on the heap
    // and add it to the vector
    //
    void add_thread ( _F f )
    {
      thread<_F> * p = new thread<_F> ( f );
      m_threads.push_back ( p );
    }

    void join_all ()
    {
      for ( std::vector<thread<_F>*>::const_iterator it = m_threads.begin();
	    it != m_threads.end();
	    it++ )
	{
	  thread<_F> * p = (*it);
	  p->join();
	}
    }

  private:

    std::vector<thread<_F>*> m_threads;

  };

};


#endif
