/***************************************************************************
                           kxeprintsettings.cpp
                           --------------------
    begin                : Tue Dec 02 2003
    copyright            : (C) 2003 by The KXMLEditor Team
    email                : hartig@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kxeprintsettings.h"
#include "kxeprintsettingspage.h"

#include <klocale.h>
#include <kconfig.h>
#include <kfontcombo.h>

#include <qframe.h>
#include <qspinbox.h>
#include <qcheckbox.h>

#define CONF_ENTRY_NAME_FONTFAMILY "Print font family"
#define DFLT_VALUE_FONTFAMILY "Courier"

#define CONF_ENTRY_NAME_FONTSIZE "Print font size"
#define DFLT_VALUE_FONTSIZE 10

#define CONF_ENTRY_NAME_INDENT_STEPS "Print indentation"
#define DFLT_VALUE_INDENT_STEPS 2

#define CONF_ENTRY_NAME_WITH_FOOTER "Print has footer"
#define DFLT_VALUE_WITH_FOOTER true

#define CONF_ENTRY_NAME_WITH_HEADER "Print has header"
#define DFLT_VALUE_WITH_HEADER true


KXEPrintSettings::KXEPrintSettings( QObject * pParent, const char * pszName )
 : KXESettings( "Print Settings", pParent, pszName ),
   m_strFontFamily( DFLT_VALUE_FONTFAMILY ),
   m_iFontSize( DFLT_VALUE_FONTSIZE ),
   m_iIndentSteps( DFLT_VALUE_INDENT_STEPS ),
   m_bWithHeader( DFLT_VALUE_WITH_FOOTER ),
   m_bWithFooter( DFLT_VALUE_WITH_HEADER ),
   m_pDialogPage(0)
{
}


void KXEPrintSettings::write( KConfig * pConfig ) const
{
	pConfig->writeEntry( CONF_ENTRY_NAME_FONTFAMILY, m_strFontFamily );
	pConfig->writeEntry( CONF_ENTRY_NAME_FONTSIZE, m_iFontSize );
	pConfig->writeEntry( CONF_ENTRY_NAME_INDENT_STEPS, m_iIndentSteps );
	pConfig->writeEntry( CONF_ENTRY_NAME_WITH_FOOTER, m_bWithHeader );
	pConfig->writeEntry( CONF_ENTRY_NAME_WITH_HEADER, m_bWithFooter );
}


void KXEPrintSettings::read( const KConfig * pConfig )
{
	m_strFontFamily = pConfig->readEntry( CONF_ENTRY_NAME_FONTFAMILY, DFLT_VALUE_FONTFAMILY );
	m_iFontSize = pConfig->readNumEntry( CONF_ENTRY_NAME_FONTSIZE, DFLT_VALUE_FONTSIZE );
	m_iIndentSteps = pConfig->readNumEntry( CONF_ENTRY_NAME_INDENT_STEPS, DFLT_VALUE_INDENT_STEPS );
	m_bWithHeader = pConfig->readBoolEntry( CONF_ENTRY_NAME_WITH_FOOTER, DFLT_VALUE_WITH_FOOTER );
	m_bWithFooter = pConfig->readBoolEntry( CONF_ENTRY_NAME_WITH_HEADER, DFLT_VALUE_WITH_HEADER );
}

QString KXEPrintSettings::dialogPageName() const
{
	return i18n( "Printing" );
}

QString KXEPrintSettings::dialogPageHeader() const
{
	return i18n( "Print Settings" );
}

QString KXEPrintSettings::dialogPageIcon() const
{
	return "printer2";
}

QWidget * KXEPrintSettings::dialogPage( QFrame * pParent )
{
	if ( ! m_pDialogPage )
	{
		// create the page if necessary
		m_pDialogPage = new KXEPrintSettingsPage( pParent, "printing config.dialog page" );

		// and fill its widgets with the corresponding values
		updatePage();

		connect( m_pDialogPage->m_pFontFamily, SIGNAL(activated(int)), this, SIGNAL(sigDialogPageChanged()) );
		connect( m_pDialogPage->m_pFontSize, SIGNAL(valueChanged(int)), this, SIGNAL(sigDialogPageChanged()) );
		connect( m_pDialogPage->m_pIndentSteps, SIGNAL(valueChanged(int)), this, SIGNAL(sigDialogPageChanged()) );
		connect( m_pDialogPage->m_pWithHeader, SIGNAL(toggled(bool)), this, SIGNAL(sigDialogPageChanged()) );
		connect( m_pDialogPage->m_pWithFooter, SIGNAL(toggled(bool)), this, SIGNAL(sigDialogPageChanged()) );
	}

	return m_pDialogPage;
}


void KXEPrintSettings::setFromPage()
{
	if ( m_pDialogPage )
	{
		m_strFontFamily = m_pDialogPage->m_pFontFamily->currentText();
		m_iFontSize = m_pDialogPage->m_pFontSize->value();
		m_iIndentSteps = m_pDialogPage->m_pIndentSteps->value();
		m_bWithHeader = m_pDialogPage->m_pWithHeader->isChecked();
		m_bWithFooter = m_pDialogPage->m_pWithFooter->isChecked();
	}
}

void KXEPrintSettings::updatePage() const
{
	if ( m_pDialogPage )
	{
		m_pDialogPage->m_pFontFamily->setCurrentFont( m_strFontFamily );
		m_pDialogPage->m_pFontSize->setValue( m_iFontSize );
		m_pDialogPage->m_pIndentSteps->setValue( m_iIndentSteps );
		m_pDialogPage->m_pWithHeader->setChecked( m_bWithHeader );
		m_pDialogPage->m_pWithFooter->setChecked( m_bWithFooter );
	}
}
