/***************************************************************************
                          kxe_viewattributes.cpp  -  description
                             -------------------
    begin                : Thu Nov 22 2001
    copyright            : (C) 2001, 2002, 2003 by The KXMLEditor Team
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kxe_viewattributes.h"

#include "kxeattributedialog.h"

#include <kmessagebox.h>
#include <kdebug.h>
#include <klocale.h>

KXE_ViewAttributes::KXE_ViewAttributes( QWidget * pParent, const char * pszName )
	: QTable( 0, 3, pParent, pszName )
{
	horizontalHeader()->setLabel( 0, i18n("Namespace") );
	horizontalHeader()->setLabel( 1, i18n("Name") );
	horizontalHeader()->setLabel( 2, i18n("Value") );

	setColumnReadOnly( 0, true );
	setColumnReadOnly( 1, true );
	setColumnReadOnly( 2, true );

	connect( this, SIGNAL(valueChanged(int,int)), this, SLOT(slotItemRenamedInplace(int,int)) );
}

QDomAttr KXE_ViewAttributes::getSelectedAttribute() const
{
	if ( currentRow() == -1 )
		return QDomAttr();

	if ( m_domElement.attributes().item(currentRow()).isAttr() )
	{
		return m_domElement.attributes().item(currentRow()).toAttr();
	}
	else
		return QDomAttr();
}

void KXE_ViewAttributes::setReadWrite( bool fReadWrite )
{
	setColumnReadOnly( 1, ! fReadWrite );
  setColumnReadOnly( 2, ! fReadWrite );

	if ( fReadWrite )
		connect( this, SIGNAL(contextMenuRequested(int,int,const QPoint&)), this, SLOT(slotContextMenuRequested(int,int,const QPoint&)) );
	else
		disconnect( this, SIGNAL(contextMenuRequested(int,int,const QPoint&)), this, SLOT(slotContextMenuRequested(int,int,const QPoint&)) );
}

void KXE_ViewAttributes::slotContextMenuRequested( int nRow, int nCol, const QPoint & pos )
{
	nCol = nCol;
	QString szMenuName = ( nRow == -1 ) ? "popupXmlAttributes" : "popupXmlAttribute";
	emit sigContextMenuRequested( szMenuName, pos );
}

void KXE_ViewAttributes::slotChange( const QDomElement & element )
{
	m_domElement = element;

	uint iLength = m_domElement.attributes().length();
	setNumRows( iLength );

	if ( iLength > 0 )
	{
		for ( uint iRow = 0; iRow < iLength; iRow++ )
		{
			QDomNode node = m_domElement.attributes().item(iRow);
			if ( node.isAttr() )
			{
        setText( iRow, 0, node.toAttr().namespaceURI() );
				setText( iRow, 1, node.toAttr().name() );
				setText( iRow, 2, node.toAttr().value() );
				adjustRow( iRow );
			}
			else
				kdError() << "KXE_ViewAttributes::slotChange: node is not an attribute (but should be)" << endl;
		}

    adjustColumn(0);
    adjustColumn(1);
    adjustColumn(2);
	}
}

void KXE_ViewAttributes::slotItemRenamedInplace( int nRow, int nCol )
{
	if ( nCol < 1) // only attributes names and values are changeable
	{
		kdError() << "KXMLEditor " << k_funcinfo << " column " << nCol << " should be unchangeable" << endl;
		return;
	}

	QDomNode node = m_domElement.attributes().item(nRow);
	if ( node.isAttr() )
	{ if (nCol == 1)
    {
      // check if name is OK
      QString strMessage = KXEAttributeDialog::checkName(text(nRow,nCol));
      if(strMessage.length() > 0)
        {
          // restore old name
          setText( nRow, 1, node.toAttr().name() ); // set old name
          KMessageBox::sorry(this, strMessage);
          return;
        }
        
      // check, if new name not exists in attributes list
      if(m_domElement.attributes().contains(text(nRow,nCol)) == false)
      {      
        if ( node.toAttr().name() != text(nRow,nCol) )      // only if the name really was changed
        {
          emit sigAttributeNameChangedInplace(node.toAttr(), text(nRow,nCol) );
        }
      }
      else
      {
        KMessageBox::sorry(this, i18n("Attribute name already exists !"));
        setText( nRow, 1, node.toAttr().name() ); // set old name
        return;
      }
    }
    else
    {
      if ( node.toAttr().value() != text(nRow,nCol) )     // only if the value really was changed
      {                     
        // check if value is OK
        QString strMessage = KXEAttributeDialog::checkValue(text(nRow,nCol));
        if(strMessage.length() > 0)
        {
          // restore old value
          setText( nRow, 2, node.toAttr().value() ); // set old value
          KMessageBox::sorry(this, strMessage);
          return;
        }

        emit sigAttributeValueChangedInplace( node.toAttr(), text(nRow, nCol) );
      }
    }
	}
	else
		kdError() << "KXMLEditor " << k_funcinfo << " node is not an attribute (but should be)" << endl;
}
