/***************************************************************************
                          commandplugin.cpp  -  description
                             -------------------
    begin                : Son Jan 5 2003
    copyright            : (C) 2003 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "commandplugin.h"

// QT includes
#include <qcheckbox.h>
#include <qlabel.h>
#include <qlayout.h>

// KDE includes
#include <kapplication.h>
#include <kconfig.h>
#include <kiconloader.h>
#include <klocale.h>
#include <klineedit.h>
#include <klistbox.h>
#include <kmessagebox.h>
#include <kpushbutton.h>
#include <kprocess.h>

const QString CommandPlugin::getName() const
{
    return i18n("Command Plugin");
}

const QString CommandPlugin::getAccelName() const
{
    return i18n("&Command Plugin");
}

const int CommandPlugin::type() const
{
    return TYPE_FINAL_FILE;
}

bool CommandPlugin::checkError()
{
    if( commandline->text().isEmpty() ) {
        KMessageBox::error( 0, i18n("You did not specify a command to execute.") );
        return false;
    }

    return true;
}

void CommandPlugin::drawInterface( QWidget* w, QVBoxLayout* l )
{
    QHBoxLayout* hb = new QHBoxLayout( 0, 0, 6 );
    QVBoxLayout* vb = new QVBoxLayout( 0, 0, 6 );

    QLabel* la = new QLabel( w );
    la->setText( i18n("<b>Command Plugin</b>") );
    l->addWidget( la );

    la = new QLabel( w );
    la->setText( i18n( "<qt>Executes a shell command on every file after it has been renamed. "
                       "Add %1 to the command line arguments to get the filename of the renamed file.</qt>") );
    l->addWidget( la );
    l->addWidget( new QLabel( i18n("Command:"), w ) );

    commandline = new KLineEdit( w );
    l->addWidget( commandline );

    checkNoBlock = new QCheckBox( i18n("&Execute without blocking (not recommended)"), w );
    l->addWidget( checkNoBlock );

    buttonAdd = new KPushButton( i18n("&Add"), w );
    buttonRemove = new KPushButton( i18n("&Remove"), w );
    hb->addWidget( buttonAdd );
    hb->addWidget( buttonRemove );

    vb->addLayout( hb );

    list = new KListBox( w );
    vb->addWidget( list );
    vb->setStretchFactor( list, 2 );
    l->addLayout( vb );

    connect( buttonAdd, SIGNAL( clicked() ), this, SLOT( add() ) );
    connect( buttonRemove, SIGNAL( clicked() ), this, SLOT( remove() ) );
    connect( list, SIGNAL( executed( QListBoxItem* ) ), this, SLOT( exec() ) );

    KConfig* conf = kapp->config();
    conf->setGroup("CommandPlugin");
    list->insertStringList( conf->readListEntry("commandlines" ) );
    
    QStringList examples;
    examples.append( "chmod 0444 %1" );
    examples.append( "convert %1 %1.png" );
    examples.append( "echo %1 >> $HOME/file.list" );
//    examples.append( ")    
    for( unsigned int i = 0; i < examples.count(); i++ )
        if( !list->findItem( examples[i] ) )
            list->insertItem( examples[i] );
}

void CommandPlugin::fillStructure()
{
    command = commandline->text();
    noblock = checkNoBlock->isChecked();
}

QString CommandPlugin::processFile( BatchRenamer* b, int i, QString, int )
{
    QString filename = b->files()[i].dst.name;
    

    QString c = command;
       
    KShellProcess proc;
#if QT_VERSION >= 0x030100
    c = c.replace( "%1", KShellProcess::quote( filename ) );
#else
    int pos = 0;
    do {
       pos = c.find( "%1", pos );
       if( pos >= 0 )
           c.replace( pos, 2, KShellProcess::quote( filename ) );
    } while ( pos >= 0 );
#endif

    proc << c;
    
    if( noblock )
        proc.start( KProcess::DontCare, KProcess::NoCommunication );
    else
        proc.start( KProcess::Block, KProcess::NoCommunication );

    proc.resume();

    if( !noblock && proc.exitStatus() )
        return command.arg( filename ) + QString( i18n(" exited with error: %1") ).arg( proc.exitStatus() );

    return QString::null;
}

void CommandPlugin::finished()
{
    KConfig* conf = kapp->config();
    conf->setGroup("CommandPlugin");
    QStringList slist;
    for( unsigned int i = 0; i < list->count(); i++ )
        slist.append( list->text( i ) );

    conf->writeEntry("commandlines", slist );
    conf->sync();
    return;
}

void CommandPlugin::add()
{
    if( !commandline->text().isEmpty() ) {
        for( unsigned int i = 0; i < list->count(); i++ )
            if( list->text( i ) == commandline->text() )
                return;

        list->insertItem( commandline->text() );
    }
}

void CommandPlugin::remove()
{
    unsigned int i = 0;
    do {
        if(list->isSelected( i ))
            list->removeItem( i );
        else
            i++;
    } while( i < list->count() );
}

void CommandPlugin::exec()
{
    for( unsigned int i = 0; i < list->count(); i++ )
        if( list->isSelected( i ) )
            commandline->setText( list->text( i ) );
}

const QPixmap CommandPlugin::getIcon() const
{
    return kapp->iconLoader()->loadIcon( "konsole", KIcon::Small );
}

