/***************************************************************************
                          plugin_katespeaker.cpp  -  description
                             -------------------
    begin                :  07 17 2001
    copyright            : (C) 2001 by Matteo Merli
    email                : merlim@libero.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "plugin_katespeaker.h"

#include <kaction.h>
#include <kinstance.h>
#include <kmessagebox.h>
#include <klocale.h>
//#include <cassert>
//#include <kdebug.h>
#include <kprocess.h>
#include <kprocio.h>
#include <qstring.h>

class PluginView : public KXMLGUIClient
{
friend class PluginKateSpeaker;

public:
	Kate::MainWindow* win;
};

extern "C"
{
	void* init_libkatespeakerplugin() {
		return new KatePluginFactory;
	}
}

KatePluginFactory::KatePluginFactory()
{
	s_instance = new KInstance( "kate" );
}

KatePluginFactory::~KatePluginFactory()
{
	delete s_instance;
}

QObject* KatePluginFactory::createObject( QObject* parent, const char* name, const char*, const QStringList & )
{
	return new PluginKateSpeaker( parent, name );
}

KInstance* KatePluginFactory::s_instance = 0L;

PluginKateSpeaker::PluginKateSpeaker( QObject* parent, const char* name )
	: Kate::Plugin ( (Kate::Application*)parent, name )
{
}

PluginKateSpeaker::~PluginKateSpeaker()
{
}

void PluginKateSpeaker::addView(Kate::MainWindow *win)
{
	PluginView *view = new PluginView ();

	(void)  new KAction ( i18n("&Speak selection..."), ALT + Key_Plus, this,
					SLOT( slotSpeak() ), view->actionCollection(), "speak_selection" );

	view->setInstance( new KInstance("kate") );
	view->setXMLFile( "plugins/katespeaker/ui.rc" );
	win->guiFactory()->addClient( view );
	view->win = win;

	m_views.append( view );
}

void PluginKateSpeaker::removeView(Kate::MainWindow* win)
{
	for (uint z=0; z < m_views.count(); z++)
		if (m_views.at(z)->win == win) {
			PluginView *view = m_views.at(z);
			m_views.remove(view);
			win->guiFactory()->removeClient(view);
			delete view;
		}
}

void PluginKateSpeaker::slotSpeak()
{
	Kate::Document *kd=application()->documentManager()->activeDocument();
	if (!kd) return;

	QString query = kd->selection();

	if ((query == QString::null) || (query == 0) ) {
		QString title = i18n( "No selected Text" );
		QString text = i18n( "There was no text selected to read, please "
						"correct it and try again" );
		KMessageBox::sorry( 0L, text, title );
		return;
	}

	KProcIO process;
        process << "festival"
		<< "--tts";

	process.start(KProcess::DontCare);
	process.writeStdin(query);
}

#include "plugin_katespeaker.moc"

