/* @(#) module.h 1.12 @(#) */
/***************************************************************\
*	Copyright (c) 1999-2000 First Step Internet Services, Inc.
*		All Rights Reserved
*
*	Module: KOALAMOD
\***************************************************************/

#ifndef _KOALAMUD_MODULE_H
#define _KOALAMUD_MODULE_H "@(#) nitehawk@winghove.1ststep.net|include/module.h|20001105044148|01889 @(#)"

/* Ensure config.h is included */
#include "all.h"
#include "koalatypes.h"

/* This type defines the various module types that are possible */
typedef enum {
	MODTYPE_NULL = 0,
	MODTYPE_GENERIC,
	MODTYPE_DATABASE,
	MODTYPE_NETWORK,
} modtype_t;

/* Possible errors during module loading */
typedef enum {
	LOADERERR_SUCCESS=0,
	LOADERERR_BADARGS=ERRKOALAMODBASE,
	LOADERERR_NOACCESS,
	LOADERERR_LOADFAIL,
	LOADERERR_BADMOD,
	LOADERERR_NOMEM,
	LOADERERR_STARTUPFAIL,
	LOADERERR_UNKNOWNMOD,
} loadererr_t;

/* This structure is used by various modules to keep track of their current
 * state.  Two values are defined for each state to serve as protection for
 * multithreaded apps
 */
typedef enum {
	MODSTATE_UNDEFINED = 0,
	MODSTATE_STARTUPINPROGRESS,
	MODSTATE_STARTED,
	MODSTATE_LINKUPINPROGRESS,
	MODSTATE_LINKED,
	MODSTATE_SHUTDOWNINPROGRESS,
	MODSTATE_STOPPED,
} modstate_t;

/* This structure is used to describe modules.  Each module should define one
 * of these structures for use in status tracking and startup/linkup/shutdown
 * handling
 */
/* Note:  it is relatively important that the type of function pointer used
 * for this structure does not change.  *If* for some reason it does need to
 * change, Make sure that all modules are updated to reflect the new type
 */
typedef struct TAG_MODULE_T
{
	char *		name;		// Name of the module - for printing
	char *		version;	// Version - Should be SCCS version
	modstate_t	state;
	int (*startupfn)(void);
	int (*linkupfn)(void);
	int (*shutdownfn)(void);
} module_t;
typedef module_t *pmodule;

/* Function pointer table - All APIs need to be listed */
typedef struct FUNCTABLE_T
{
	/* Log Functions */
	void (*logmsg)(logmsgpri, char *, ...);

	/* Buffer Functions */
	koalaerror (*buffer_queue)(pdescriptor, const char *, int);
	koalaerror (*buffer_sendbytes)(pdescriptor, int);
	bool (*buffer_outbufempty)(pdescriptor);
	koalaerror (*buffer_receive)(pdescriptor);
	koalaerror (*buffer_readbytes)(pdescriptor, char *, int *, bool);
	char (*buffer_readchar)(pdescriptor);
	koalaerror (*buffer_readword)(pdescriptor, char *, int);
	koalaerror (*buffer_readline)(pdescriptor, char *, int);
	koalaerror (*buffer_isalinein)(pdescriptor);
	int (*buffer_linesize)(pdescriptor);
	
	/* Configuration Functions */
	koalaerror (*gendefaultconfig)(const char *);
	koalaerror (*readxmlconfig)(const char *);
	koalaerror (*finddaemonconfig)(void);
	koalaerror (*confgetnodeid)(void);
	koalaerror (*confcreatelisten)(listnodeptr);
	koalaerror (*confopenlogs)(void);
	bool (*confquerybackground)(void);
	koalaerror (*confcreateuplink)(listnodeptr);
	koalaerror (*confgetoptions)(void);
	koalaerror (*confgetoptionsfromsection)(char *, confoption_t *, int);
	
	/* Linked List Functions */
	listnodeptr (*listcreate)(void *);
	int (*listaddnode)(listnodeptr, void *);
	int (*listremovenode)(listnodeptr, void *);
	listnodeptr (*listnextnode)(listnodeptr);
	listnodeptr (*listprevnode)(listnodeptr);
	void (*listdestroy)(listnodeptr list);
	void (*listdestroywithfree)(listnodeptr list);
	
	/* Module Functions */
	int (*modstartup)(pmodule *, pmodule, int *, int *);
	int (*modlinkup)(pmodule *, pmodule, int *, int *);
	int (*modshutdown)(pmodule *, pmodule, int *, int *);

} functable_t;
extern functable_t functab;

/* Module info Struct */
typedef struct MODULEINFO_T
{
	koalaoptions *pdopts;
	koalastate *pdstate;
	functable_t *pfunc;
} moduleinfo_t; 
extern moduleinfo_t modinf;

/* This funtion pointer is used to initialize modules with appropriate
 * pointers.
 */
typedef void (*initfunc)(modtype_t type);

/* This structure is used to track loaded modules */
typedef struct {
	char *		path;
	char *		modname;
	void *		modhandle;
	modtype_t	type;
	module_t	module;
	int 		(*startupfunc)(moduleinfo_t *pmodinfo);
} dynmod_t;

/* Define setinal module - List terminator */
extern module_t nullmodule;

/* API */
void modinfoinit(void);
int modstartup(pmodule modlist[], pmodule listend, int *num, int *errors);
int modlinkup(pmodule modlist[], pmodule listend, int *num, int *errors);
int modshutdown(pmodule modlist[], pmodule listend, int *num, int *errors);
loadererr_t loadmodule(char *modname, char *path, modtype_t modtype,
		pdescriptor desc);
loadererr_t unloadmodule(char *modname, pdescriptor desc);
listnodeptr getmodlisthead(void);

/* Init functions */
void initgeneric(modtype_t type);

#endif
