/* @(#) log.h 1.13 @(#) */
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*
*	Module: Log
\***************************************************************/

#ifndef _KOALAMUD_LOG_H
#define _KOALAMUD_LOG_H "@(#) nitehawk@localhost.1ststep.net|include/log.h|20000911023213|58062 @(#)"

#include "koalatypes.h"

#define MAXLOGLINELEN 256

/* Types */
typedef struct TAG_LOGGING_STATUS
{
	bool initialized;
	FILE *handle;
	FILE *msghandle;
	FILE *errhandle;
} logging_status;

/* Message Types */
typedef enum TAG_LOGMSGPRI
{
	LOGEMERG = 0,
	LOGALERT,
	LOGCRIT,
	LOGERR,
	LOGWARN,
	LOGNOTICE,
	LOGINFO,
	LOGDEBUG
} logmsgpri;

/* Prototypes */
void logmsg(logmsgpri priority, char *format, ...);
koalaerror loginit(char *outfname, char *errfname);
koalaerror logpreinit(void);

#endif
