// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************

#ifndef HK_KDECSVexportDIALOG_H
#define HK_KDECSVexportDIALOG_H

#include <qvariant.h>
#include <qdialog.h>
#include <hk_dsvisible.h>
#include <hk_datasource.h>
#include <hk_reportutils.h>
//#include <hk_string>
class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QCheckBox;
class QComboBox;
class QLabel;
class QLineEdit;
class QPushButton;
class QToolButton;
/**
 *
 *@short KDE frontend dialog to export data in CSV format
 *@version $Revision: 1.14 $
 *@author Horst Knorr (hk_classes@knoda.org)
 */
class hk_kdecsvexportdialog : public QDialog  ,public hk_reportcsv
{
    Q_OBJECT

        public:
        hk_kdecsvexportdialog(const QString& table, QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
        ~hk_kdecsvexportdialog();

        QLabel* TextLabel1;
        QLineEdit* filefield;
        QToolButton* filebutton;
        QComboBox* tablelist;
        QLabel* TextLabel3;
        QCheckBox* firstrow;
        QLabel* TextLabel1_3;
        QLineEdit* textdelimiterfield;
        QLabel* TextLabel1_2;
        QLabel* TextLabel2;
        QComboBox* columnseparatorfield;
        QPushButton* buttonOk;
        QPushButton* buttonCancel;
        QPushButton* buttonHelp;

        void set_usetablelist(void);
        void set_usequerylist(void);
        void set_useviewlist(void);
        void set_database(hk_database* d);
    protected slots:
        virtual void filebutton_clicked();
        virtual void buttons_enabled();
        virtual void ok_clicked(void);

    protected:
        QHBoxLayout* hk_kdecsvexportdialogLayout;
        QVBoxLayout* Layout12;
        QHBoxLayout* Layout10;
        QGridLayout* Layout11;
        QVBoxLayout* Layout5;
    private:
//  hk_exportcsv* p_export;
        void set_datasourcelist(void);
        QString      p_file;
        QString   p_tablename;
        QString      p_tab;
	datasourcetype p_datasourcetype;

};
#endif                                            // HK_KDECSVexportDIALOG_H
