/***************************************************************************
                       kmyfirewall.h  -  description
                          -------------------
 begin                : Sun Jan 27 21:17:58 CET 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : a9806056@unet.univie.ac.at
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMYFIREWALL_H
#define KMYFIREWALL_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapplication.h>
#include <qwidget.h>
#include <kmainwindow.h>
#include <kprocess.h>
#include <kconfig.h>
#include <qptrstack.h>
#include <kurl.h>

class KAction;
class KActionMenu;
class KMFOutputViewer;
//class KMFConfigDialog;
class KMFDoc;
class KMFView;
class KMFError;
class KMFErrorHandler;
class KMFRuleEdit;
class KMFNewChainDlg;
class KMFDocOptions;
class QCloseEvent;
class QStringList;
/** KMyFirewall is the base class of the project */
class KMyFirewall : public KMainWindow {
	Q_OBJECT

public:
	/** construtor */
	KMyFirewall( QWidget* parent = 0, const char *name = 0 );
	/** destructor */
	~KMyFirewall();
	KAction* actionQuit;
	KAction* actionNew;
	KAction* actionClose;
	KAction* actionOpen;
	KAction* actionSave;
	KAction* actionSaveAs;
	KAction* actionOutputViewer;
	KAction* actionShowConfig;
	KAction* actionShowFilter;
	KAction* actionShowNat;
	KAction* actionShowMangle;
	KAction* actionPreviewScript;
	KAction* actionStopFw;
	KAction* actionRunFw;
	KAction* actionEditChain;
	KAction* actionNewChain;
	KAction* actionDelChain;
	KAction* actionNewRule;
	KAction* actionDelRule;
	KAction* actionEditDocOptions;
	KAction* actionInstallFW;
	KAction* actionUninstallFW;
	KAction* actionStartWizard;
	KAction* actionExportShellScript;
	KAction* actionLoadTemplate;
	KActionMenu* actionMenu;
	KMFDoc* getDoc();

public slots:    // Public slots
	void slotFileSaveAs();
	void slotFileOpen();
	void slotFileNew();
	void slotFileClose();
	void slotNewRule();
	void slotDelRule();
	void slotNewChain();
	void slotEditChain();
	void slotDelChain();
	void slotEditDocOptions();
	void slotEnableSave();
	void slotLoadDocument( KMFDoc* );
	void slotRestoreSession();
	void slotConfigureKMF();
	void slotCreateFirewallScript();
	void slotCheckStatus();
	void slotInstallFirewall();
	void slotUninstallFirewall();
	void slotShowOutputViewer();
	void slotShowScript();
	void slotShowFilter();
	void slotShowNat();
	void slotShowMangle();
	void slotStartWizard();
	void slotLoadEmptyRuleset();
	void slotExportShellScript();
  void slotLoadTemplate();
	void toggleActions( bool );
	void runFirewall();
	bool hasOpenDoc();
	void slotQuitApp();
	void slotReloadDocument();
protected:
	bool checkRoot();
	void showDisclaimer();
	bool has_open_doc;

protected slots:
	void initMenu();
	void initStatusBar();
	void initView();
	void initActions();
	void resetFirewall();
	void showIPTConfig();
	void slotProcessExited( KProcess * );
	void slotFileSave();
	void toggleToolBar();
	void toggleStatusBar();
private:    // member functions
	KMFError* parseDocument( const KURL& );
	KMFError* saveDocument( const KURL& );

	//++++++++++++++
private:    // data
	KMFError *m_err;
	KMFErrorHandler *m_err_handler;
	KMFDoc* kmfdoc;
	KMFOutputViewer *output_viewer;
	KMFRuleEdit *m_ruleedit;
	KMFNewChainDlg *m_new_chain;
	KMFDocOptions *m_editdoc;

	bool saveQuit();
	void closeEvent ( QCloseEvent * );

signals:
	void documentChanged( KMFDoc * );
	void sigHasDoc( bool );
	void processExited( KProcess * );
	void sigSplashShow( bool );
	void sigSplashShowMsg( const QString& );
};

#endif
