/***************************************************************************
                       kmfchainlvitem.cpp  -  description
                          -------------------
 begin                : Fri Aug 23 2002
 copyright            : (C) 2002 by animal
 email                : animal@shit.orphi.iki
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmfchainlvitem.h"

// QT includes
#include <qstring.h>

// KDE includes
#include <kdebug.h>
#include <kiconloader.h>
#include <kstandarddirs.h>
#include <klocale.h>

//project includes
#include "core/iptchain.h"
#include "core/iptrule.h"
#include "core/kmfdoc.h"
#include "kmfrulelvitem.h"

KMFChainLVItem::KMFChainLVItem( QListView *parent, IPTChain* chain ) : KListViewItem( parent ) {
	//  kdDebug() << "KMFChainLVItem::KMFChainLVItem(KListView *parent) : KListViewItem(parent)" << endl;
	i_chain_allrules = 0;
	loadChain( chain );
}
KMFChainLVItem::KMFChainLVItem( QListView *parent, QListViewItem *after, IPTChain* chain ) : KListViewItem( parent, after ) {
	//  kdDebug() << "KMFChainLVItem::KMFChainLVItem(KListView *parent,KListViewItem *after)" << endl;
	i_chain_allrules = 0;
	loadChain( chain );
}
KMFChainLVItem::KMFChainLVItem( QListViewItem *parent, IPTChain* chain ) : KListViewItem( parent ) {
	//  kdDebug() << "KMFChainLVItem::KMFChainLVItem(KListViewItem *parent)" << endl;
	i_chain_allrules = 0;
	loadChain( chain );
}
KMFChainLVItem::KMFChainLVItem( QListViewItem *parent, QListViewItem *after, IPTChain* chain ) : KListViewItem( parent, after ) {
	//  kdDebug() << "KMFChainLVItem::KMFChainLVItem(KListViewItem *parent,KListViewItem *after)" << endl;
	i_chain_allrules = 0;
	loadChain( chain );
}


KMFChainLVItem::~KMFChainLVItem() {}


void KMFChainLVItem::loadChain( IPTChain *chain ) {
	//	kdDebug() << "void KMFChainLVItem::loadChain(IPChian *chain)" << endl;
	m_chain = chain;
}
IPTChain* KMFChainLVItem::chain() {
	//  kdDebug() << "IPTChain* KMFChainLVItem::chain()" << endl;
	return m_chain;
}
void KMFChainLVItem::setupView() {
	//  kdDebug() << "void KMFChainLVItem::setupView()" << endl;
	loadIcons();
	createChainView( this, m_chain );
}
void KMFChainLVItem::createSmallChainView() {
	loadIcons();
	if ( m_chain ) {
		setText( 0, m_chain->name() );
		if ( m_chain->hasDefaultTarget() ) {
			QString target = m_chain->defaultTarget();
			if ( target == "ACCEPT" ) {
				setPixmap( 1, icon_accept );
			} else if ( target == "DROP" ) {
				setPixmap( 1, icon_drop );
			} else {
				setText( 1, target );
			}
		}
	}
}

void KMFChainLVItem::createChainView( QListViewItem* item, IPTChain *curr_chain ) {
	//	kdDebug() << "void KMFChainLVItem::createChainView(KMFChainLVItem* item,IPTChain *curr_chain)" << endl;
	QPixmap icon_null;
	setText( 0, i18n( "Table:" ) );
	setText( 1, QString::null );
	setPixmap( 1, icon_null );
	setText( 2, curr_chain->table() ->name() );
	//	kdDebug() << "Setting up item: i_chain_rules" << endl;
	KMFChainLVItem *i_chain_rules = new KMFChainLVItem( item, 0, curr_chain );
  if ( curr_chain->isBuildIn() )
		i_chain_rules -> setText( 0, i18n( "Chain:" ) );
  else
    i_chain_rules ->setText( 0, i18n( "Chain Name (User-Defined):" ) ); 
  if ( curr_chain->logging() )
		i_chain_rules -> setPixmap( 1, icon_log );
	else
		i_chain_rules -> setPixmap( 1, icon_null );

	QString chain_name = curr_chain->name();
  i_chain_rules ->setText( 2,chain_name);

	if ( !curr_chain->isBuildIn() ) {
		QString tmp_cmd = curr_chain->createIPTablesChainDefinition();

		//		kdDebug() << "Setting up item: i_chain_cmd" << endl;
		KMFChainLVItem * i_chain_cmd = new KMFChainLVItem( i_chain_rules, i_chain_rules, curr_chain );
		i_chain_cmd->setText( 0, i18n( "Cmd:" ) );
		i_chain_cmd->setPixmap( 1, icon_cmd );
		i_chain_cmd->setText( 2, tmp_cmd );

	}
	// logging+++++++++++++++++++++++++++++++++++++++++++++++++++
	//	kdDebug() << "Setting up item: i_chain_log" << endl;
	bool logging = curr_chain->logging();
  KMFChainLVItem * i_chain_log;
	if ( logging ) {
		i_chain_log = new KMFChainLVItem( i_chain_rules, 0, curr_chain );
		i_chain_log->setOpen( false );
		i_chain_log->setText( 0, i18n( "Chain logging:" ) );
		//    	kdDebug() << "Logging enabled" << endl;
//		i_chain_log->setPixmap( 1, icon_log );
		i_chain_log->setText( 2, i18n( "Droped Packets" ) );
		QString limit = curr_chain->logLimit();
		QString prefix = curr_chain->logPrefix();
		QString burst = curr_chain->logBurst();
		if ( !limit.isEmpty() ) {
			//			kdDebug() << "Setting up item: i_limit" << endl;
			KMFChainLVItem * i_limit = new KMFChainLVItem( i_chain_log, 0, curr_chain );
			i_limit->setOpen( true );
			i_limit->setText( 0, i18n( "Limit rate:" ) );
			i_limit->setText( 2, limit );

			if ( !burst.isEmpty() ) {
				//			 kdDebug() << "Setting up item: i_burst" << endl;
				KMFChainLVItem * i_burst = new KMFChainLVItem( i_chain_log, i_limit, curr_chain );
				i_burst->setOpen( true );
				i_burst->setText( 0, i18n( "Limit burst:" ) );
				i_burst->setText( 2, burst );
			}

		} else {
			//        kdDebug() << "No Loglimit set" << endl;
		}
		if ( !prefix.isEmpty() ) {
			kdDebug() << "Setting up item: i_prefix" << endl;
			KMFChainLVItem* i_prefix = new KMFChainLVItem( i_chain_log, 0, curr_chain );
			i_prefix->setOpen( true );
			i_prefix->setText( 0, i18n( "Log prefix:" ) );
			i_prefix->setText( 2, prefix );
		} else {
			//        kdDebug() << "No Logprefix  set" << endl;
		}
	}

	//  // chain feeds++++++++++++++++++++++++++++++++++++++++++++
	QString str = curr_chain->name();
	QPtrList<IPTRule> feeds = curr_chain->chainFeeds();
	bool buildin = curr_chain->isBuildIn();
	//	kdDebug() << "Setting up item: i_chain_feeds" << endl;
  KMFChainLVItem * i_chain_feeds;
  if ( logging )
		i_chain_feeds = new KMFChainLVItem( i_chain_rules, i_chain_log, curr_chain );
  else
		i_chain_feeds = new KMFChainLVItem( i_chain_rules, i_chain_rules, curr_chain );

	i_chain_feeds->setText( 0, i18n( "Chain Feeds:" ) );
	i_chain_feeds->setOpen( false );
	if ( buildin ) {
		i_chain_feeds->setText( 2, i18n( "System Feed" ) );
	} else {
		int number = feeds.count();
		QString num_feed = i18n( "1 Feed", "%n Feeds", number );
		i_chain_feeds->setText( 2, num_feed );
		IPTRule *curr_rule;
		if ( !feeds.isEmpty() ) {
			i_chain_feeds->setPixmap( 1, icon_feed );
			for ( curr_rule = feeds.last(); curr_rule; curr_rule = feeds.prev() ) {
				//				kdDebug() << "Setting up Rule item: item_feeds" << endl;
				KMFChainLVItem * item_feeds = new KMFChainLVItem( i_chain_feeds, curr_chain );
				item_feeds->setText( 0, i18n( "From chain: %1" ).arg( curr_rule->chain() ->name() ) );
//				item_feeds->setPixmap( 1, icon_feed );
				item_feeds->setPixmap( 2, icon_rule );
				item_feeds->setText( 2, curr_rule->name() );
			}
		}
	}
	//  //chain fwds++++++++++++++++++++++++++++++++++++++++++++++++
	QPtrList<IPTRule> fwds = curr_chain->chainFwds();

	//	kdDebug() << "Setting up item: i_chain_fwds" << endl;
	KMFChainLVItem * i_chain_fwds = new KMFChainLVItem( i_chain_rules, i_chain_feeds, curr_chain );
	i_chain_fwds->setOpen( false );

	int number2 = fwds.count();
	QString num_fwd = i18n( "1 Forward", "%n Forwards", number2 );

	i_chain_fwds->setText( 0, i18n( "Chain forwards:" ) );
	i_chain_fwds->setText( 2, num_fwd );


	if ( !fwds.isEmpty() ) {
		i_chain_fwds->setPixmap( 1, icon_fwds );
		IPTRule * curr_rule;
		for ( curr_rule = fwds.last();curr_rule; curr_rule = fwds.prev() ) {
			//			kdDebug() << "Setting up Rule item: item_fwds" << endl;
			KMFChainLVItem * item_fwds = new KMFChainLVItem( i_chain_fwds, curr_chain );
			item_fwds->setPixmap( 0, icon_rule );
			item_fwds->setText( 0, curr_rule->name() );
			item_fwds->setPixmap( 1, icon_fwd );
			item_fwds->setText( 2, curr_rule->target() );
		}
	}
	//chain rules +++++++++++++++++++++++++++++++++++++++++++++++++++
	QPtrList<IPTRule> tmp_ruleset = curr_chain->chainRuleset();

	//	kdDebug() << "Setting up item: i_chain_allrules" << endl;
	i_chain_allrules = new KMFChainLVItem( i_chain_rules, i_chain_fwds, curr_chain );
	i_chain_allrules->setOpen( TRUE );
	i_chain_allrules->sortChildItems( -1, false );

	int number3 = tmp_ruleset.count();
	QString num_rules = i18n( "1 Rule", "%n Rules", number3 );

	i_chain_allrules->setText( 0, i18n( "Rule(s):" ) );
	i_chain_allrules->setPixmap( 1, icon_rule );
	i_chain_allrules->setText( 2, num_rules );

	if ( !tmp_ruleset.isEmpty() ) {
		IPTRule * curr_rule;
		for ( curr_rule = tmp_ruleset.last(); curr_rule; curr_rule = tmp_ruleset.prev() ) {
			//			kdDebug() << "Setting up Rule item: item_rules" << endl;
			KMFRuleLVItem * item_rules = new KMFRuleLVItem( i_chain_allrules, curr_rule );
			item_rules->setupView();
		}
	}


	i_chain_allrules->setOpen( true );

	// default target ++++++++++++++++++++++++++++++++++++
	if ( curr_chain->hasDefaultTarget() ) {
		QString def_tg = curr_chain->defaultTarget();
		QString cmd = curr_chain->createIPTablesChainDefaultTarget();

		//		kdDebug() << "Setting up item: i_deftg" << endl;
		KMFChainLVItem * i_deftg = new KMFChainLVItem( i_chain_rules, i_chain_allrules, curr_chain );
		i_deftg->setPixmap( 0, icon_target );
		i_deftg->setText( 2, def_tg );
		kdDebug() << "Target: " << cmd << endl;
		if ( def_tg == "DROP" ) {
			i_deftg->setPixmap( 1, icon_drop );
		} else if ( def_tg == "ACCEPT" ) {
			i_deftg->setPixmap( 1, icon_accept );
		}

		//		kdDebug() << "Setting up item: i_deftg_rule" << endl;
		KMFChainLVItem * i_deftg_rule = new KMFChainLVItem( i_deftg, curr_chain );
		i_deftg_rule->setOpen( false );
		i_deftg_rule->setText( 0, i18n( "Cmd:" ) );
		i_deftg_rule->setPixmap( 1, icon_cmd );
		i_deftg_rule->setText( 2, cmd );
	}

	// open main item
	i_chain_rules->setOpen( true );
	//  kdDebug() << "Finished setting up IPChain item" << endl;
}

KMFRuleLVItem* KMFChainLVItem::getFirstRuleItem() {
	if ( i_chain_allrules != 0 )
		return dynamic_cast<KMFRuleLVItem *>( i_chain_allrules->firstChild() );
	else
		return 0;
}
KMFRuleLVItem* KMFChainLVItem::getRuleItemNumber( int num ) {
	kdDebug() << "Get Item for Rule: " << num << endl;
	if ( m_chain->chainRuleset().isEmpty() )
		return 0;

	if ( num > -1 ) {
		QListViewItem * top_item = i_chain_allrules->firstChild();
		QListViewItem* ret_item = 0;
		if ( top_item )
			ret_item = top_item;

		if ( top_item )
			for ( int i = 0; i < num; i++ ) {
				top_item = top_item->nextSibling();
				if ( top_item == 0 )
					return 0;
				ret_item = top_item;
				if ( ret_item )
					kdDebug() << "Sibling: " << ret_item->text( 0 ) << endl;
			}
		kdDebug() << "NEW CURRENT RULE NUMBER: " << ret_item->text( 0 ) << endl;
		if ( dynamic_cast<KMFRuleLVItem *>( ret_item ) )
			return dynamic_cast<KMFRuleLVItem *>( ret_item );
	}
	return 0;
}


void KMFChainLVItem::setRuleItemOpen( bool open ) {
	if ( i_chain_allrules != 0 )
		i_chain_allrules->setOpen( open );
}
void KMFChainLVItem::loadIcons() {
	kdDebug() << "void KMFChainLVItem::loadIcons()" << endl;
	KIconLoader *loader = KGlobal:: iconLoader();
	QString icon_name;

	icon_name = "firewall";
	icon_firewall = loader->loadIcon( icon_name, KIcon::User );

	icon_name = "filenew";
	icon_new = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "edit";
	icon_edit = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "del";
	icon_del = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "view_tree";
	icon_chain = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "nfs_unmount";
	icon_rule = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "reject";
	icon_reject = loader->loadIcon( icon_name, KIcon::User );

	icon_name = "target";
	icon_target = loader->loadIcon( icon_name, KIcon::User );

	icon_name = "stop";
	icon_drop = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "button_ok";
	icon_accept = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "filesaveas";
	icon_log = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "undo";
	icon_return = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "editclear";
	icon_cmd = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "filter";
	icon_filter = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "pipe";
	icon_queue = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "1rightarrow";
	icon_fwd = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "2rightarrow";
	icon_fwds = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "fill";
	icon_feed = loader->loadIcon( icon_name, KIcon::Small );
}






