/***************************************************************************
                       kmfruleeditortargetnat.cpp  -  description
                          -------------------
 begin                : Sun May 26 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : a9806056@unet.univie.ac.at
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmfruleeditortargetnat.h"

// QT includes
#include <qstring.h>
#include <qspinbox.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qmessagebox.h>

// KDE include
#include <kdebug.h>
#include <klocale.h>
#include <kapplication.h>
#include <kmessagebox.h>

// MY includes
#include "../core/iptrule.h"
#include "../core/kmferror.h"
#include "../core/kmferrorhandler.h"
#include "../core/kmfcheckinput.h"

KMFRuleEditorTargetNat::KMFRuleEditorTargetNat( QWidget *parent, const char *name, WFlags fl ) : KMyFirewallRuleEditorTargetNat( parent, name, fl ) {
	m_CheckInput = new KMFCheckInput();
	m_ErrorHandler = new KMFErrorHandler( "KMFRuleEditProtocol" );

}



KMFRuleEditorTargetNat::~KMFRuleEditorTargetNat() {}

void KMFRuleEditorTargetNat::loadRule( IPTRule *rule ) {
	kdDebug() << "KMFRuleEditorTargetNat::loadRule(IPTRule *rule)";
	curr_rule = rule;
	bool has_port = false;
	QPtrList<QPtrList<QString> > norm_options = curr_rule->ruleOptions();
	QPtrList<QString>* curr_opt = new QPtrList<QString>;
	for ( uint i = 0;i < norm_options.count();i++ ) {
		curr_opt = norm_options.at( i );
		int num = curr_opt->count();
		if ( num > 1 ) {
			QString opt_name = *curr_opt->at( 0 );
			//      kdDebug() << "Found Option: " << opt_name;
			if ( opt_name.contains( "tcp" ) || opt_name.contains( "udp" ) ) {
				has_port = true;
			}
		}
	}
	c_use_ports->setEnabled( has_port );


	QPtrList<QPtrList<QString> > options = curr_rule->ruleTargetOptions();
	for ( uint i = 0;i < options.count();i++ ) {
		curr_opt = options.at( i );
		int num = curr_opt->count();
		if ( num > 1 ) {
			QString opt_name = *curr_opt->at( 0 );
			//      kdDebug() << "Found Option: " << opt_name;
			if ( *curr_opt->at( 0 ) == "snat" && mbsnat == true ) {
				//        kdDebug() << "Paresd Ip Option: " << *curr_opt->at(1);
				QString str_ip = *curr_opt->at( 1 );
				if ( str_ip.contains( "-" ) ) {
					c_ip_range->setChecked( true );
					QString ip1 = str_ip.section( "-", 0, 0 );
					t_ip1 ->setText( ip1 );
					//          kdDebug() << "First IP arg: " << ip1;
					QString ip2 = str_ip.section( "-", 1, 1 );
					//          kdDebug() << "Second IP arg: " << ip2;
					t_ip2->setText( ip2 );
				} else {
					t_ip1->setText( str_ip );
					//          kdDebug() << "IP arg: " << str_ip;
				}
				if ( num > 2 ) {
					c_use_ports->setChecked( true );
					//          kdDebug() << "Paresd Port Option: " << *curr_opt->at(2);
					QString str_port = *curr_opt->at( 2 );
					if ( str_port.contains( "-" ) ) {
						c_use_port_range->setChecked( true );
						QString port1 = str_port.section( "-", 0, 0 );
						int int_port1 = port1.toInt();
						sb_port2 ->setValue( int_port1 );
						//            kdDebug() << "First Port arg: " << int_port1;

						QString port2 = str_port.section( "-", 1, 1 );
						int int_port2 = port2.toInt();
						sb_port2->setValue( int_port2 );
						//            kdDebug() << "Second Port arg: " << int_port2;
					} else {
						int int_port = str_port.toInt();
						sb_port1->setValue( int_port );
						//            kdDebug() << "Port arg: " << int_port;
					}
				}
			}
			if ( *curr_opt->at( 0 ) == "dnat" && mbsnat == false ) {
				//        kdDebug() << "Paresd Ip Option: " << *curr_opt->at(1);
				QString str_ip = *curr_opt->at( 1 );
				if ( str_ip.contains( "-" ) ) {
					c_ip_range->setChecked( true );
					QString ip1 = str_ip.section( "-", 0, 0 );
					t_ip1 ->setText( ip1 );
					//          kdDebug() << "First IP arg: " << ip1;
					QString ip2 = str_ip.section( "-", 1, 1 );
					//          kdDebug() << "Second IP arg: " << ip2;
					t_ip2->setText( ip2 );
				} else {
					t_ip1->setText( str_ip );
					//          kdDebug() << "IP arg: " << str_ip;
				}
				if ( num > 2 ) {
					c_use_ports->setChecked( true );
					//          kdDebug() << "Paresd Port Option: " << *curr_opt->at(2);
					QString str_port = *curr_opt->at( 2 );
					if ( str_port.contains( "-" ) ) {
						c_use_port_range->setChecked( true );
						QString port1 = str_port.section( "-", 0, 0 );
						int int_port1 = port1.toInt();
						sb_port2 ->setValue( int_port1 );
						//            kdDebug() << "First Port arg: " << int_port1;

						QString port2 = str_port.section( "-", 1, 1 );
						int int_port2 = port2.toInt();
						sb_port2->setValue( int_port2 );
						//            kdDebug() << "Second Port arg: " << int_port2;
					} else {
						int int_port = str_port.toInt();
						sb_port1->setValue( int_port );
						//            kdDebug() << "Port arg: " << int_port;
					}
				}
			}
		}
	}
}


void KMFRuleEditorTargetNat::accept() {
	kdDebug() << "KMFRuleEditorTargetNat::accept()";
	KMFError* err;
	bool ip_range = c_ip_range->isChecked();
	bool use_ports = c_use_ports->isChecked();
	bool use_port_range = c_use_port_range->isChecked();
	QString ip1, ip2, port1, port2, arg_ip, arg_port;

	if ( ip_range ) {
		ip1 = t_ip1->text();
		ip2 = t_ip2->text();
		// Sanity checks +++++++++++++++++
		err = m_CheckInput->checkInput( ip1, "IP" );
		if ( !m_ErrorHandler->showError( err ) ) {
			return ;
		}
		err = m_CheckInput->checkInput( ip2, "IP" );
		if ( !m_ErrorHandler->showError( err ) ) {
			return ;
		}
		// ++++++++++++++++++++++++++++++++
		arg_ip = ip1 + "-" + ip2;
		kdDebug() << "IP Argument: " << arg_ip;
	} else {
		ip1 = t_ip1->text();
		// Sanity checks +++++++++++++++++
		err = m_CheckInput->checkInput( ip1, "IP" );
		if ( !m_ErrorHandler->showError( err ) ) {
			return ;
		}
		// ++++++++++++++++++++++++++++++++
		arg_ip = ip1;
		kdDebug() << "IP Argument: " << arg_ip;
	}

	if ( use_ports ) {
		if ( use_port_range ) {
			port1 = sb_port1->text();
			port2 = sb_port2->text();
			// Sanity checks +++++++++++++++++
			err = m_CheckInput->checkInput( port1, "PORT" );
			if ( !m_ErrorHandler->showError( err ) ) {
				return ;
			}
			err = m_CheckInput->checkInput( port2, "PORT" );
			if ( !m_ErrorHandler->showError( err ) ) {
				return ;
			}
			// ++++++++++++++++++++++++++++++++
			arg_port = port1 + "-" + port2;
			kdDebug() << "Port Argument: " << arg_port;
		} else {
			port1 = sb_port1->text();
			// Sanity checks +++++++++++++++++
			err = m_CheckInput->checkInput( port1, "PORT" );
			if ( !m_ErrorHandler->showError( err ) ) {
				return ;
			}
			// ++++++++++++++++++++++++++++++++

			arg_port = port1;
			kdDebug() << "Port Argument: " << arg_port;
		}
	}

	if ( mbsnat ) {
		QPtrList<QString>* options = new QPtrList<QString>;
		QString* name = new QString( "snat" );
		emit sigDelTargetOpt( name );
		QString val = arg_ip;
		if ( !val.isEmpty() ) {
			QString * opt = new QString( "" );
			opt->append( val );
			options->append( opt );
		} else {
			KMessageBox::error( this, i18n( "Unable to work without values.\n"
			                             "Please specify at least an IP address."
			                           ), i18n( "Nat Options" ) );
			return ;
		}

		QString val2 = arg_port;
		if ( !val2.isEmpty() ) {
			QString * opt = new QString( "" );
			opt->append( val2 );
			options->append( opt );
		}
		emit sigAddTargetOpt( name, options );

	} else {
		QPtrList<QString>* options = new QPtrList<QString>;
		QString* name = new QString( "dnat" );
		emit sigDelTargetOpt( name );
		QString val = arg_ip;
		if ( !val.isEmpty() ) {
			QString * opt = new QString( "" );
			opt->append( val );
			options->append( opt );
		} else {
			KMessageBox::error( this,  i18n( "Unable to work without values. Please specify at least an IP address." ),
												 i18n( "Nat Options" ) );
			return ;
		}
		QString val2 = arg_port;
		if ( !val2.isEmpty() ) {
			QString * opt = new QString( "" );
			opt->append( val2 );
			options->append( opt );
		}
		emit sigAddTargetOpt( name, options );
	}


	emit sigDocumentChanged();
	//	QDialog::accept();
}
void KMFRuleEditorTargetNat::slotHelp() {
	kdDebug() << "void KMFRuleEditorTargetNat::slotHelp()" << endl;
	kapp->invokeHelp( "targets" );
}
void KMFRuleEditorTargetNat::reject() {
	kdDebug() << "void KMFRuleEditorTargetNat::reject()" << endl;
	emit sigHideMe();
}

#include "kmfruleeditortargetnat.moc"
