/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//my includes
#include "kmfruleeditip.h"
#include "../core/iptrule.h"
#include "../core/kmferrorhandler.h"
#include "../core/kmfcheckinput.h"
#include "../core/kmferror.h" 
// qt includes
#include <qcheckbox.h>
#include <qframe.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h> 
// KDE includes
#include <kdebug.h>
#include <kapplication.h>

// std includes
#include <iostream> 
/*
 *  Constructs a KMFRuleEditIP which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
KMFRuleEditIP::KMFRuleEditIP( QWidget* parent, const char* name, WFlags fl )
		: KMyFirewallRuleEditorIP ( parent, name, fl ) {
	m_CheckInput = new KMFCheckInput();
	m_ErrorHandler = new KMFErrorHandler( "KMFRuleEditIP" );
}

/*
 *  Destroys the object and frees any allocated resources
 */
KMFRuleEditIP::~KMFRuleEditIP() {
	// no need to delete child widgets, Qt does it all for us
}

/*
 *  Main event handler. Reimplemented to handle application
 *  font changes
 */
bool KMFRuleEditIP::event( QEvent* ev ) {
	bool ret = QWidget::event( ev );
	if ( ev->type() == QEvent::ApplicationFontChange ) {}
	return ret;
}

void KMFRuleEditIP::loadRule( IPTRule * rule ) {
	kdDebug() << "void KMFRuleEditIP::loadRule( IPTRule * rule )" << endl;
	c_src_ip->setChecked( false );
	c_dest_ip->setChecked( false );
	c_inv_src_ip->setChecked( false );
	c_inv_dest_ip->setChecked( false );
	t_src_ip->setText( "" );
	t_dest_ip->clear();
	curr_rule = rule;
	QPtrList<QPtrList<QString> > opt_list = curr_rule->ruleOptions();
	for ( uint j = 0;j < opt_list.count();j++ ) {
		options = new QPtrList<QString>;
		options = opt_list.at( j );
		if ( options->count() > 1 ) {
			QString * opt = options->at( 0 );
			QString* cmd = options->at( 1 );
			if ( *opt == "src_ip" ) {
				c_src_ip->setChecked( true );
				if ( cmd->startsWith( "! " ) ) {
					c_inv_src_ip->setChecked( true );
					t_src_ip->setText( cmd->right( cmd->length() - 2 ) );
				} else {
					t_src_ip->setText( *cmd );
				}
			} else if ( *opt == "dest_ip" ) {
				c_dest_ip->setChecked( true );
				if ( cmd->startsWith( "! " ) ) {
					c_inv_dest_ip->setChecked( true );
					t_dest_ip->setText( cmd->right( cmd->length() - 2 ) );
				} else {
					t_dest_ip->setText( *cmd );
				}
			}
		}
	}
	return ;
}


void KMFRuleEditIP::accept() {
	kdDebug() << "KMFRuleEditIP::slotOk()" << endl;
	QString* src_ip = new QString( t_src_ip->text() );
	QString* dest_ip = new QString( t_dest_ip->text() );

	bool en_c_src_ip = c_src_ip->isChecked();
	bool en_c_dest_ip = c_dest_ip->isChecked();
	bool is_inv_src_ip = c_inv_src_ip->isChecked();
	bool is_inv_dest_ip = c_inv_dest_ip->isChecked();
	if ( !en_c_src_ip ) {
		QString * del = new QString( "src_ip" );
		//     curr_rule->delRuleOption(*del);
		emit sigDelRuleOpt( del );
	}
	if ( !en_c_dest_ip ) {
		QString * del = new QString( "dest_ip" );
		//     curr_rule->delRuleOption(*del);
		emit sigDelRuleOpt( del );
	}
	if ( en_c_src_ip && !src_ip->isEmpty() ) {
		kdDebug() << "Add new src_ip option" << endl;
		QString* op = new QString( "src_ip" );
		QString cmd = *src_ip;

		// Sanity checks +++++++++++++++++
		KMFError* err = m_CheckInput->checkInput( cmd, "IP/NETWORK/FQHN" );
		if ( !m_ErrorHandler->showError( err ) ) {
			return ;
		}
		// ++++++++++++++++++++++++++++++++

		if ( is_inv_src_ip ) {
			src_ip->prepend( "! " );
		}
		QPtrList<QString>* values = new QPtrList<QString>;
		values->append( src_ip );
		emit sigAddRuleOpt( op, values );
	}
	if ( en_c_dest_ip && !dest_ip->isEmpty() ) {
		kdDebug() << "Add new dest_ip option" << endl;
		QString cmd = *dest_ip;

		// Sanity checks +++++++++++++++++
		KMFError* err = m_CheckInput->checkInput( cmd, "IP/NETWORK/FQHN" );
		if ( !m_ErrorHandler->showError( err ) ) {
			return ;
		}
		// ++++++++++++++++++++++++++++++++

		QString* op = new QString( "dest_ip" );
		if ( is_inv_dest_ip ) {
			dest_ip->prepend( "! " );
		}
		QPtrList<QString>* values = new QPtrList<QString>;
		values->append( dest_ip );
		emit sigAddRuleOpt( op, values );
	}
	emit sigDocumentChanged();
	// QDialog::accept();
}

void KMFRuleEditIP::reject() {
	kdDebug() << "void KMFRuleEditIP::reject()" << endl;
	emit sigHideMe();
}

void KMFRuleEditIP::slotHelp() {
	kdDebug() << "void KMFRuleEditIP::slotHelp()" << endl;
	kapp->invokeHelp( "src_dest_ip" );
}

#include "kmfruleeditip.moc"
