/***************************************************************************
                       kmfoutputviewer.h  -  description
                          -------------------
 begin                : Mon Jan 28 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : a9806056@unet.univie.ac.at
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KMFOUTPUTVIEWER_H
#define KMFOUTPUTVIEWER_H
#include <qwidget.h>
#include <qpixmap.h>
#include "../kmyfirewall.h"

class QString;
class QLabel;
class QPushButton;
class QGridLayout;
class KMFProcOut;
class KMFError;
class KMFErrorHandler;
class KTempFile;

class KMFOutputViewer : public QWidget {
	Q_OBJECT

public:
	KMFOutputViewer( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
	~KMFOutputViewer();
	void loadApp( KMyFirewall *app );

public slots:
	void slotRunFW();
	void slotStopFW();
	void slotShowAll();
	void slotShowFilter();
	void slotShowNat();
	void slotShowMangle();
	void slotShowScript();
	void slotInstallFW();
	void slotUninstallFW();
	void slotCloseWindow();
protected slots:
	void slotJobFinished( bool, const QString& );

private:    // functions
	void initGUI();
	void loadIcons();

private:    // data
	QString str_ipt;
	bool fw_is_running;
	QLabel *m_lrun;
	QLabel *m_lshow;
	QLabel *m_lconf;
	QLabel *m_linstall;
	QPushButton *m_brun_fw;
	QPushButton *m_bstop_fw;
	QPushButton *m_bshow_sript;
	QPushButton *m_bshow_all;
	QPushButton *m_bshow_filter;
	QPushButton *m_bshow_nat;
	QPushButton *m_bshow_mangle;
	QPushButton *m_binstall;
	QPushButton *m_buninstall;
	QPushButton *m_bclose;
	QGridLayout *m_layout;
	KMFProcOut *m_proc_out;
	QPixmap icon_run, icon_stop, icon_show;
	KMyFirewall *m_app;
	KMFError *m_err;
	KMFErrorHandler *m_err_handler;
	KTempFile *temp_file, *temp_file2;
signals:
	void sigStatusChanged();
	void sigHideMe();
	void sigShowMe();
};

#endif // KMFOUTPUTVIEWER_H
