/***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/ 
/*
	This class is taken from the tutorial " How to implement User defined settings"
	on the www.kdevelop.org website written by Andreas Nicolai.
*/

#ifndef KMFCONFIGURATION_H
#define KMFCONFIGURATION_H

#include <qstring.h>
#include <qfont.h>
#include <qcolor.h>
#include <qstringlist.h>

/// This is the one and only configuration object.
/// The member functions read() and write() can be used to load and save
/// the properties to the application configuration file.
class KMFConfiguration {
public:
	/// Reads the configuration data from the application config file.
	/// If a property does not already exist in the config file it will be
	/// set to a default value.
	void read();
	/// Writes the configuration data to the application config file.
	void write() const;

	/*    QString m_text;                      ///< The text to be printed in the main widget.
	    QFont   m_font;                      ///< The font to be used for the text.
	    QColor  m_textColor;                 ///< The text colour used in the main widget.*/
	int m_maxUndo;
	bool m_firstRun;
	bool m_showSplash;
	bool m_gentooMode;
	bool m_showDocumentation;
	bool m_showCommandLine;
	QString m_currentConfiguration;
	QString m_initPath;
	QString m_iptPath ;
	QString m_modprobePath;
	QString m_rcDefaultPath;
	QStringList m_interfaces;

	// not stored attributes
	bool m_upAndRunning;
	bool m_hasOpenDoc;

/*	static const QString m_defaultText;       ///< The default text to be printed.
	static const QFont m_defaultFont;       ///< The default font for the text.
	static const QColor m_defaultTextColor;  ///< The default text color.*/
	static const int m_defaultMaxUndo;
	static const bool m_defaultShowSplash;
	static const bool m_defaultGentooMode;
	static const bool m_defaultShowDocumentation;
	static const bool m_defaultShowCommandLine;
	static const QString m_defaultInitPath;
	static const QString m_defaultIptPath ;
	static const QString m_defaultModprobePath;
	static const QString m_defaultRcDefaultPath;
	static const QStringList m_defaultInterfaces;

private:
	KMFConfiguration();
	KMFConfiguration( const KMFConfiguration& );

	friend KMFConfiguration& Config();
};

/// Returns a reference to the application configuration object.
KMFConfiguration& Config();

#endif  // KMFCONFIGURATION_H
