#include "../kpplugin.h"
#include "../kputil.h"
#include "../kipina-i18n.h"
#include "../kptraininglog.h"
#include "../gui/kpmainwindow.h"

GtkWidget * item = NULL;

static gboolean
plugin_load(KPPlugin *plugin)
{
  KPTrainingLog * log;
  
  kp_debug("simple plugin loaded.\n");

  /* Already loaded. */
  if (item)
    return TRUE;
  
  item = gtk_menu_item_new_with_label ("This is just a test plugin");
  kp_main_window_add_to_import_menu (GTK_MENU_ITEM (item));

  log = kp_main_window_get_log ();

  if (KP_IS_TRAINING_LOG (log))
    g_print ("Log has %d entries.\n", kp_training_log_get_size (log));

  return TRUE;
}

static gboolean
plugin_unload(KPPlugin *plugin)
{
  kp_debug("simple plugin unloaded.\n");
  
  return TRUE;
}

static KPPluginInfo info =
{
  1,                                                /**< api_version    */
  "simple",                                         /**< id             */
  N_("Simple Plugin"),                              /**< name           */
  VERSION,                                          /**< version        */
  N_("Tests to see that most things are working."),
  N_("Tests to see that most things are working."),
  "Ville Kangas <ville@mirjami.net>",               /**< author         */
  "http://mirjami.net/~ville/kipina",               /**< homepage       */
  plugin_load,                                      /**< load           */
  plugin_unload,                                    /**< unload         */
  NULL,                                             /**< destroy        */
};

static void
init_plugin(KPPlugin *plugin)
{
}

KP_PLUGIN_INIT("simple", init_plugin, info)
