/***************************************************************************
                          kfocuslogentry.h  -  description
                             -------------------
    begin                : Fri Aug 17 2001
    copyright            : (C) 2001 by Jeffrey Yu
    email                : wehjin@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KFOCUSLOGENTRY_H
#define KFOCUSLOGENTRY_H

#include <qobject.h>
#include <qdatetime.h>
#include <qstring.h>
#include <qdom.h>

/**Model class for entries in a logbook
  *@author Jeffrey Yu
  */

class KFMLog : public QObject  {
	Q_OBJECT
public:
	KFMLog();
	KFMLog(const KFMLog* entry);
	~KFMLog();

	/** Form a DOM element from the entry */
	QDomElement domElement(QDomDocument* dDoc);	
  /** Setup the entry according to the DOM element */
  void domElement(QDomElement dElement);

  /** Date for the entry */
  QDate date() const;
  /** Set the date */
  void date(QDate date);

  /** Date in string form */
  QString dateString() const;

  /** Get the body of the entry */
  QString body() const;
  /** Set the body of the entry */
  void body(QString body);

  /** Compare against another entry */
  bool operator<(const KFMLog & other) const;
  /** Compare against another entry */
  bool operator==(const KFMLog & other) const;

  /** Get the log's position in the logbook */
  int position() const { return position_; };
  /** Set the log's position in the logbook.  This attribute is normally
  		set by the logbook. */
  void position(const int position) { position_ = position; };

signals: // Signals
  /** Signal for when the contents change in the entry */
  void contentsChanged();
  /** Signal for when an entry is deleted */
  void deleted();
  /** Signal sent when the date changes in the entry */
  void dateChanged(KFMLog* log);
private: // Private attributes
  /** Date of the entry */
  QDate date_;
  /** Body of the entry */
  QString body_;
  /** Position of the log in a logbook */
  int position_;
};

#endif
