/*
 *  Copyright (C) 1999-2002 Bernd Gehrmann
 *                          bernd@mail.berlios.de
 *  Copyright (c) 2004 Christian Loose <christian.loose@hamburg.de>
 *
 * This program may be distributed under the terms of the Q Public
 * License as defined by Trolltech AS of Norway and appearing in the
 * file LICENSE.QPL included in the packaging of this file.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */


#ifndef LOGTREE_H
#define LOGTREE_H


#include <qptrlist.h>

#include <qtable.h>


class LogTreeItem;
class LogTreeConnection;

namespace Cervisia
{
struct LogInfo;
}


typedef QPtrList<LogTreeItem> LogTreeItemList;
typedef QPtrList<LogTreeConnection> LogTreeConnectionList;


class LogTreeView : public QTable
{
    Q_OBJECT

public:
    explicit LogTreeView( QWidget *parent=0, const char *name=0 );

    void addRevision(const Cervisia::LogInfo& logInfo);
    void setSelectedPair(QString selectionA, QString selectionB);
    void collectConnections();
    void recomputeCellSizes();
    virtual void paintCell(QPainter *p, int row, int col, const QRect& cr,
                           bool selected, const QColorGroup& cg);

    virtual QSize sizeHint() const;
    
    virtual QString text(int row, int col) const;

signals:
    void revisionClicked(QString rev, bool rmb);

protected:
    virtual void contentsMousePressEvent(QMouseEvent *e);

private slots:

    void slotQueryToolTip(const QPoint&, QRect&, QString&);

private:
    QSize computeSize(const Cervisia::LogInfo&, int* = 0, int* = 0) const;
    void paintRevisionCell(QPainter *p, int row, int col, const Cervisia::LogInfo& logInfo,
                           bool followed, bool branched, bool selected);
    void paintConnector(QPainter *p, int row, int col, bool followed, bool branched);

    LogTreeItemList items;
    LogTreeConnectionList connections;
    int currentRow, currentCol;

    static const int BORDER;
    static const int INSPACE;
};

#endif


// Local Variables:
// c-basic-offset: 4
// End:
