/***************************************************************************
                          transferqueue.h  -  description
                             -------------------
    begin                : lr feb 9 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TRANSFERQUEUE_H
#define TRANSFERQUEUE_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qptrqueue.h>
#include <qobject.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "base/transfer.h"
	
	/**
	* This is a queue to the outside but internally it's not really a queue
	* just an ordinary list template.
	*@author Bjrn Sahlstrm
	*/

class TransferQueue : public QObject, public QPtrQueue<Transfer> {
	Q_OBJECT
public:
	/** */
	TransferQueue(QObject* parent=0L, const char* name=0L );
	/** */
	virtual ~TransferQueue();
	/** Adds a @ref Transfer to the queue
	* Will emit the signal @ref #transferAdded()
	* @param transfer is a reference to the @ref Transfer to add
	*/
	void enqueue( Transfer* transfer );
	/** Removes a @ref Transfer from the queue
	* Will emit the signal @ref #transferRemoved()
	* @returns the transfer  removed
	*/
	Transfer* dequeue();
	/** */
	void remove( Transfer* transfer );
signals:
	/** Emitted whenever a @ref Transfer is added to the queue*/
	void transferAdded();
	/** Emitted whenever a @ref Transfer is removed from the queue*/
	void transferRemoved( Transfer* );
};

#endif
