/***************************************************************************
 *   Copyright (C) 2003 by Hans Karlsson                                   *
 *   karlsson.h@home.se                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "imagelabel.h"

ImageLabel::ImageLabel(int ix,int iy,int iw,int ih)
 : Meter(ix,iy,iw,ih)
 {

}

ImageLabel::ImageLabel() : Meter(){


}
ImageLabel::~ImageLabel(){


}

void ImageLabel::setValue(int v){
 setValue( QString::number( v ) );
}

void ImageLabel::setValue(QString fn)
{

  // use the first line
  QStringList sList = QStringList::split( "\n", fn );
  QString fileName = *sList.begin();
  QFileInfo fileInfo( fileName );
  QString path;

  QRegExp rx("^http://",false);
  bool fileOnNet = (rx.search(fileName)!=-1)?true:false;


  if( fileInfo.isRelative() && !fileOnNet )
  {
     path = themePath + "/" + fileName;
  }
  else
  {
     path = fileName;
  }

  if ( fileOnNet )
  {
      QString tmpFile;
      if(KIO::NetAccess::download(KURL(path), tmpFile))
      {
          pixmap = QPixmap(tmpFile);
          KIO::NetAccess::removeTempFile(tmpFile);
           qDebug( "Downloaded: " + path + " to " + tmpFile );
      }
      else
      {
          qDebug( "Error Downloading: " + path );
      }
  }
  else
  {
    pixmap = QPixmap( path );
  }

  pixmapWidth = pixmap.width();
  pixmapHeight = pixmap.height();
}

void ImageLabel::mUpdate(QPainter* p)
{
     p->drawPixmap(x,y,pixmap);
}


