# $Id: Hinsi.pm,v 1.3 2002/07/13 10:52:33 tsuchiya Exp $
package Juman::Hinsi;
require 5.000;
use Exporter;
use Carp;
use strict;
use vars qw/ @ISA @EXPORT_OK /;
@ISA = qw/ Exporter /;
@EXPORT_OK = qw/ get_hinsi get_hinsi_id get_bunrui get_bunrui_id /;

=head1 NAME

Juman::Hinsi - Juman ʻηϤ򰷤饤֥

=head1 SYNOPSIS

 use Juman::Hinsi qw/ get_hinsi_id /;
 $id = get_hinsi_id( '̾' );

=head1 DESCRIPTION

Juman ʻηϤ򰷤Υ饤֥Ǥ롥

=head1 SUB-ROUTINES

=over 4

=item get_hinsi( ID )

ʻIDʻʸ

=item get_hinsi_id( STR )

ʻʸ󤫤ʻID

=item get_bunrui( HINSI, ID )

ʬIDʬʸ

=item get_bunrui_id( HINSI, STR )

ʬʸ󤫤ʬID

=back

=head1 NOTES

C<Juman> ֥ȤΥ᥽åɤȤѤ뤳ȤǤ롥

Example:

 use Juman;
 $juman = new Juman();
 $id = $juman->get_hinsi_id( '̾' );

=head1 SEE ALSO

L<Juman>.

=head1 AUTHOR

=over 4

=item
ڲ ̭ <tsuchiya@pine.kuee.kyoto-u.ac.jp>

=back

=cut


sub new {
    my( $class ) = @_;
    my $this = {};
    bless $this, $class;
}


my %TAIKEI =
    ( 'root'    => [ 'ü', 'ư', 'ƻ', 'Ƚ', 'ư',
		     '̾', 'ؼ', '', '', '³',
		     'Ϣλ', 'ư', 'Ƭ', '', '̤' ],
      'ü'	=> [ '', '', '̻', '̽', '', '' ],
      'ư'	=> [],
      'ƻ'	=> [],
      'Ƚ'	=> [],
      'ư'	=> [],
      '̾'	=> [ '̾', '̾', 'ͭ̾', '̾', '̾',
		     'ȿ̾', '', '̾', 'Ū̾', '̾' ],
      'ؼ'	=> [ 'ֻ̾ؼ', 'Ϣλֻؼ', 'ֻؼ' ],
      ''	=> [ '', '', '', '', '',
		     'Ľ', 'ɾ', 'ȯ' ],
      ''	=> [ 'ʽ', '', '³', '' ],
      '³'	=> [],
      'Ϣλ'	=> [],
      'ư'	=> [],
      'Ƭ'	=> [ '̾Ƭ', 'ưƬ', 'ƻƬ', 'ʷƻƬ' ],
      ''	=> [ '̾Ҹ', '̾̾', '̾̾',
		     '̾ü', 'ƻҸ', 'ƻ̾',
		     'ư' ],
      '̤' => [ '¾', '', 'ե٥å' ],
    );

my %HINSI;
my %BUNRUI;
{
    my $hinsi_id = 1;
    my $hinsi;
    for $hinsi ( @{$TAIKEI{root}} ){
	$HINSI{$hinsi} = $hinsi_id;
	my $bunrui_id = 1;
	my $bunrui;
	for $bunrui ( @{$TAIKEI{$hinsi}} ){
	    $BUNRUI{$hinsi}{$bunrui}    = $bunrui_id;
	    $BUNRUI{$hinsi_id}{$bunrui} = $bunrui_id++;
	}
	$hinsi_id++;
    }
}

# ʻIDʻʸ᥽å
sub get_hinsi {
    if( @_ == 2 ){
	shift;
    } elsif( @_ != 1 ){
        local $" = ', ';
        croak "get_hinsi(@_): requires an argument.";
    }
    my( $hinsi_id ) = @_;
    $hinsi_id += ( $[ - 1 );
    ( defined $TAIKEI{root}[$hinsi_id] )? $TAIKEI{root}[$hinsi_id] : undef;
}
   
# ʻʸ󤫤ʻID᥽å
sub get_hinsi_id {
    if( @_ == 2 ){
	shift;
    } elsif( @_ != 1 ){
        local $" = ', ';
        croak "get_hinsi_id(@_): requires an argument.";
    }
    my( $hinsi ) = @_;
    ( defined $HINSI{$hinsi} )? $HINSI{$hinsi} : undef;
}

# ʬIDʬʸ᥽å
sub get_bunrui {
    if( @_ == 3 ){
	shift;
    } elsif( @_ != 2 ){
        local $" = ', ';
        croak "get_bunrui(@_): requires 2 arguments.";
    }
    my( $hinsi, $bunrui_id ) = @_;
    $hinsi !~ /\D/ and $hinsi = &get_hinsi( $hinsi );
    $bunrui_id += ( $[ - 1 );
    ( defined $TAIKEI{$hinsi}[$bunrui_id] )? $TAIKEI{$hinsi}[$bunrui_id] : undef;
}

# ʬʸ󤫤ʬID᥽å
sub get_bunrui_id {
    if( @_ == 3 ){
	shift;
    } elsif( @_ != 2 ){
        local $" = ', ';
        croak "get_bunrui_id(@_): requires 2 arguments.";
    }
    my( $hinsi, $bunrui ) = @_;
    ( defined $BUNRUI{$hinsi}{$bunrui} )? $BUNRUI{$hinsi}{$bunrui} : undef;
}

1;
__END__
# Local Variables:
# mode: perl
# coding: euc-japan
# use-kuten-for-period: nil
# use-touten-for-comma: nil
# End:
