
/*
 * queue.h -- written for Juice
 *  Copyright (C) 1999, 2000, 2001 Abraham vd Merwe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef QUEUE_H
#define QUEUE_H

#include "typedefs.h"							 /* bool */

/* Queue structure */
typedef struct queuerec
{
   char track[256];
   struct queuerec *next;
} queue_t;

/*
 * Initialize queue.
 */
void queue_init (queue_t **queue);

/*
 * Add token to queue. Returns TRUE if successful, FALSE otherwise.
 */
bool queue_add (queue_t **queue,const char *track);

/*
 * Remove first token from queue. Please make sure that track can handle
 * strings up to 256 characters.
 */
void queue_remove (queue_t **queue,char *track);

/*
 * Check if queue is empty. Returns TRUE if empty, FALSE if otherwise.
 */
bool queue_empty (queue_t *queue);

/*
 * Destroy queue. NOTE: queue need not be initialized again.
 */
void queue_destroy (queue_t **queue);

#endif
