/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 */

#include <jni.h>
#include <sys/types.h>
#include <libgtkhtml/gtkhtml.h>

#ifndef _Included_org_gnu_gtkhtml_dom_DomNode
#define _Included_org_gnu_gtkhtml_dom_DomNode
#ifdef __cplusplus
extern "C" {
#endif
/*
 * Class:     org_gnu_gtkhtml_dom_DomNode
 * Method:    dom_node_get_type
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtkhtml_dom_DomNode_dom_1node_1get_1type
  (JNIEnv *env, jclass cls)
{
  return (jint)dom_node_get_type();
}

/*
 * Class:     org_gnu_gtkhtml_dom_DomNode
 * Method:    dom_Node_mkref
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtkhtml_dom_DomNode_dom_1Node_1mkref
  (JNIEnv *env, jclass cls, jint node)
{
  return (jint)dom_Node_mkref((xmlNode*)node);
}

/*
 * Class:     org_gnu_gtkhtml_dom_DomNode
 * Method:    dom_Node_get_childNodes
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtkhtml_dom_DomNode_dom_1Node_1get_1childNodes
  (JNIEnv *env, jclass cls, jint node)
{
  return (jboolean)dom_Node__get_childNodes((DomNode*)node);
}

/*
 * Class:     org_gnu_gtkhtml_dom_DomNode
 * Method:    dom_Node_removeChild
 * Signature: (II[I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtkhtml_dom_DomNode_dom_1Node_1removeChild
  (JNIEnv *env, jclass cls, jint node, jint oldChild, jintArray exception)
{
  DomException *excp = (DomException*)(*env)->GetIntArrayElements(env, exception, NULL);
  jint ret = (jint)dom_Node_removeChild((DomNode*)node, (DomNode*)oldChild, excp);
  (*env)->ReleaseIntArrayElements(env, exception, (jint*)excp, 0);
  return ret;
}

/*
 * Class:     org_gnu_gtkhtml_dom_DomNode
 * Method:    dom_Node_get_nodeValue
 * Signature: (I[I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gtkhtml_dom_DomNode_dom_1Node_1get_1nodeValue
  (JNIEnv * env, jclass cls, jint node, jintArray exception)
{
  DomException *excp = (DomException*)(*env)->GetIntArrayElements(env, exception, NULL);
  DomString *str = dom_Node__get_nodeValue((DomNode*)node, excp);
  (*env)->ReleaseIntArrayElements(env, exception, (jint*)excp, 0);
  return (*env)->NewStringUTF(env, (char*)str);
}

/*
 * Class:     org_gnu_gtkhtml_dom_DomNode
 * Method:    dom_Node_get_firstChild
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtkhtml_dom_DomNode_dom_1Node_1get_1firstChild
  (JNIEnv *env, jclass cls, jint node)
{
  return (jint)dom_Node__get_firstChild((DomNode*)node);;
}

/*
 * Class:     org_gnu_gtkhtml_dom_DomNode
 * Method:    dom_Node_get_nodeName
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gtkhtml_dom_DomNode_dom_1Node_1get_1nodeName
  (JNIEnv *env, jclass cls, jint node)
{
  DomString* str = dom_Node__get_nodeName((DomNode*)node);;
  return (*env)->NewStringUTF(env, (char*)str);
}

/*
 * Class:     org_gnu_gtkhtml_dom_DomNode
 * Method:    dom_Node_get_attributes
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtkhtml_dom_DomNode_dom_1Node_1get_1attributes
  (JNIEnv *env, jclass cls, jint node)
{
  return (jint)dom_Node__get_attributes((DomNode*)node);;
}

/*
 * Class:     org_gnu_gtkhtml_dom_DomNode
 * Method:    dom_Node_hasChildNodes
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtkhtml_dom_DomNode_dom_1Node_1hasChildNodes
  (JNIEnv *env, jclass cls, jint node)
{
  return (jint)dom_Node_hasChildNodes((DomNode*)node);;
}

/*
 * Class:     org_gnu_gtkhtml_dom_DomNode
 * Method:    dom_Node_get_parentNode
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtkhtml_dom_DomNode_dom_1Node_1get_1parentNode
  (JNIEnv *env, jclass cls, jint node)
{
  return (jint)dom_Node__get_parentNode((DomNode*)node);;
}

/*
 * Class:     org_gnu_gtkhtml_dom_DomNode
 * Method:    dom_Node_get_nextSibling
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtkhtml_dom_DomNode_dom_1Node_1get_1nextSibling
  (JNIEnv *env, jclass cls, jint node)
{
  return (jint)dom_Node__get_nextSibling((DomNode*)node);;
}

/*
 * Class:     org_gnu_gtkhtml_dom_DomNode
 * Method:    dom_Node_get_nodeType
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtkhtml_dom_DomNode_dom_1Node_1get_1nodeType
  (JNIEnv *env, jclass cls, jint node)
{
  return (jint)dom_Node__get_nodeType((DomNode*)node);;
}

/*
 * Class:     org_gnu_gtkhtml_dom_DomNode
 * Method:    dom_Node_cloneNode
 * Signature: (IZ)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtkhtml_dom_DomNode_dom_1Node_1cloneNode
  (JNIEnv *env, jclass cls, jint node, jboolean deep)
{
  return (jint)dom_Node_cloneNode((DomNode*)node, (DomBoolean)deep);
}

/*
 * Class:     org_gnu_gtkhtml_dom_DomNode
 * Method:    dom_Node_appendChild
 * Signature: (II[I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtkhtml_dom_DomNode_dom_1Node_1appendChild
  (JNIEnv *env, jclass cls, jint node, jint newChild, jintArray exception)
{
  DomException *excp = (DomException*)(*env)->GetIntArrayElements(env, exception, NULL);
  jint ret = (jint)dom_Node_appendChild((DomNode*)node, (DomNode*)newChild, excp);
  (*env)->ReleaseIntArrayElements(env, exception, (jint*)excp, 0);
  return ret;
}

/*
 * Class:     org_gnu_gtkhtml_dom_DomNode
 * Method:    dom_Node_get_localName
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gtkhtml_dom_DomNode_dom_1Node_1get_1localName
  (JNIEnv * env, jclass cls, jint node)
{
  DomString *str = dom_Node__get_localName((DomNode*)node);
  return (*env)->NewStringUTF(env, (char*)str);
}

/*
 * Class:     org_gnu_gtkhtml_dom_DomNode
 * Method:    dom_Node_get_namespaceURI
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gtkhtml_dom_DomNode_dom_1Node_1get_1namespaceURI
  (JNIEnv *env, jclass cls, jint node)
{
  DomString* str = dom_Node__get_namespaceURI((DomNode*)node);
  return (*env)->NewStringUTF(env, (char*)str);
}

/*
 * Class:     org_gnu_gtkhtml_dom_DomNode
 * Method:    dom_Node_get_previoussibling
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtkhtml_dom_DomNode_dom_1Node_1get_1previoussibling
  (JNIEnv *env, jclass cls, jint node)
{
  return (jint)dom_Node__get_previousSibling((DomNode*)node);
}

/*
 * Class:     org_gnu_gtkhtml_dom_DomNode
 * Method:    dom_Node_get_lastChild
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtkhtml_dom_DomNode_dom_1Node_1get_1lastChild
  (JNIEnv *env, jclass cls, jint node)
{
  return (jint)dom_Node__get_lastChild((DomNode*)node);
}

/*
 * Class:     org_gnu_gtkhtml_dom_DomNode
 * Method:    dom_Node_set_nodeValue
 * Signature: (ILjava/lang/String;[I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtkhtml_dom_DomNode_dom_1Node_1set_1nodeValue
  (JNIEnv *env, jclass cls, jint node, jstring value, jintArray exception)
{
  DomException *excp = (DomException*)(*env)->GetIntArrayElements(env, exception, NULL);
  DomString* str = (DomString*)(*env)->GetStringUTFChars(env, value, 0);
  dom_Node__set_nodeValue((DomNode*)node, str, excp);
  (*env)->ReleaseIntArrayElements(env, exception, (jint*)excp, 0);
  (*env)->ReleaseStringUTFChars(env, value, str);
}

/*
 * Class:     org_gnu_gtkhtml_dom_DomNode
 * Method:    dom_Node_get_ownerDocument
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtkhtml_dom_DomNode_dom_1Node_1get_1ownerDocument
  (JNIEnv *env, jclass cls, jint node)
{
  return (jint)dom_Node__get_ownerDocument((DomNode*)node);
}

/*
 * Class:     org_gnu_gtkhtml_dom_DomNode
 * Method:    dom_Node_hasAttributes
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtkhtml_dom_DomNode_dom_1Node_1hasAttributes
  (JNIEnv *env, jclass cls, jint node)
{
  return (jboolean)dom_Node_hasAttributes((DomNode*)node);
}

/*
 * Class:     org_gnu_gtkhtml_dom_DomNode
 * Method:    dom_Node_get_doctype
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtkhtml_dom_DomNode_dom_1Node_1get_1doctype
  (JNIEnv *env, jclass cls, jint doc)
{
  return (jint) dom_Document__get_doctype((DomDocument *) doc);
}

#ifdef __cplusplus
}
#endif
#endif
