/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.pango;
import org.gnu.glib.Enum;

/**
 * An enumeration specifying capitalization variant of the font.
 */
public class Variant extends Enum 
{
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    static final private int _NORMAL = 0;
	/** A normal font. */
    static final public org.gnu.pango.Variant NORMAL = new org.gnu.pango.Variant (_NORMAL);
	/** 
	 * A font with the lower case characters replaced by smaller variants of
	 * the capital characters. 
	 */
    static final private int _SMALL_CAPS = 1;
    static final public org.gnu.pango.Variant SMALL_CAPS = new org.gnu.pango.Variant (_SMALL_CAPS);
    static final private org.gnu.pango.Variant[] theInterned = new org.gnu.pango.Variant[] 
    {
        NORMAL, SMALL_CAPS 
    }

;
    static private java.util.Hashtable theInternedExtras;
    static final private org.gnu.pango.Variant theSacrificialOne = new org.gnu.pango.Variant (0);
    static public org.gnu.pango.Variant intern (int value) 
    {
        if (value < theInterned.length) 
        {
            return theInterned[value];
        }
        theSacrificialOne.value_ = value;
        if (theInternedExtras == null) 
        {
            theInternedExtras = new java.util.Hashtable();
        }
        org.gnu.pango.Variant already = (org.gnu.pango.Variant) theInternedExtras.get (
            theSacrificialOne);
        if (already == null) 
        {
            already = new org.gnu.pango.Variant(value);
            theInternedExtras.put(already, already);
        }
        return already;
    }

    private Variant (int value) 
    {
        value_ = value;
    }

    public org.gnu.pango.Variant or (org.gnu.pango.Variant other) 
    {
        return intern(value_ | other.value_);
    }

    public org.gnu.pango.Variant and (org.gnu.pango.Variant other) 
    {
        return intern(value_ & other.value_);
    }

    public org.gnu.pango.Variant xor (org.gnu.pango.Variant other) 
    {
        return intern(value_ ^ other.value_);
    }

    public boolean test (org.gnu.pango.Variant other) 
    {
        return (value_ & other.value_) == other.value_;
    }

    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

