/****************************************************************************
 *                              StubRwTrace.h
 * 
 * Author: Matthew Ballance
 * Desc:
 *
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 *
 ****************************************************************************/
#ifndef INCLUDED_STUB_RW_TRACE_H
#define INCLUDED_STUB_RW_TRACE_H
#include "DFIOValChg.h"
#include "DFIOTrace.h"
#include "StubValChg.h"
#include "ValChgBlock.h"
#include "ValChgBlkVector.h"

class StubTrace : public DFIOTrace {

public:
    StubTrace(
        Char     *name, 
        Uint32    rows,
        Uint32    msb,
        Uint32    lsb,
        Uint32    traceType);


    virtual Int32 setValueBitStr(Uint32 row, Char *bitStr);

    virtual Vector<DFIOValChg> *getValue(Uint32 begin,Uint32 end,Uint32 flags); 

    virtual void clearTrace();

private:
    Vector<ValChgBlock>       *valChgBlocks;
    ValChgBlock               *currValChgBlock;

    Uint32                     findBlock(Uint32 reqTime);
    Uint32                     initial;

};


#endif /* INCLUDED_STUB_RW_TRACE_H */


