#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <limits.h>


#include "prototypes.h"

/*
   Copyright (C) 2003 Red Hat, Inc. All rights reserved.
                                                                                                             
   Usage and distribution of this file are subject to the Open Software License version 2.1
   that can be found at http://www.opensource.org/licenses/osl-2.1.txt and the COPYING file as
   distributed together with this file is included herein by reference. Alternatively you can use 
   and distribute this file under version 1.1 of the same license.
                                                                                                                      
   Author: Arjan van de Ven   <arjanv@redhat.com>

*/

/*
 * This file contains code to help debugging
 */


static void print_type(int type)
{
	switch (type) {
	case IRQ_OTHER:
		printf("other");
		break;
	case IRQ_LEGACY:
		printf("low rate");
		break;
	case IRQ_ETH:
		printf("ethernet");
		break;
	case IRQ_SCSI:
		printf("storage");
		break;
	case IRQ_TIMER:
		printf("timer");
		break;
	case IRQ_GIGE:
		printf("gigabit");
		break;
	default:
		printf("unknown");
	}
}


void dump_settings(void)
{
	int i;
	int t;
	printf("IRQ\t");
	for (i=0; i < cpucount; i++)
		printf("CPU %i\t",i);
	printf("type \n");
	
	for (i=0; i < MAX_INTERRUPTS; i++) {
		if (interrupts[i].type == IRQ_INACTIVE)
			continue;
		printf("%i:\t", i);
		for (t=0; t < cpucount; t++)
			if (((int)interrupts[i].cpu == t) || (interrupts[i].cpu == MAX_CPU))
				printf("%lu\t",interrupts[i].delta);
			else
				printf("\t");
		print_type(interrupts[i].type);
		printf("\n");
	}
	
}
