<?php
#    IRM - The Information Resource Manager
#    Copyright (C) 2001 Yann Ramin
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License (in file COPYING) for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#

include("../include/irm.inc");
require_once 'lib/Config.php';
require_once 'include/i18n.php';

AuthCheck("admin");

commonHeader(_("System Setup"));

if(@$submit == "update")
{
	foreach (array_keys($DEFAULT_CONFIG) as $key)
	{
		if (array_key_exists($key, $_REQUEST))
		{
			Config::Set($key, $_REQUEST[$key]);
		}
		else
		{
			if (is_bool($DEFAULT_CONFIG[$key]))
			{
				Config::Set($key, 0);
			}
		}
	}

	__('IRM System Setup updated.');
	printf('<a href="%s">%s</a>', Config::AbsLoc('users/setup-irm.php'),
		_('View or modify the new settings.'));
}
else
{
__("Welcome to IRM's System Setup.  Here is where we will set up IRM's
system configuration.  On this page you will be able to set system wide
settings such as whether IRM should support computer groups, whether someone
should be emailed when a new work request is entered etc.");

echo "<br><br>\n";

$sysconfig = Config::All();
$notifyassignedbyemail = Checked($sysconfig['notifyassignedbyemail']);
$notifynewtrackingbyemail = Checked($sysconfig['notifynewtrackingbyemail']);
$groups = Checked($sysconfig['groups']);
$usenamesearch = Checked($sysconfig['usenamesearch']);
$userupdates = Checked($sysconfig['userupdates']);
$sendexpire = Checked($sysconfig['sendexpire']);
$showjobsonlogin = Checked($sysconfig['showjobsonlogin']);
$snmp = Checked($sysconfig['snmp']);
$snmp_ping = Checked($sysconfig['snmp_ping']);
$knowledgebase = Checked($sysconfig['knowledgebase']);
$fasttrack = Checked($sysconfig['fasttrack']);
$anonymous = Checked($sysconfig['anonymous']);
$anon_faq = Checked($sysconfig['anon_faq']);
$anon_req = Checked($sysconfig['anon_req']);

PRINT '<form method=get action="'.Config::AbsLoc('users/setup-irm.php').'">';
echo "<table border=0 width=100%>";

PRINT "<TR><TH><B>Functional Options</B></TH></TR>\n";
PRINT "<tr><td><input type=checkbox name=notifyassignedbyemail value=\"1\" $notifyassignedbyemail>";
__("Notify a person who has been assigned a work request via email.");
PRINT "</td></tr>\n";
PRINT "<tr><td><input type=checkbox name=notifynewtrackingbyemail value=\"1\" $notifynewtrackingbyemail>";
__("Notify someone via email when a user has entered a new work request.");
PRINT "</td></tr>\n";
PRINT "<tr><td><input type=text size=20 name=newtrackingemail value=\"".$sysconfig['newtrackingemail']."\">";
__("The email address that should receive notification when a user has entered a work request (seperate multiple email addresses with a comma).");
PRINT "</td></tr>\n";
PRINT "<tr><td><input type=checkbox name=groups value=\"1\" $groups>";
__("Select this option if you would like to be able to group computers together.  This is valuable if you would like people to be able to submit work requests against large numbers of computers, such as a computer lab.");
PRINT "</td></tr>\n";
PRINT "<tr><td><input type=checkbox name=usenamesearch value=\"1\" $usenamesearch>";
__("If this option is selected, users will be able to search for their computer by name instead of being forced to type in an IRM ID to enter a work request.");
PRINT "</td></tr>\n";
PRINT "<tr><td><input type=checkbox name=userupdates value=\"1\" $userupdates>";
__("This option allows users to request updates via email when a tracking job they entered is update in any way (e.g. someone adds a followup, it is marked complete, etc.).");
PRINT "</td></tr>\n";
PRINT "<tr><td><input type=checkbox name=sendexpire value=\"1\" $sendexpire>";
__("Send expires and pragma: nocache headers.");
PRINT "</td></tr>\n";
PRINT "<tr><td><input type=checkbox name=showjobsonlogin value=\"1\" $showjobsonlogin>";
__("Show a user the jobs assigned to him or her immediately after logging on.  If this is not selected, only the number of jobs the user has assigned is displayed.");
PRINT "</td></tr>\n";
PRINT "<tr><td><select name=minloglevel size=1>\n";
$loglevels = array(1 => _('Critical'),
		2 => _('Severe'),
		3 => _('Important'),
		4 => _('Notice'),
		5 => _('Junk'));
echo select_options($loglevels, $sysconfig['minloglevel']);
PRINT "</SELECT>\n";
__("Select the Minimum Log Level.");
PRINT "</td></tr>\n";

PRINT "<tr><td><input type=text size=20 name=logo value=\"".$sysconfig['logo']."\">";
__("The name of the image file you would like used for the IRM logo. Note: the filename should be specified relative to the root of the IRM installation.");
PRINT "</td></tr>\n";

PRINT "<tr><td><input type=checkbox name=knowledgebase value=\"1\" $knowledgebase>";
__("Would you like to use the Knowledge Base system that is now built in to IRM?");
PRINT "</td></tr>\n";

PRINT "<tr><td><input type=checkbox name=fasttrack value=\"1\" $fasttrack>";
__("Would you like to use the the FastTrack capability?");
PRINT "</td></tr>\n";

echo "</table>\n<table border=0 width=100%>";
PRINT "<TR><TH>"._("Simple Network Management Protocol (SNMP)")."</TH></TR>";
PRINT "<tr><td><input type=checkbox name=snmp value=\"1\" $snmp>";
__("Do you wish to enable snmp monitoring (ignore the rest of the questions in this section if you don't check this option).");
PRINT "</td></tr>";
PRINT "<tr><td><input type=text size=20 name=snmp_rcommunity value=\"".$sysconfig['snmp_rcommunity']."\">";
__(" The name of the \"read\" or \"public\" snmp community.");
PRINT "</td></tr>";
PRINT "<tr><td><input type=checkbox name=snmp_ping value=\"1\" $snmp_ping>";
__("Ping this host when it is loaded into the computer editor.  This option can cause big delays if the host is down - use with caution.");
PRINT "</td></tr>";
echo "</TABLE>\n<table border=0 width=100%>";
PRINT "<TR><TH>"._("Interface options")."</TH></TR>";
PRINT "<tr><td><input type=checkbox name=anonymous value=\"1\" $anonymous>";
__("Do you wish to enable anonymous actions? (Submit ticket, read FAQ, etc).");
PRINT "</td></tr>";
PRINT "<input type=hidden name=anon_faq value=\"1\" $anon_faq> <input type=hidden name=anon_req value=\"1\" $anon_req>";

?>
</TABLE>
<INPUT TYPE=HIDDEN NAME="submit" VALUE="update">
<TABLE BORDER=0 WIDTH=100%>
<TR>
<TD><INPUT TYPE=SUBMIT VALUE="<?php __("Update") ?>"></TD>
</TR>
</TABLE>
</FORM>
<?php
}
commonFooter();
