// Isometric-ify a 128x128 CEL file

#include <stdio.h>
#include <stdlib.h>
#include <mem.h>
#include <time.h>

unsigned char oldbuf[128][128];
unsigned char newbuf[128][256];
unsigned char palbuf[768];

#define putsh(a,b) {putc(a&255,b);putc((a>>8)&255,b);}

main(int argc,char *argv[])
{
FILE *fp;
unsigned int ID;
unsigned int w,h,ctr;
unsigned long sizey,cx,cy;

char *filename=argv[1];

fp=fopen(filename,"rb");
if(!fp)
	{
	puts("Could not open file");
	exit(1);
	}
fseek(fp,32L,SEEK_SET);
fread(palbuf,768,1,fp);
fread(oldbuf,16384,1,fp);
fclose(fp);

for(ctr=0;ctr<128;ctr++)
	{
	memcpy(&newbuf[ctr][0],&oldbuf[ctr],128);
	memcpy(&newbuf[ctr][128],&oldbuf[ctr],128);
	}

for(ctr=0;ctr<128;ctr++)
	memcpy(&oldbuf[ctr][0],&newbuf[ctr][128-ctr],128);

fp=fopen(filename,"wb");
if(!fp)
	{
	puts("Could not write to file");
	exit(1);
	}

putsh(0x9119,fp);
putsh(128,fp);
putsh(128,fp);
putsh(0,fp);	// x coord
putsh(0,fp);	// y coord
putc(8,fp);	// 8 bits/pixel
putc(0,fp);	// 0 compression
sizey=w*h;
fwrite(&sizey,4,1,fp);
fseek(fp,32L,SEEK_SET);
fwrite(palbuf,768,1,fp);
fwrite(oldbuf,16384,1,fp);
fclose(fp);
return 1;
}



