package ipac_cfg;

require 5.004;
                                   
use strict;
use vars qw(@ISA @EXPORT $pg_host $pg_port $pg_dbname $pg_login $pg_pwd 
	    $fetchipac $ipacsum $menu $charset);
use Exporter;

@ISA = qw(Exporter);

@EXPORT = qw (reconfig check_passwd make_passwd);

# =()<$ipac_cfg::pg_host="@<WEB_HOST>@";>()=
$ipac_cfg::pg_host="";

# =()<$ipac_cfg::pg_port="@<DBASE_PORT>@";>()=
$ipac_cfg::pg_port="";

# =()<$ipac_cfg::pg_dbname="@<DBASE>@";>()=
$ipac_cfg::pg_dbname="ipac";

# =()<$ipac_cfg::pg_login="@<WEB_LOGIN>@";>()=
$ipac_cfg::pg_login="apache";

# =()<$ipac_cfg::pg_pwd="@<WEB_PASS>@";>()=
$ipac_cfg::pg_pwd="";

# =()<my $prefix="@<prefix>@";>()=
my $prefix="/usr/local";

$ipac_cfg::prefix=$prefix;

# =()<my $exec_prefix="@<exec_prefix>@";>()=
my $exec_prefix="${prefix}";

$ipac_cfg::exec_prefix="${prefix}";

# =()<my $INSTALLPATH="@<INSTALLPATH>@";>()=
my $INSTALLPATH="/usr/local/sbin";

# =()<my $RECONFLAG="@<RECONFLAG>@";>()=
my $RECONFLAG="/var/lib/ipac/flag";

$ipac_cfg::fetchipac = "$INSTALLPATH/fetchipac";
$ipac_cfg::ipacsum = "$INSTALLPATH/ipacsum";
$ipac_cfg::charset = "koi8-r";
$ipac_cfg::menu = 
'<HR>
<table cellpadding="0" cellspacing="0"><tr>
	<td>Browse &nbsp;</td>
        <td>New &nbsp;</td>
	<td><a href="../../cgi-bin/make_pay">Make payment</a>&nbsp;</td>
        <td><a href="../../cgi-bin/traffic">Traffic statistics</a></td>
</tr>
<tr>
	<td><a HREF="../../cgi-bin/br_customers">customers</a></td>
        <td><a href="../../cgi-bin/new_customer">customer</a></td>
</tr>
<tr>
        <td><a HREF="../../cgi-bin/br_services">services</a></td>
        <td><a href="../../cgi-bin/new_service">service</a></td>
</tr>
<tr>
	<td><a HREF="../../cgi-bin/br_tariffs">tariffs</a></td>
	<td><a href="../../cgi-bin/new_tariff">tariff</a></td>
</tr>
<tr>
	<td><a HREF="../../cgi-bin/br_nets">nets</a></td>
	<td><a href="../../cgi-bin/new_net_name">net name</a></td>
</tr>
<tr>
	<td><a HREF="../../cgi-bin/br_tar_name">tariffs names</a>&nbsp;&nbsp;</td>
	<td><a href="../../cgi-bin/new_tar_name">tariff name</a>&nbsp;&nbsp;</td>
</tr>
</table>
<hr>';


## make password by method, supposed in $2 from string given in $1
sub make_passwd {
	my $pass = shift;
	my $method = shift;
	my $new_pass;
	if ($method =~ /plain/i) {
		return $pass;
	} elsif ($method =~ /crypt/i) {
		$new_pass = crypt ($pass, join '', ('.', '/', 0..9,'A'..'Z', 
					'a'..'z')[rand 64, rand 64]);
		return $new_pass;
	} else {
		return -1;
	}
}

## check password supplied in $1 with method, supplied in $2
## against secret supplied in $3
## currently supported methods are "plain" for plain-text password and
##				   "crypt" for system crypted ones
## returns 
##	0  in case password is correct
##	1  password mismatch
##	-1 not supported method
sub check_passwd {
	my $pass = shift;
	my $method = shift;
	my $secret = shift;
	
	if ($method =~ /plain/i) {
		return 0 if ($pass eq $secret);
		return 1;
	} elsif ($method =~ /crypt/i) {
		if (crypt($pass, $secret) ne $secret) {
			return 1;
		} else {
			return 0;
		}
	} else {
		return -1;
	}
}

sub reconfig {
	my $some = shift;
	if ($some eq "") {$some = "do it\n"};
	open(FLAG, ">$RECONFLAG") || die "cant open flagfile\n";
	print(FLAG "$some");
	close(FLAG);
}

return 1;
