#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "imapfilter.h"


/*
 * An implementation of strstr() with case-insensitivity.
 */
char *
xstrcasestr(const char *haystack, const char *needle)
{
	const char *h, *n, *c;
	size_t hl, nl;

	c = haystack;
	n = needle;
	hl = strlen(haystack);
	nl = strlen(needle);

	while (hl >= nl) {
		while (tolower(*c) != tolower(*needle)) {
			c++;
			hl--;
			if (hl < nl)
				return NULL;
		}

		h = c;
		n = needle;

		while (tolower(*h) == tolower(*n)) {
			h++;
			n++;

			if (*n == '\0')
				return (char *)c;
		}
		c++;
		hl--;
	}

	return NULL;
}


#if 0
/*
 * Copies at most size characters from the string pointed by src to the array
 * pointed by dest, always NULL terminating (unless size == 0).  Returns
 * pointer to dest.
 */
char *
xstrncpy(char *dest, const char *src, size_t size)
{
	char *d;
	const char *s;
	size_t n;

	d = dest;
	s = src;
	n = size;

	while (n != 0) {
		if ((*d++ = *s++) == '\0')
			break;
		n--;
	}

	if (n == 0 && size != 0)
		*d = '\0';

	return dest;
}
#endif
