/* 
 * ImagesWindow.m created by phr on 2000-10-21 09:33:55 +0000
 *
 * Project ImageViewer
 *
 * Created with ProjectCenter - http://www.gnustep.org
 *
 * $Id: ImagesWindow.m,v 1.11 2003/06/29 17:28:34 probert Exp $
 */

#include "ImagesWindow.h"
#include "BrowserController.h"
#include "Inspector.h"

@implementation ImagesWindow

- (id)initWithContentsAtPath:(NSString *)path
{
  NSAssert(path,_(@"No path specified!"));

  if ((self = [super init])) 
  {
    NSRect contentRect;
    int m = (NSTitledWindowMask |  NSClosableWindowMask | 
	     NSMiniaturizableWindowMask | NSResizableWindowMask);
    NSScrollView *scrollView = nil;
    NSImageView *view = nil; 
    NSImage *image;
    NSSplitView *split;

    window = [[NSWindow alloc] initWithContentRect:NSZeroRect
			       styleMask:m			       
			       backing: NSBackingStoreRetained 
			       defer:YES];
    [window setReleasedWhenClosed:YES];

    if ([window setFrameUsingName:@"default ImagesWindow"] == NO) 
    {
	NSRect frame = {{0,0}, {640, 480}};

	[window setFrame:frame display:NO];
	contentRect = [NSWindow contentRectForFrameRect:frame
			       	              styleMask:m];
    }
    else 
    {
	contentRect = [NSWindow contentRectForFrameRect:[window frame]
                                              styleMask:m];
    }

    split = [[NSSplitView alloc] initWithFrame:[[window contentView] frame]];

    contentRect.origin.x = 150;
    contentRect.origin.y = 0;
    contentRect.size.width -= 150;

    scrollView = [[NSScrollView alloc] initWithFrame:contentRect];
    [scrollView setAutoresizingMask:NSViewWidthSizable|NSViewHeightSizable];
    [scrollView setHasVerticalScroller:YES];
    [scrollView setHasHorizontalScroller:YES];

    [window setDelegate:self];
    [window setMinSize:NSMakeSize(200,100)];
    [window setTitleWithRepresentedFilename:path]; 
    [window setReleasedWhenClosed:YES];

    browser = [[NSBrowser alloc]
		initWithFrame: NSMakeRect(0,0,150,contentRect.size.height)];
    [browser setMaxVisibleColumns:1];
    [browser setTitled:NO];
    [browser setAutoresizingMask:NSViewMaxXMargin|NSViewHeightSizable];
    [browser setAllowsMultipleSelection:NO];

    contentRect = NSMakeRect(0,0,10,10);
    view  = [[NSImageView alloc] initWithFrame:contentRect];
    [scrollView setDocumentView:view];
    RELEASE(view);

    [split setVertical:YES];
    [split addSubview:browser];
    [split addSubview:scrollView];
    [split setAutoresizingMask: (NSViewWidthSizable | NSViewHeightSizable)];
    [[window contentView] addSubview:split];
    RELEASE(split);
    RELEASE(scrollView);

    browserController = [[BrowserController alloc] initWithBrowser:browser];
    [browserController setImageView:view];
    [browserController setPath:path];
    [browserController setDelegate:self];

    [browser loadColumnZero];
    [browser setTarget: [browser delegate]];
    [browser setAction: @selector(showImage:)];

    [window setInitialFirstResponder: browser];

    [window center];
    [window orderFrontRegardless];
    [window makeKeyWindow];
    [window display];
  }
  return self;
}

- (void)dealloc
{
  RELEASE(window);
  RELEASE(browserController);
  RELEASE(browser);

  [super dealloc];
}

- (id)delegate
{
  return delegate;
}

- (void)setDelegate:(id)aDelegate
{
  delegate = aDelegate;
}

- (void)windowWillClose:(NSNotification *)notif
{
  if ([[notif object] isEqual:window]) {
    if (delegate && 
	[delegate respondsToSelector:@selector(imagesWindowWillClose:)]) {
      {
	[delegate imagesWindowWillClose:self];
	[window setDelegate: nil];
	window = nil;
      }
    }
  }
}

- (void)windowDidBecomeKey:(NSNotification *)aNotification
{
    if( [[aNotification object] isEqual:window] ) {
        [[Inspector sharedInspector] imageWindowDidBecomeActive:self];
    }
}

- (NSString *)path
{
    return [browserController currentPath];
}

- (NSString *)imagePath
{
    return [[browserController currentPath] stringByDeletingLastPathComponent];
}

- (NSString *)imageName
{
    return [[browserController currentPath] lastPathComponent];
}

- (NSString *)imageType
{
    return [[browserController currentPath] pathExtension];
}

- (NSString *)imageSize
{
    NSDictionary *attr = [browserController currentAttribs];
    int bytes = [[attr objectForKey:@"NSFileSize"] intValue];

    return [NSString stringWithFormat:@"%d Bytes",bytes];
}

- (NSString *)imageFileModificationDate
{
    NSDictionary *attr = [browserController currentAttribs];
    NSDate *date = nil;

    if( attr == nil ) {
        return [NSString string];
    }

    date = [attr objectForKey:@"NSFileModificationDate"];

    return [date descriptionWithCalendarFormat:@"%Y-%m-%d %H:%M:%S" 
                                      timeZone:nil 
				        locale:nil];
}

- (NSString *)imageFilePermissions
{
    NSDictionary *attr = [browserController currentAttribs];

    if( attr == nil ) {
        return [NSString string];
    }

    return [[attr objectForKey:@"NSFilePosixPermissions"] description];
}

- (NSString *)imageFileOwner
{
    NSDictionary *attr = [browserController currentAttribs];

    if( attr == nil ) {
        return [NSString string];
    }

    return [attr objectForKey:@"NSFileOwnerAccountName"];
}

- (NSString *)imageResolution
{
    NSSize imageSize = [browserController currentImgSize];

    return [NSString stringWithFormat:@"%.1f x %.1f",imageSize.width,
                                                     imageSize.height];
}

- (NSString *)bitsPerSample
{
    NSImageRep *rep = [browserController currentImgRep];

    if( rep == nil ) {
        return [NSString string];
    }

    return [NSString stringWithFormat:@"%d",[rep bitsPerSample]];
}

- (NSString *)colorSpaceName
{
    NSImageRep *rep = [browserController currentImgRep];

    if( rep == nil ) {
        return [NSString string];
    }

    return [rep colorSpaceName];
}

- (NSString *)hasAlpha
{
    NSImageRep *rep = [browserController currentImgRep];

    if( rep == nil ) {
        return [NSString string];
    }

    return [NSString stringWithFormat:@"%@",[rep hasAlpha]?_(@"Yes"):_(@"No")];
}

- (NSString *)imageReps
{
    int reps = [browserController currentImgRepCount];

    return [NSString stringWithFormat:@"%d",reps];
}

- (void)browserSelectionDidChange:(id)sender
{
    [[Inspector sharedInspector] imageWindowDidBecomeActive:self];
}

@end

