/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#ifndef _PY_STATIC_H
#define _PY_STATIC_H

static char* SHENGMUSTR[26] =
{
   /* Total 26*/
    "a",  "b",  "c",  "ch", "d",
    "e",  "f",  "g",  "h",  "j",
    "k",  "l",  "m",  "n",  "o",
    "p",  "q",  "r",  "s",  "sh",
    "t",  "w",  "x",  "y",  "z",
    "zh"
};


/************************
    a    e    m    n    o
    0   80  191  211  237
    1   81  192  212  238 
************************/
static int INDEXSMTOYINJIE[27] = 
{
/*  "a",  "b",  "c",  "ch",  "d", */
      0,    5,   21,    38,   57,
      
/*  "e",  "f",  "g",   "h",  "j", */
     80,   84,   94,   113,  132,

/*  "k",  "l",  "m",   "n",  "o", */
    146,  165,  191,   211,  237,

/*  "p",  "q",  "r",   "s",  "sh", */
    239,  256, 	270,   285,  301,

/*  "t",  "w",  "x",   "y",  "z", */
    320,  340, 	349,   363,  378,

/*  "zh" */
    395,  415
};


/*
**  i ==> ch,   u ==> sh,   v ==> zh
*/
static int INDEXMAGIC[26] = 
{ 
  /* a   b   c   d   e   f   g   h   i   j   k   l   m */
     0,  1,  2,  4,  5,  6,  7,  8,  3,  9, 10, 11, 12,
     
  /* n   o   p   q   r   s   t   u   v   w   x   y   z */
    13, 14, 15, 16, 17, 18, 20, 19, 25, 21, 22, 23, 24
};


static char* YUNMUSTR[] =
{
	/* з(33)  */
    "a",    "ai",   "an",   "ang",  "ao",
    "e",    "ei",   "en",   "eng",  "er",
    "i",    "ia",   "ian",  "iang", "iao",
    "ie",   "in",   "ing",  "iong", "iu",
    "o",    "ong",  "ou",   "u",    "v",
    "ua",   "uai",  "uan",  "uang", "ue",
    "ui",   "un",   "uo",
	/* 䥦(3)  */
    "io",   "ion",  "on"
};

#define NUM_YINJIE  415
static char* YINJIESTR[NUM_YINJIE + 1] = 
{
    "a",      "ai",     "an",     "ang",    "ao",      
    "ba",     "bai",    "ban",    "bang",   "bao",     
    "bei",    "ben",    "beng",   "bi",     "bian",    
    "biao",   "bie",    "bin",    "bing",   "bo",      
    "bu",     "ca",     "cai",    "can",    "cang",    
    "cao",    "ce",     "cei",    "cen",    "ceng",    
    "cha",    "chai",   "chan",   "chang",  "chao",    
    "che",    "chen",   "cheng",  "chi",    "chong",   
    "chou",   "chu",    "chua",   "chuai",  "chuan",   
    "chuang", "chui",   "chun",   "chuo",   "ci",      
    "cong",   "cou",    "cu",     "cuan",   "cui",     
    "cun",    "cuo",    "da",     "dai",    "dan",     
    "dang",   "dao",    "de",     "dei",    "den",     
    "deng",   "di",     "dia",    "dian",   "diao",    
    "die",    "ding",   "diu",    "dong",   "dou",     
    "du",     "duan",   "dui",    "dun",    "duo",     
    "e",      "en",     "eng",    "er",     "fa",      
    "fan",    "fang",   "fei",    "fen",    "feng",    
    "fiao",   "fo",     "fou",    "fu",     "ga",      
    "gai",    "gan",    "gang",   "gao",    "ge",      
    "gei",    "gen",    "geng",   "gong",   "gou",     
    "gu",     "gua",    "guai",   "guan",   "guang",   
    "gui",    "gun",    "guo",    "ha",     "hai",     
    "han",    "hang",   "hao",    "he",     "hei",     
    "hen",    "heng",   "hong",   "hou",    "hu",      
    "hua",    "huai",   "huan",   "huang",  "hui",     
    "hun",    "huo",    "ji",     "jia",    "jian",    
    "jiang",  "jiao",   "jie",    "jin",    "jing",    
    "jiong",  "jiu",    "ju",     "juan",   "jue",     
    "jun",    "ka",     "kai",    "kan",    "kang",    
    "kao",    "ke",     "kei",    "ken",    "keng",    
    "kong",   "kou",    "ku",     "kua",    "kuai",    
    "kuan",   "kuang",  "kui",    "kun",    "kuo",     
    "la",     "lai",    "lan",    "lang",   "lao",     
    "le",     "lei",    "leng",   "li",     "lia",     
    "lian",   "liang",  "liao",   "lie",    "lin",     
    "ling",   "liu",    "lo",     "long",   "lou",     
    "lu",     "lv",     "luan",   "lue",    "lun",     
    "luo",    "m",      "ma",     "mai",    "man",     
    "mang",   "mao",    "me",     "mei",    "men",     
    "meng",   "mi",     "mian",   "miao",   "mie",     
    "min",    "ming",   "miu",    "mo",     "mou",     
    "mu",     "n",      "na",     "nai",    "nan",     
    "nang",   "nao",    "ne",     "nei",    "nen",     
    "neng",   "ni",     "nian",   "niang",  "niao",    
    "nie",    "nin",    "ning",   "niu",    "nong",    
    "nou",    "nu",     "nv",     "nuan",   "nue",     
    "nun",    "nuo",    "o",      "ou",     "pa",      
    "pai",    "pan",    "pang",   "pao",    "pei",     
    "pen",    "peng",   "pi",     "pian",   "piao",    
    "pie",    "pin",    "ping",   "po",     "pou",     
    "pu",     "qi",     "qia",    "qian",   "qiang",   
    "qiao",   "qie",    "qin",    "qing",   "qiong",   
    "qiu",    "qu",     "quan",   "que",    "qun",     
    "ran",    "rang",   "rao",    "re",     "ren",     
    "reng",   "ri",     "rong",   "rou",    "ru",      
    "rua",    "ruan",   "rui",    "run",    "ruo",     
    "sa",     "sai",    "san",    "sang",   "sao",     
    "se",     "sen",    "seng",   "sha",    "shai",    
    "shan",   "shang",  "shao",   "she",    "shei",    
    "shen",   "sheng",  "shi",    "shou",   "shu",     
    "shua",   "shuai",  "shuan",  "shuang", "shui",    
    "shun",   "shuo",   "si",     "song",   "sou",     
    "su",     "suan",   "sui",    "sun",    "suo",     
    "ta",     "tai",    "tan",    "tang",   "tao",     
    "te",     "tei",    "teng",   "ti",     "tian",    
    "tiao",   "tie",    "ting",   "tong",   "tou",     
    "tu",     "tuan",   "tui",    "tun",    "tuo",     
    "wa",     "wai",    "wan",    "wang",   "wei",     
    "wen",    "weng",   "wo",     "wu",     "xi",      
    "xia",    "xian",   "xiang",  "xiao",   "xie",     
    "xin",    "xing",   "xiong",  "xiu",    "xu",      
    "xuan",   "xue",    "xun",    "ya",     "yan",     
    "yang",   "yao",    "ye",     "yi",     "yin",     
    "ying",   "yo",     "yong",   "you",    "yu",      
    "yuan",   "yue",    "yun",    "za",     "zai",     
    "zan",    "zang",   "zao",    "ze",     "zei",     
    "zen",    "zeng",   "zha",    "zhai",   "zhan",    
    "zhang",  "zhao",   "zhe",    "zhei",   "zhen",    
    "zheng",  "zhi",    "zhong",  "zhou",   "zhu",     
    "zhua",   "zhuai",  "zhuan",  "zhuang", "zhui",    
    "zhun",   "zhuo",   "zi",     "zong",   "zou",     
    "zu",     "zuan",   "zui",    "zun",    "zuo", ""
};

/*
**  "CH SH ZH"in the following table was adjusted.
*/
static char* YINJIESTR_CSZ[NUM_YINJIE + 1] = 
{
    "a",      "ai",     "an",     "ang",    "ao",      
    "ba",     "bai",    "ban",    "bang",   "bao",     
    "bei",    "ben",    "beng",   "bi",     "bian",    
    "biao",   "bie",    "bin",    "bing",   "bo",      
    "bu",     "ca",     "cai",    "can",    "cang",    
    "cao",    "ce",     "cei",    "cen",    "ceng",    
    "ci",     "cong",   "cou",    "cu",     "cuan",   
    "cui",    "cun",    "cuo",    "cha",    "chai",   
    "chan",   "chang",  "chao",   "che",    "chen",   
    "cheng",  "chi",    "chong",  "chou",   "chu",    
    "chua",   "chuai",  "chuan",  "chuang", "chui",   
    "chun",   "chuo",   "da",     "dai",    "dan",     
    "dang",   "dao",    "de",     "dei",    "den",     
    "deng",   "di",     "dia",    "dian",   "diao",    
    "die",    "ding",   "diu",    "dong",   "dou",     
    "du",     "duan",   "dui",    "dun",    "duo",     
    "e",      "en",     "eng",    "er",     "fa",      
    "fan",    "fang",   "fei",    "fen",    "feng",    
    "fiao",   "fo",     "fou",    "fu",     "ga",      
    "gai",    "gan",    "gang",   "gao",    "ge",      
    "gei",    "gen",    "geng",   "gong",   "gou",     
    "gu",     "gua",    "guai",   "guan",   "guang",   
    "gui",    "gun",    "guo",    "ha",     "hai",     
    "han",    "hang",   "hao",    "he",     "hei",     
    "hen",    "heng",   "hong",   "hou",    "hu",      
    "hua",    "huai",   "huan",   "huang",  "hui",     
    "hun",    "huo",    "ji",     "jia",    "jian",    
    "jiang",  "jiao",   "jie",    "jin",    "jing",    
    "jiong",  "jiu",    "ju",     "juan",   "jue",     
    "jun",    "ka",     "kai",    "kan",    "kang",    
    "kao",    "ke",     "kei",    "ken",    "keng",    
    "kong",   "kou",    "ku",     "kua",    "kuai",    
    "kuan",   "kuang",  "kui",    "kun",    "kuo",     
    "la",     "lai",    "lan",    "lang",   "lao",     
    "le",     "lei",    "leng",   "li",     "lia",     
    "lian",   "liang",  "liao",   "lie",    "lin",     
    "ling",   "liu",    "lo",     "long",   "lou",     
    "lu",     "lv",     "luan",   "lue",    "lun",     
    "luo",    "m",      "ma",     "mai",    "man",     
    "mang",   "mao",    "me",     "mei",    "men",     
    "meng",   "mi",     "mian",   "miao",   "mie",     
    "min",    "ming",   "miu",    "mo",     "mou",     
    "mu",     "n",      "na",     "nai",    "nan",     
    "nang",   "nao",    "ne",     "nei",    "nen",     
    "neng",   "ni",     "nian",   "niang",  "niao",    
    "nie",    "nin",    "ning",   "niu",    "nong",    
    "nou",    "nu",     "nv",     "nuan",   "nue",     
    "nun",    "nuo",    "o",      "ou",     "pa",      
    "pai",    "pan",    "pang",   "pao",    "pei",     
    "pen",    "peng",   "pi",     "pian",   "piao",    
    "pie",    "pin",    "ping",   "po",     "pou",     
    "pu",     "qi",     "qia",    "qian",   "qiang",   
    "qiao",   "qie",    "qin",    "qing",   "qiong",   
    "qiu",    "qu",     "quan",   "que",    "qun",     
    "ran",    "rang",   "rao",    "re",     "ren",     
    "reng",   "ri",     "rong",   "rou",    "ru",      
    "rua",    "ruan",   "rui",    "run",    "ruo",     
    "sa",     "sai",    "san",    "sang",   "sao",     
    "se",     "sen",    "seng",   "si",     "song",   
    "sou",    "su",     "suan",   "sui",    "sun",    
    "suo",    "sha",    "shai",   "shan",   "shang",  
    "shao",   "she",    "shei",   "shen",   "sheng",  
    "shi",    "shou",   "shu",    "shua",   "shuai",  
    "shuan",  "shuang", "shui",   "shun",   "shuo",   
    "ta",     "tai",    "tan",    "tang",   "tao",     
    "te",     "tei",    "teng",   "ti",     "tian",    
    "tiao",   "tie",    "ting",   "tong",   "tou",     
    "tu",     "tuan",   "tui",    "tun",    "tuo",     
    "wa",     "wai",    "wan",    "wang",   "wei",     
    "wen",    "weng",   "wo",     "wu",     "xi",      
    "xia",    "xian",   "xiang",  "xiao",   "xie",     
    "xin",    "xing",   "xiong",  "xiu",    "xu",      
    "xuan",   "xue",    "xun",    "ya",     "yan",     
    "yang",   "yao",    "ye",     "yi",     "yin",     
    "ying",   "yo",     "yong",   "you",    "yu",      
    "yuan",   "yue",    "yun",    "za",     "zai",     
    "zan",    "zang",   "zao",    "ze",     "zei",     
    "zen",    "zeng",   "zi",     "zong",   "zou",     
    "zu",     "zuan",   "zui",    "zun",    "zuo",
    "zha",    "zhai",   "zhan",   "zhang",  "zhao",   
    "zhe",    "zhei",   "zhen",   "zheng",  "zhi",    
    "zhong",  "zhou",   "zhu",    "zhua",   "zhuai",  
    "zhuan",  "zhuang", "zhui",   "zhun",   "zhuo", ""
};

/* HUr: e᧡ipr, bɧ@PIŸ */
#define NUM_NONLINKHZ   16
static unsigned char NONLINKHZ[2 * NUM_NONLINKHZ + 2] = 
    "OF]ӧAڥLPoNM";
/*    1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 */

/* HUr: uiPep, iPp. */
#define NUM_PRELINKHZ   22
static unsigned char PRELINKHZ[2 * NUM_PRELINKHZ + 2] = 
    "̩ʭlWU~ƪ̮a~ɤ";
/*    1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 */

/* HUr: uiPp, iPep. */
#define NUM_SUFLINKHZ   36
static unsigned char SUFLINKHZ[2 * NUM_SUFLINKHZ + 2] = 
    "boq쨺ĦUCY`ѦpHQϧBNi|Ӧܳ";
/*    1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 */

/*
** bUdCiku.dat, r]ANONLINKHZMUDSINGLEHZⶵ, 
** UDSINGLEHZqPRELINKHZMSUFLINKHZ`X!!DnOƵ, sM
*/
#define NUM_UDSINGLEHZ  (NUM_NONLINKHZ + NUM_NUMPRELINKHZ + NUM_SUFLINKHZ)
/* static unsigned char UDSINGLEHZ[2 * NUM_UDSINGLEHZ + 2] = ""; */

#endif   /* End of _PY_STATIC_H */
