/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include <stdio.h>
#include "hzinput.h"
#include "encode.h"

#define IME_Status		ime_buffer->return_status
#define Input_Buf		ime_buffer->inputkey_buf
#define Input_Len		ime_buffer->inputkey_len
#define Preedit_Buf		ime_buffer->preedit_buf
#define Preedit_Len		ime_buffer->preedit_len
#define Preedit_CaretPos	ime_buffer->preedit_caretpos
#define Commit_Buf		ime_buffer->commit_buf
#define Commit_Len		ime_buffer->commit_len
#define Status_Buf		ime_buffer->status_buf
#define Status_Len		ime_buffer->status_len
#define Lookup_Buf		ime_buffer->lookup_buf
#define Lookup_Num		ime_buffer->lookup_num
#define Lookup_Pos		ime_buffer->cur_lookup_pos
#define Candidates_Buf		ime_buffer->candidates_buf
#define Additions_Buf		ime_buffer->additions_buf

int Is_UsedCodes_Key(int key)
{
	if ( 	(key >= '0' && key <= '9') || 
		(key >= 'a' && key <= 'f') ||
		(key >= 'A' && key <= 'F') )
		return(1);
	else
		return(0);
}

int Is_BackSpace_Key(int key)
{
	if (key == BACKSPACE_KEY || key == DELETE_KEY)
		return(1);

	return(0);
}

int Is_ClearAll_Key(int key)
{
	if (key == ESC_KEY)
		return(1);

	return(0);
}

/* return value:  IME_NOT_USED_KEY:  if IME not use this key, return this key to systerm directly */
/*                IME_USED_KEY:      if IME has used this key */
int neima_filter(encode_id, key_event, ime_buffer)
int encode_id;
IMEKey   key_event;
IMEBuffer ime_buffer;
{

	int  ret, key;
	int  code_len;

	IME_Status = 0;
	Lookup_Num = 0;

	key = map_keyevent_to_imekey(key_event);

	if (key == IME_NOT_USED_KEY)
		return(IME_NOT_USED_KEY);

    	if (Is_UsedCodes_Key(key)) { 
		DEBUG_printf("UsedCodes === \n");

        	Preedit_Buf[Preedit_Len] = toupper(key) ;
        	Preedit_Len ++;
		Preedit_CaretPos = Preedit_Len;
        	Preedit_Buf[Preedit_Len] = '\0';

		DEBUG_printf("Preedit_Buf:%s, Preedit_Len:%d\n", Preedit_Buf, Preedit_Len);
		code_len = 4;
		if (Preedit_Len >= 4) {
			if (encode_id == ENCODE_EUC_TW) {
				if (Preedit_Buf[0] == '8' && Preedit_Buf[1] == 'E')
					code_len = 8;
			} else if (encode_id == ENCODE_GB18030) {
				unsigned char code0, code1;

				convert_code(Preedit_Buf, 4, Commit_Buf);
				code0 = Commit_Buf[0];
				code1 = Commit_Buf[1];
				if ((code0 >= 0x81 && code0 <= 0xFE) &&
				    (code1 >= 0x30 && code1 <= 0x39))
					code_len = 8;
			}
		}

		IME_Status = IME_PREEDIT_AREA;

		/* if inputted keys length has over the limit */
        	if(Preedit_Len >= code_len) {
			convert_code(Preedit_Buf, code_len, Commit_Buf);
			ret = is_valid_code(encode_id, Commit_Buf, code_len/2);
			if (ret == -1) {
				Preedit_Len = 0;
			} else {
				Preedit_Len = 0;
				Commit_Len = strlen((char *)Commit_Buf);
				IME_Status |= IME_COMMIT;
			}
        	}

		return(IME_USED_KEY);
	}

    	if(Is_ClearAll_Key(key)) { 

		/* Esc , clear preedit, lookup choice pointer, and so on */
		DEBUG_printf("ESC_KEY\n");

		/*  if no inputted key, directly return this key */
		if (Preedit_Len==0) return(IME_NOT_USED_KEY);

		Preedit_Len = 0;
		IME_Status = IME_PREEDIT_AREA;
		return (IME_USED_KEY);
    	}

    	if (Is_BackSpace_Key(key)) { /* Back Space & Delete */
		DEBUG_printf("BACKSPACE_KEY\n");

		/*  if no inputted key, directly return this key */
		if (Preedit_Len==0) return(IME_NOT_USED_KEY);

        	/* Delete characters in pre-edit region */
		Preedit_Len --;
       		Preedit_Buf[Preedit_Len] = '\0';

		IME_Status = IME_PREEDIT_AREA;
		return(IME_USED_KEY);
    	}

	/* for unnormal keys */
	if (Preedit_Len==0) return(IME_NOT_USED_KEY);
	else return(IME_USED_KEY);
}

convert_code(char *str_code,int code_len, unsigned char *int_code)
{
	int i;
	char hi_char, low_char, hi_int, low_int;
	
	/* code_len is 2, 4 or 8 */
	for (i = 0; i < code_len/2; i++) {
		hi_char = str_code[2*i];
		low_char = str_code[2*i+1];
		
		if (hi_char >= '0' && hi_char <= '9')
			hi_int = hi_char - 0x30;
		else if (hi_char >= 'a' && hi_char <= 'f')
			hi_int = hi_char - 0x57;
		else if (hi_char >= 'A' && hi_char <= 'F')
			hi_int = hi_char - 0x37;
		else
			hi_int = 0;

		if (low_char >= '0' && low_char <= '9')
			low_int = low_char - 0x30;
		else if (low_char >= 'a' && low_char <= 'f')
			low_int = low_char - 0x57;
		else if (low_char >= 'A' && low_char <= 'F')
			low_int = low_char - 0x37;
		else 
			low_int = 0;

		int_code[i] = hi_int * 0x10 + low_int;
	}
	int_code[code_len/2] = 0;
}

