/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include <windows.h>
#include "IMThread.hh"

struct IMThreadP {
  void *stack_base;
  size_t stack_size;
  ThreadStartProc start_routine;
  void *arg;
  long flags;
  HANDLE tid;
};

IMThread::IMThread(ThreadStartProc start_routine, void *arg) {
  p = new IMThreadP;

  p->stack_base = NULL;
  p->stack_size = 0;
  p->start_routine = start_routine;
  p->arg = arg;
  p->flags = 0;
  Manage();
}

IMThread::IMThread(void *stack_base, size_t stack_size,
		   ThreadStartProc start_routine,
		   void *arg, long flags) {

  size_t min_size = 0;

  p = new IMThreadP;

  p->stack_base = stack_base;

  p->stack_size = (stack_size < min_size)? min_size : stack_size;
  p->start_routine = start_routine;
  p->arg = arg;
  p->flags = flags;
  Manage();
}

IMThread::~IMThread() {
  Unmanage();
  delete p;
}

int
IMThread::Manage() {
  DWORD threadID; 
  int ret = 0;
  p->tid = CreateThread(0, p->stack_size,
				(LPTHREAD_START_ROUTINE) p->start_routine, p->arg, p->flags, &threadID); 
  if (p->tid == NULL)
	  ret = -1;
  return ret;
}

int
IMThread::Unmanage() {
  int status = 0;
  if (p->tid != 0) {
     BOOL bstatus;
     DWORD threadStatus;
  
     bstatus = GetExitCodeThread(p->tid, &threadStatus);
     if (threadStatus == STILL_ACTIVE) {
        // Stop the thread
        TerminateThread(p->tid, 0);
	    CloseHandle(p->tid);
     }
     delete p;
   } 
  return status;
}

// thr_join(3T)
int
IMThread::Join(IMThread * wait_for, IMThread * departed, void **status) {
  return 0;
}

int
IMThread::Join(IMThread *departed, void **status) {
  return 0;
}

int
IMThread::Join(void **status) {
  return 0;
}

// thr_suspend(3T), thr_continue(3T)
int
IMThread::Suspend() {
  DWORD suspend_status;

  suspend_status = SuspendThread(p->tid);
  if (suspend_status & 0xFFFFFFFF)
     return -1;
  else
     return 0; 
}

int
IMThread::Continue() {
  DWORD resume_status;

  resume_status = ResumeThread(p->tid);
  if (resume_status & 0xFFFFFFFF)
     return -1;
  else
     return 0; 
}

#if 0
unsigned int
IMThread::get_thread() {
  DWORD id;
  id = GetCurrentThreadId();
  return id;
}

#endif
