/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/


package sun.awt.im.iiimp;

import java.awt.*;
import java.text.*;
import com.sun.iiim.*;

class StatusWindow extends IIIMWindow implements IIIMStatusListener {
    static int xMargin;
    static int width;
    static int height;
    
    StatusPane pane;
    
    int columWidth, columHeight;
    FontMetrics fm;
    
    // Default, no arg constructor
    public StatusWindow() {
    }
    
    void init() {
        window = new Window(new Frame(""));
	window.enableInputMethods(false);        
	Font font = new Font("Monospaced", Font.PLAIN, 12);
	
        fm = window.getFontMetrics(font);
        int fontHeight = fm.getHeight();
        int fontWidth = fm.getMaxAdvance();
        int fontAscent = fm.getAscent();
        columWidth = fontWidth ;
        columHeight = fontHeight + 2;
        	
        pane = new StatusPane();
        pane.setFont(font);
        
        window.add(pane);
    }
    
    /* These code causes focus flashing problem with Solaris JVM
       
    public void activate() {
        if (window == null) {
            return;
	}
	window.setVisible(true);
    }

    public void deactivate(boolean isTemporary) {
	if (window == null) {
	    return;
	}
	window.setVisible(false);
    }
    */

    // StatusListener method
    public void statusStart(IIIMStatusEvent e) {
	if (window == null) {
	    init();
	}
    }

    public void statusDone(IIIMStatusEvent e) {
	if (window != null) { 
	    window.setVisible(false);
	}
    }

    public void statusDraw(IIIMStatusEvent e) {
	if (window == null) {
	    return;
	}
	pane.handleEvent(e);

	if(pane.getData().length()==0) return;
	// "15" is the drawString space
	int width = pane.getData().length() * columWidth + 15;
	Insets inset = window.getInsets();
	int height = columHeight + inset.top + inset.bottom ;
        
	window.setSize(width, height);
        
	calculatePosition();
        
	window.setVisible(true);
    }

    public void setLocation(int x, int y) {
    }
    
    void calculatePosition() {
        double width = window.getSize().getWidth();
        
        Component component = getClientComponent();

        Component f = component;
        while(!(f instanceof Frame) && !(f instanceof Dialog)) {
            f = f.getParent();
        }
        
        Point point = f.getLocation();
        
        Dimension size = f.getSize();     
        
        double x = point.getX() + size.getWidth() - width;
        double y = point.getY() + size.getHeight();
        window.setLocation((int)x, (int)y);    
        // If window is out of screen, adjust it
        Point location = window.getLocation();
        double xl = location.getX();
        double yl = location.getY();
        Dimension dm = window.getSize();
        if((xl + dm.getWidth()) > screenWidth) 
            xl = screenWidth - dm.getWidth();
        if((yl + dm.getHeight()) > screenHeight) 
            yl = screenHeight - dm.getHeight();
        window.setLocation((int)xl, (int)yl);        
    }
    
}
