<?php
// File           showblob.php / ibWebAdmin
// Purpose        displays the blob specified through the GET-varibles
// Author         Lutz Brueckner <irie@gmx.de>
// Copyright      (c) 2000, 2001, 2002, 2003, 2004 by Lutz Brueckner,
//                published under the terms of the GNU General Public Licence v.2,
//                see file LICENCE for details
// Created        <01/10/21 13:25:50 lb>
//
// $Id: showblob.php,v 1.13 2004/03/07 17:08:37 lbrueckner Exp $


// GET-Variables specifying the blob to display:
//
//       $table: table containing the blob
//       $col  : column containing the blob
//       $where: sql-where-clause specifying the primary keys to fetch the blob

require('inc/script_start.inc.php');

globalize_session_vars();

if ($HTTP_SERVER_VARS['REQUEST_METHOD'] == 'GET') {
    $table = $HTTP_GET_VARS['table'];
    $col   = $HTTP_GET_VARS['col'];
    $where = urldecode($HTTP_GET_VARS['where']);
}
else { 
    $table = $HTTP_POST_VARS['table'];
    $col   = $HTTP_POST_VARS['col'];
    $where = $HTTP_POST_VARS['where'];

    $s_watch_blobas[$col] = $HTTP_POST_VARS['blobtype'];
}
if (get_magic_quotes_gpc()) {
    $where = stripslashes($where);
}

$imageurl =  'showimage.php?where='.urlencode($where).'&table='.$table.'&col='.$col;
$imageurl .= '&'.uniqid('UNIQ_');

$blob = get_blob_content(sprintf('SELECT %s FROM %s %s', $col, $table, $where));

$title = build_title("Blob from $table $where", FALSE);
echo html_head($title);

echo '<body bgcolor="'.$s_cust['color']['area']."\">\n";
echo js_window_resize(BLOB_WINDOW_WIDTH, BLOB_WINDOW_HEIGHT);
echo '<form method="post" action="'.$HTTP_SERVER_VARS['PHP_SELF'].'" name="showblob_form">'."\n";
hidden_session_field();
hidden_field('table', $table);
hidden_field('col', $col);
hidden_field('where', $where);

echo "<table>\n<tr>\n<td>\n";
echo get_selectlist('blobtype', $blob_types, $s_watch_blobas[$col], TRUE);
echo "</td>\n<td>\n";
echo '<input type="submit" name="change_blobtype" value="Change Type">'."\n";
echo "</td>\n<td width=\"50\">\n</td>\n<td>\n";
echo '<input type="button" value="Close" onClick="self.close()">'."\n";
echo "</td>\n</tr>\n<table>\n";
echo "</form>\n";

$blobas = (isset($s_watch_blobas[$col])  &&  $s_watch_blobas[$col] != '') ? $s_watch_blobas[$col] : 'hex';
switch ($blobas) {
    case 'png':
    case 'jpg':
    case 'gif':
        echo '<img src="'.$imageurl."\">\n";
        break;
    case 'text':
        echo '<pre align="left">'.$blob."</pre>\n";
        break;
    case 'html':
        echo $blob;
        break;
    case 'hex':
        echo hex_view($blob);
        break;
}

echo html_bottom();


function &hex_view(&$data) {
    global $s_cust;

    $len   = strlen($data);
    $lines = ceil($len / 16);
    $offset = $values = $ascii = '';
    $p = 0;
    for ($i=1; $i<=$lines; $i++) {
        $offset .= sprintf('%08x', $p);
        
        for ($j=0; $j<16; $j++) {
            if ($p > $len -1) {
                break;
            }
            $values .= sprintf('%02x', ord($data[$p])).'&nbsp;';
            $ascii  .= hex2ascii($data[$p]);
            $p++;
        }

        $offset .= "<br>\n";
        $values .= "<br>\n";
        $ascii  .= "<br>\n";
    }

     return "<table>\n<tr>\n"
         ."<td>\n<table>\n<tr>\n<td bgcolor=\"".$s_cust['color']['area']."\" class=\"hex\">\n"
         .$offset
         ."</td>\n</tr>\n</table>\n</td>\n"
         ."<td>\n<table>\n<tr>\n<td class=\"hex\">\n"
         .$values
         ."</td>\n</tr>\n</table>\n</td>\n"
         ."<td>\n<table>\n<tr>\n<td bgcolor=\"".$s_cust['color']['area']."\" class=\"hex\">\n"
         .$ascii
         ."</td>\n</tr>\n</table>\n</td>\n"
         ."</tr>\n</table>\n";
}


function hex2ascii($val) {

    return (ord($val) > 31  && ord($val) < 128) ? str_replace(' ', '&nbsp;', htmlspecialchars($val)) : '.';
}

?>
