#include "hx_types.h"
#include "htlc.h"
#include <stdlib.h>
#include "hxlib.h"
#include "dhargs.h"
#include "hx.h"
#include <netinet/in.h>
#include "screen.h"
#include "list.h"
#include <string.h>
#include "term.h"
#include "xmalloc.h"

struct privchat *chat_list = 0, *curchat = 0;

void privchat_del (struct privchat *pc);
struct privchat *privchat_new (u_int32_t ref);
struct privchat *privchat_lookup (u_int32_t ref);
struct privchat *privchat_lookup_subject (char *subj, char slen);
int cmd_join (int argc, char *const *argv);
int cmd_leave (int argc, char *const *argv);
int cmd_invite (int argc, char *const *argv);
int cmd_subject (int argc, char *const *argv);
int cmd_chat (int argc, char *const *argv);
int cmd_chats (void);
int cmd_pwho (int argc, char *const *argv);

void
privchat_del (struct privchat *pc)
{
	LISTREM(struct privchat *, chat_list, pc)
	user_kill(&(pc->user_list));
	xfree(pc);
}

void
privchat_kill (void)
{
	register struct privchat *next, *pc = chat_list;

	while (pc) {
		next = pc->next;
		user_kill(&(pc->user_list));
		xfree(pc);
		pc = next;
	}
	chat_list = 0;
}

struct privchat *
privchat_new (u_int32_t ref)
{
	struct privchat *pc;

	pc = xmalloc(sizeof *pc);
	memset(pc, 0, sizeof *pc);
	pc->ref = ref;
	LISTADD(struct privchat *, chat_list, pc)

	return pc;
}

struct privchat *
privchat_lookup (u_int32_t ref)
{
	register struct privchat *pc;

	for (pc = chat_list; pc; pc = pc->next)
		if (pc->ref == ref)
			return pc;

	return 0;
}

struct privchat *
privchat_lookup_subject (char *subj, char slen)
{
	register struct privchat *pc;

	for (pc = chat_list; pc; pc = pc->next)
		if (!strncmp(pc->subject, subj, slen))
			return pc;

	return 0;
}

void
rcv_chat_user_list (struct privchat *pc)
{
	struct hx_userlist_hdr *uh;
	struct user *usr, **ulp = &(pc->user_list);

	dh_start(&(hx_buf[SIZEOF_HX_HDR]), hx_pos - SIZEOF_HX_HDR)
		switch (ntohs(dh->type)) {
			case HTLS_DATA_USER_LIST:
				uh = (struct hx_userlist_hdr *)dh;
				usr = user_new(ulp);
				usr->sock = (u_int32_t)ntohs(uh->sock);
				usr->icon = (u_int16_t)ntohs(uh->icon);
				usr->colour = (u_int16_t)ntohs(uh->colour);
				usr->nlen = (u_int8_t)ntohs(uh->nlen) > 31 ? 31 : ntohs(uh->nlen);
				memcpy(usr->nick, uh->nick, usr->nlen);
				usr->nick[usr->nlen] = 0;
				break;
			case HTLS_DATA_CHAT_SUBJECT:
				break;
		}
	dh_end()
	curchat = pc;
	curscr->draw(curscr);
	user_print(pc->user_list);
}

void
rcv_chat_user_change (void)
{
	u_int32_t sock = 0, icon = 0, colour = 0, pcref = 0;
	u_int8_t *nick = 0, nlen = 0;
	struct user *usr, **ulp;
	register struct privchat *pc;

	dh_start(&(hx_buf[SIZEOF_HX_HDR]), hx_pos - SIZEOF_HX_HDR)
		switch (ntohs(dh->type)) {
			case HTLS_DATA_SOCKET:
				dh_getint(sock);
				break;
			case HTLS_DATA_ICON:
				dh_getint(icon);
				break;
			case HTLS_DATA_NICK:
				nlen = ntohs(dh->len) > 31 ? 31 : ntohs(dh->len);
				nick = dh->data;
				break;
			case HTLS_DATA_COLOUR:
				dh_getint(colour);
				break;
			case HTLS_DATA_CHAT_REF:
				dh_getint(pcref);
				break;
		}
	dh_end()
	if (!(pc = privchat_lookup(pcref))) {
		pc = privchat_new(pcref);
		curchat = pc;
		curscr->draw(curscr);
	}
	ulp = &(pc->user_list);
	if (!(usr = user_lookup_sock(*ulp, sock))) {
		usr = user_new(ulp);
		usr->sock = (u_int32_t)sock;
		curscr_printf("\n <\xa5> [chat 0x%x] join: %.*s [%u:%u:%u]", pc->ref,
				nlen, nick, sock, icon, colour);
	} else {
		curscr_printf("\n <\xa5> [chat 0x%x] %s [%u:%u:%u] is now known as %.*s [%u:%u:%u]",
				pc->ref, usr->nick, usr->sock, usr->icon, usr->colour,
				nlen, nick, sock, icon, colour);
	}
	if (nlen) {
		usr->nlen = nlen;
		memcpy(usr->nick, nick, nlen);
		usr->nick[nlen] = 0;
	}
	if (icon)
		usr->icon = (u_int16_t)icon;
	if (colour != 0x7f000001)
		usr->colour = (u_int16_t)colour;
	hx_reset();
}

void
rcv_chat_user_leave (void)
{
	u_int32_t sock = 0, pcref = 0;
	struct user *usr;
	struct privchat *pc;

	dh_start(&(hx_buf[SIZEOF_HX_HDR]), hx_pos - SIZEOF_HX_HDR)
		switch (ntohs(dh->type)) {
			case HTLS_DATA_SOCKET:
				dh_getint(sock);
				break;
			case HTLS_DATA_CHAT_REF:
				dh_getint(pcref);
				break;
		}
	dh_end()
	if ((pc = privchat_lookup(pcref)) &&
		(usr = user_lookup_sock(pc->user_list, sock))) {
			curscr_printf("\n <\xa5> [chat 0x%x] parts: %s [%u:%u:%u]",
			pc->ref, usr->nick, usr->sock, usr->icon, usr->colour);
			LISTREM(struct user *, pc->user_list, usr)
			xfree(usr);
	}
	hx_reset();
}

void
rcv_chat_subject (void)
{
	u_int32_t pcref = 0;
	unsigned char *subj = 0, slen = 0;
	struct privchat *pc;

	dh_start(&(hx_buf[SIZEOF_HX_HDR]), hx_pos - SIZEOF_HX_HDR)
		switch (ntohs(dh->type)) {
			case HTLS_DATA_CHAT_REF:
				dh_getint(pcref);
				break;
			case HTLS_DATA_CHAT_SUBJECT:
				slen = (char)ntohs(dh->len);
				subj = dh->data;
				break;
		}
	dh_end()
	if (slen && (pc = privchat_lookup(pcref))) {
		memcpy(pc->subject, subj, slen);
		pc->subject[slen] = 0;
		pc->slen = slen;
		curscr_printf("\n <\xa5> [chat 0x%x] subject: %.*s", pcref, slen, subj);
		if (curchat)
			curscr->draw(curscr);
	}
	hx_reset();
}

void
rcv_chat_invite (void)
{
	u_int32_t sock = 0, pcref = 0;
	u_int8_t *nick = 0, nlen = 0;

	dh_start(&(hx_buf[SIZEOF_HX_HDR]), hx_pos - SIZEOF_HX_HDR)
		switch (ntohs(dh->type)) {
			case HTLS_DATA_SOCKET:
				dh_getint(sock);
				break;
			case HTLS_DATA_CHAT_REF:
				dh_getint(pcref);
				break;
			case HTLS_DATA_NICK:
				nlen = ntohs(dh->len);
				nick = dh->data;
				break;
		}
	dh_end()
	curscr_printf("\n <\xa5> [%.*s(%u)] invites you to chat 0x%x", nlen, nick, sock, pcref);
	hx_reset();
}

int
cmd_chat (int argc, char *const *argv)
{
	u_int32_t sock;

	if (argc < 2) {
		curscr_printf("\nusage: %s {sock|nick}", argv[0]);
		return 0;
	}
	if (!(sock = atou32(argv[1])) &&
		!(sock = sock_lookup_nick(argv[1], (u_int8_t)strlen(argv[1])))) {
			curscr_printf("\n%s: %s: no such nick", argv[0], argv[1]);
			return 0;
	}
	task_new(hx_trans, (task_fn_t)rcv_chat_user_change, 0, 0);
	htlc_snd_chat_create(sock);

	return 0;
}

int
cmd_invite (int argc, char *const *argv)
{
	u_int32_t sock, pcref;
	struct privchat *pc;

	if (argc < 3) {
		curscr_printf("\nusage: %s <chat> {sock|nick}", argv[0]);
		return 0;
	}
	if (!(pcref = atou32(argv[1]))) {
		if ((pc = privchat_lookup_subject(argv[1], (u_int8_t)strlen(argv[1]))))
			pcref = pc->ref;
		else {
			curscr_printf("\n%s: no such chat %s", argv[0], argv[1]);
			return 0;
		}
	}
	if (!(sock = atou32(argv[2])) &&
		!(sock = sock_lookup_nick(argv[2], (u_int8_t)strlen(argv[2])))) {
			curscr_printf("\n%s: %s: no such nick", argv[0], argv[2]);
			return 0;
	}
	htlc_snd_chat_invite(pcref, sock);

	return 0;
}

int
cmd_subject (int argc, char *const *argv)
{
	if (argc < 2) {
		curscr_printf("usage: %s <subject>", argv[0]);
		return 0;
	}
	if (curchat)
		htlc_snd_chat_subject(curchat->ref, argv[1], (u_int16_t)strlen(argv[1]));

	return 0;
}

int
cmd_join (int argc, char *const *argv)
{
	u_int32_t pcref;
	struct privchat *pc;

	if (argc < 2) {
		curscr_printf("\nusage: %s <chat>", argv[0]);
		return 0;
	}
	if (!(pcref = atou32(argv[1]))) {
		if (argv[1][0] != '0') {
			if (!(pc = privchat_lookup_subject(argv[1], (u_int8_t)strlen(argv[1])))) {
				curscr_printf("\n%s: no such chat %s", argv[0], argv[1]);
				return 0;
			}
		} else
			pc = 0;
	} else {
		if (!(pc = privchat_lookup(pcref))) {
			pc = privchat_new(pcref);
			task_new(hx_trans, (task_fn_t)rcv_chat_user_list, (task_fn_t)privchat_del, pc);
			htlc_snd_chat_join(pcref);
			return 0;
		}
	}
	curchat = pc;
	curscr->draw(curscr);

	if (pc)
		return (int)pc->ref;
	else
		return 0;
}

int
cmd_leave (int argc, char *const *argv)
{
	u_int32_t pcref;
	struct privchat *pc;

	if (argc < 2) {
		curscr_printf("\nusage: %s <chat>", argv[0]);
		return 0;
	}
	if (!(pcref = atou32(argv[1]))) {
		if ((pc = privchat_lookup_subject(argv[1], (u_int8_t)strlen(argv[1]))))
			pcref = pc->ref;
		else {
			curscr_printf("\n%s: no such chat %s", argv[0], argv[1]);
			return 0;
		}
	} else if (!(pc = privchat_lookup(pcref))) {
		curscr_printf("\n%s: no such chat %s", argv[0], argv[1]);
		return 0;
	}
	htlc_snd_chat_leave(pcref);
	if (curchat == pc) {
		curchat = 0;
		curscr->draw(curscr);
	}
	privchat_del(pc);

	return 0;
}

int
cmd_chats (void)
{
	struct privchat *pc;

	term_mode_underline();
	curscr_printf("\n chat #      subject");
	term_mode_clear();
	for (pc = chat_list; pc; pc = pc->next)
		curscr_printf("\n 0x%x         %s", pc->ref, pc->subject);

	return 0;
}

int
cmd_pwho (int argc, char *const *argv)
{
	u_int32_t pcref;
	struct privchat *pc;

	if (argc > 1) {
		if (!(pcref = atou32(argv[1])) || !(pc = privchat_lookup(pcref))) {
			if ((pc = privchat_lookup_subject(argv[1], (u_int8_t)strlen(argv[1]))))
				pcref = pc->ref;
			else {
				curscr_printf("\n%s: no such chat %s", argv[0], argv[1]);
				return 0;
			}
		}
	} else {
		if (!chat_list) {
			curscr_printf("\n%s: no chats...", argv[0]);
			return 0;
		}
		pc = chat_list;
	}

	if (argc > 2)
		user_print_search(pc->user_list, argv[2]);
	else
		user_print(pc->user_list);

	return 0;
}
