#ifndef lint
/*static char yysccsid[] = "from: @(#)yaccpar	1.9 (Berkeley) 02/21/93";*/
static char yyrcsid[]
#if __GNUC__ >= 2
  __attribute__ ((unused))
#endif /* __GNUC__ >= 2 */
  = "$OpenBSD: skeleton.c,v 1.23 2004/03/12 13:39:50 henning Exp $";
#endif
#include <stdlib.h>
#define YYBYACC 1
#define YYMAJOR 1
#define YYMINOR 9
#define YYLEX yylex()
#define YYEMPTY -1
#define yyclearin (yychar=(YYEMPTY))
#define yyerrok (yyerrflag=0)
#define YYRECOVERING() (yyerrflag!=0)
#define YYPREFIX "yy"
#line 33 "parse.y"
#include <sys/types.h>

#include "config.h"

#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#endif
#include <sys/tree.h>
#include <sys/queue.h>

#include <stdio.h>
#include <stdlib.h>
#include <err.h>
#include <stdarg.h>
#include <string.h>
#include <errno.h>
#include <time.h>

#include <pcap.h>
#include <dnet.h>

#include <event.h>

#include "honeyd.h"
#include "personality.h"
#include "router.h"
#include "plugins_config.h"
#include "plugins.h"
#include "template.h"
#include "condition.h"
#include "interface.h"
#include "ethernet.h"
#include "pfvar.h"
#include "dhcpclient.h"
#ifdef HAVE_PYTHON
#include "pyextend.h"
#endif

int hydlex(void);
int hydparse(void);
int hyderror(char *, ...);
int hydwarn(char *, ...);
int hydprintf(char *, ...);
void *hyd_scan_string(char *);
int hyd_delete_buffer(void *);

#define yylex hydlex
#define yyparse hydparse
#define yy_scan_string hyd_scan_string
#define yy_delete_buffer hyd_delete_buffer
#define yyerror hyderror
#define yywarn hydwarn
#define yyprintf hydprintf
#define yyin hydin

pf_osfp_t pfctl_get_fingerprint(const char *);
struct action *honeyd_protocol(struct template *, int);
void port_action_clone(struct action *, struct action *);
static void dhcp_template(struct template *tmpl,
    char *interface, char *mac_addr);

static struct evbuffer *buffer = NULL;
int lineno;
char *filename;
int errors = 0;
int curtype = -1;	/* Lex sets it to SOCK_STREAM or _DGRAM */

#line 133 "parse.y"
#ifndef YYSTYPE_DEFINED
#define YYSTYPE_DEFINED
typedef union {
	char *string;
	int number;
	struct link_drop drop;
	struct addr addr;
	struct action action;
	struct template *tmpl;
	struct personality *pers;
	struct addrinfo *ai;
	enum fragpolicy fragp;
	float floatp;
	struct condition condition;
	struct tm time;
	struct condition_time timecondition;
} YYSTYPE;
#endif /* YYSTYPE_DEFINED */
#line 107 "y.tab.c"
#define CREATE 257
#define ADD 258
#define PORT 259
#define BIND 260
#define CLONE 261
#define DOT 262
#define BLOCK 263
#define OPEN 264
#define RESET 265
#define DEFAULT 266
#define SET 267
#define ACTION 268
#define PERSONALITY 269
#define RANDOM 270
#define ANNOTATE 271
#define NO 272
#define FINSCAN 273
#define FRAGMENT 274
#define DROP 275
#define OLD 276
#define NEW 277
#define COLON 278
#define PROXY 279
#define UPTIME 280
#define DROPRATE 281
#define IN 282
#define SYN 283
#define UID 284
#define GID 285
#define ROUTE 286
#define ENTRY 287
#define LINK 288
#define NET 289
#define UNREACH 290
#define SLASH 291
#define LATENCY 292
#define MS 293
#define LOSS 294
#define BANDWIDTH 295
#define SUBSYSTEM 296
#define OPTION 297
#define TO 298
#define SHARED 299
#define NETWORK 300
#define TUNNEL 301
#define TARPIT 302
#define DYNAMIC 303
#define USE 304
#define IF 305
#define OTHERWISE 306
#define EQUAL 307
#define SOURCE 308
#define OS 309
#define IP 310
#define BETWEEN 311
#define DELETE 312
#define LIST 313
#define ETHERNET 314
#define DHCP 315
#define ON 316
#define MAXFDS 317
#define DASH 318
#define TIME 319
#define INTERNAL 320
#define STRING 321
#define CMDSTRING 322
#define IPSTRING 323
#define NUMBER 324
#define PROTO 325
#define FLOAT 326
#define YYERRCODE 256
#if defined(__cplusplus) || defined(__STDC__)
const short yylhs[] =
#else
short yylhs[] =
#endif
	{                                        -1,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   19,   19,   19,   21,   21,   20,   20,   20,   22,
   23,   23,   23,   23,   23,   23,   24,   24,   24,   24,
   24,   24,   24,   24,   24,   25,   25,   26,   26,   26,
   26,   26,   26,    7,    7,    8,    8,    8,    1,    1,
    2,    3,    4,    4,    4,    4,    4,    4,    4,    4,
    4,    5,    5,    5,    6,    6,    9,    9,   11,   11,
   13,   13,   12,   12,   12,   10,   10,   27,   27,   27,
   27,   28,   28,   14,   14,   15,   15,   16,   16,   16,
   16,   17,   18,
};
#if defined(__cplusplus) || defined(__STDC__)
const short yylen[] =
#else
short yylen[] =
#endif
	{                                         2,
    0,    2,    2,    2,    2,    2,    2,    2,    2,    2,
    2,    2,    2,    2,    2,    5,    6,    6,    5,    5,
    3,    4,    4,    4,    6,    3,    6,    4,    4,    4,
    5,    5,    4,    4,    6,    3,    3,    3,    5,   10,
    8,    4,    4,    1,    2,    2,    2,    2,    1,    1,
    3,    3,    2,    2,    3,    3,    5,    5,    1,    1,
    2,    1,    1,    1,    1,    1,    1,    1,    0,    3,
    0,    2,    0,    3,    2,    0,    7,    4,    4,    4,
    5,    1,    2,    0,    1,    0,    1,    4,    4,    4,
    2,    4,    4,
};
#if defined(__cplusplus) || defined(__STDC__)
const short yydefred[] =
#else
short yydefred[] =
#endif
	{                                      1,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    2,    3,    4,    5,    6,    7,    8,
    9,   10,   11,   13,   12,   63,   62,   50,   49,   64,
    0,    0,    0,    0,    0,    0,    0,   66,   65,    0,
    0,    0,    0,   14,    0,   83,    0,    0,    0,    0,
    0,    0,    0,    0,   91,    0,   21,    0,   26,    0,
    0,    0,    0,    0,    0,    0,    0,   44,    0,   36,
   37,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   23,   22,    0,   28,
   30,    0,    0,    0,   29,   33,   45,   46,   47,   48,
    0,    0,    0,   42,   43,    0,   80,   78,   79,    0,
    0,   85,   20,    0,   19,    0,   88,    0,   90,    0,
    0,    0,   68,   67,   31,   32,    0,   39,    0,    0,
   81,   16,    0,   18,   59,   60,   87,   17,    0,    0,
   92,   27,   35,    0,    0,   51,   25,   61,    0,    0,
   53,   54,   93,    0,    0,    0,    0,    0,   56,   55,
   41,    0,    0,    0,    0,    0,   70,   72,    0,    0,
   58,   57,   52,    0,    0,   40,   74,    0,    0,    0,
    0,    0,   77,
};
#if defined(__cplusplus) || defined(__STDC__)
const short yydgoto[] =
#else
short yydgoto[] =
#endif
	{                                       1,
   30,  104,  159,  138,   31,   40,   70,   71,  125,  176,
  156,  170,  164,  113,  139,   35,   55,   86,   14,   15,
   16,   17,   18,   19,   20,   21,   22,   23,
};
#if defined(__cplusplus) || defined(__STDC__)
const short yysindex[] =
#else
short yysindex[] =
#endif
	{                                      0,
 -238, -263, -222, -205, -291, -222, -265, -270, -275, -271,
 -222, -222, -222,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 -202, -284, -250, -259, -288, -222, -188,    0,    0, -153,
 -288, -234, -266,    0, -246,    0, -247, -240, -222, -217,
 -168, -212, -199, -219,    0, -211,    0, -222,    0, -210,
 -265, -200, -170, -197, -194, -193, -151,    0, -235,    0,
    0, -165, -159, -288, -288, -215, -123, -183, -160, -161,
 -222, -178, -175, -288, -130, -169,    0,    0, -117,    0,
    0, -315, -315, -133,    0,    0,    0,    0,    0,    0,
 -288, -288, -138,    0,    0, -167,    0,    0,    0, -166,
 -158,    0,    0, -292,    0, -253,    0, -138,    0, -164,
 -219, -253,    0,    0,    0,    0, -163,    0, -256, -162,
    0,    0, -157,    0,    0,    0,    0,    0, -236, -155,
    0,    0,    0, -288, -137,    0,    0,    0, -180, -154,
    0,    0,    0, -288, -152, -135, -121, -115,    0,    0,
    0, -129, -315, -128, -303, -150,    0,    0, -149, -106,
    0,    0,    0, -148, -140,    0,    0, -147, -120, -139,
 -146, -113,    0,};
#if defined(__cplusplus) || defined(__STDC__)
const short yyrindex[] =
#else
short yyrindex[] =
#endif
	{                                      0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  137,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  170,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  201,    0,    0,    0,    0,    0,    0,  232,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  265,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  270,    0,    0,    0,    0, -232,    0,    1,    0,    0,
    0, -232,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    6,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   68,    0,    0,    0,    0,
    0,    0,    0,   73,    0,    0,    0,    0,    0,  332,
    0,    0,    0,  132,    0,    0,    0,    0,    0,    0,
    0,    0,    0,};
#if defined(__cplusplus) || defined(__STDC__)
const short yygindex[] =
#else
short yygindex[] =
#endif
	{                                      0,
   -4,   32,    0,   59,    2,  121,    0,    0,  -91,    0,
    0,    0,    0,    0,    0,   69,    0,   63,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,
};
#define YYTABLESIZE 647
#if defined(__cplusplus) || defined(__STDC__)
const short yytable[] =
#else
short yytable[] =
#endif
	{                                      34,
   89,  126,   24,   42,   38,   69,   26,   37,  123,  135,
  124,  136,   45,   46,   47,   32,   41,  171,    2,    3,
  172,    4,    5,   73,   52,   53,   33,  148,    6,   36,
   58,   86,    7,   28,   29,   57,   72,   59,   56,   98,
   99,  100,  149,   26,  144,   43,   86,    8,  137,   44,
   80,   28,   29,   74,   76,   75,   39,   25,    9,   88,
   54,   27,   28,   29,   10,   28,   29,   71,   78,  103,
  103,  168,   73,   11,   12,  106,   13,   60,   77,  118,
   61,   79,  115,  150,  151,  152,   81,   86,   86,   86,
   82,   62,   63,   48,   83,   64,  103,  103,   27,   28,
   29,   49,   32,   50,   85,  107,  105,   84,  108,   87,
  109,   92,   93,   33,   89,  119,   28,   29,   67,   68,
   69,   97,   51,   91,  145,   65,   94,   95,   66,  102,
   96,   75,  128,  129,  101,  110,   82,  111,  112,  154,
  157,   28,   29,  114,  158,  116,  117,  120,  121,  161,
  122,  127,  130,  131,  155,  133,  165,  132,  163,  140,
  143,  146,  166,  167,  147,  153,  169,  160,  175,   15,
  178,  162,  180,  173,  174,  177,  179,  182,  181,  183,
  142,   90,  134,  141,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   38,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   84,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   89,   89,    0,
   89,   89,   69,   69,   34,   69,   69,   89,    0,   24,
    0,   89,   69,    0,    0,    0,   69,    0,    0,    0,
   69,    0,    0,    0,    0,    0,   89,    0,    0,    0,
    0,   69,    0,    0,    0,    0,    0,   89,    0,   69,
   69,    0,   69,   89,    0,    0,    0,    0,   69,    0,
    0,    0,   89,   89,    0,   89,    0,   69,   69,    0,
   69,    0,   89,   89,   71,   71,    0,   71,   71,   73,
   73,   76,   73,   73,   71,    0,    0,    0,   71,   73,
    0,    0,   71,   73,    0,    0,    0,   73,    0,    0,
    0,    0,    0,   71,    0,    0,    0,    0,   73,    0,
    0,    0,   71,    0,   71,    0,    0,    0,    0,   73,
   71,    0,    0,    0,    0,   73,    0,    0,    0,   71,
   71,    0,   71,    0,   73,   73,    0,   73,   75,   75,
    0,   75,   75,   82,   82,    0,   82,   82,   75,    0,
    0,    0,   75,   82,    0,    0,   75,   82,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   75,    0,    0,
    0,    0,   82,    0,    0,    0,   15,   15,   75,   15,
   15,    0,    0,   82,   75,    0,   15,    0,    0,   82,
   15,    0,    0,   75,   75,    0,   75,    0,   82,   82,
    0,   82,    0,    0,    0,   15,    0,   38,   38,    0,
   38,   38,    0,    0,    0,    0,   15,   38,    0,    0,
    0,   38,   15,    0,    0,    0,    0,    0,    0,    0,
    0,   15,   15,    0,   15,    0,   38,    0,   84,   84,
    0,   84,   84,    0,    0,    0,    0,   38,   84,    0,
    0,    0,   84,   38,    0,    0,    0,    0,    0,    0,
    0,    0,   38,   38,    0,   38,    0,   84,    0,    0,
    0,   34,   34,    0,   34,   34,   24,   24,   84,   24,
   24,   34,    0,    0,   84,   34,   24,    0,    0,    0,
   24,    0,    0,   84,   84,    0,   84,    0,    0,    0,
   34,    0,    0,    0,    0,   24,    0,    0,    0,    0,
    0,   34,    0,    0,    0,    0,   24,   34,    0,    0,
    0,    0,   24,    0,    0,    0,   34,   34,    0,   34,
    0,   24,   24,    0,   24,    0,    0,    0,   76,   76,
    0,   76,   76,    0,    0,    0,    0,    0,   76,    0,
    0,    0,   76,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   76,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   76,    0,
    0,    0,    0,    0,   76,    0,    0,    0,    0,    0,
    0,    0,    0,   76,   76,    0,   76,
};
#if defined(__cplusplus) || defined(__STDC__)
const short yycheck[] =
#else
short yycheck[] =
#endif
	{                                       4,
    0,   93,  266,    8,  270,    0,  266,    6,  324,  263,
  326,  265,   11,   12,   13,  308,  287,  321,  257,  258,
  324,  260,  261,  258,  309,  310,  319,  264,  267,  321,
   35,  264,  271,  322,  323,   34,   41,   36,  298,  275,
  276,  277,  279,  266,  301,  321,  279,  286,  302,  321,
   49,  322,  323,  288,  321,  290,  322,  321,  297,   58,
  311,  321,  322,  323,  303,  322,  323,    0,  316,   74,
   75,  163,    0,  312,  313,  291,  315,  266,  325,   84,
  269,  322,   81,  320,  321,  322,  304,  320,  321,  322,
  259,  280,  281,  296,  307,  284,  101,  102,  321,  322,
  323,  304,  308,  306,  324,  321,   75,  307,  324,  321,
  326,  282,  283,  319,  325,   84,  322,  323,  272,  273,
  274,  273,  325,  324,  129,  314,  324,  322,  317,  289,
  324,    0,  101,  102,  300,  259,    0,  321,  299,  144,
  321,  322,  323,  305,  149,  324,  322,  278,  318,  154,
  268,  285,  291,  321,  292,  314,  278,  324,  294,  324,
  324,  324,  278,  293,  322,  321,  295,  322,  275,    0,
  311,  324,  293,  324,  324,  324,  324,  324,  318,  293,
  122,   61,  114,  121,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258,   -1,
  260,  261,  257,  258,    0,  260,  261,  267,   -1,    0,
   -1,  271,  267,   -1,   -1,   -1,  271,   -1,   -1,   -1,
  275,   -1,   -1,   -1,   -1,   -1,  286,   -1,   -1,   -1,
   -1,  286,   -1,   -1,   -1,   -1,   -1,  297,   -1,  294,
  295,   -1,  297,  303,   -1,   -1,   -1,   -1,  303,   -1,
   -1,   -1,  312,  313,   -1,  315,   -1,  312,  313,   -1,
  315,   -1,  322,  323,  257,  258,   -1,  260,  261,  257,
  258,    0,  260,  261,  267,   -1,   -1,   -1,  271,  267,
   -1,   -1,  275,  271,   -1,   -1,   -1,  275,   -1,   -1,
   -1,   -1,   -1,  286,   -1,   -1,   -1,   -1,  286,   -1,
   -1,   -1,  295,   -1,  297,   -1,   -1,   -1,   -1,  297,
  303,   -1,   -1,   -1,   -1,  303,   -1,   -1,   -1,  312,
  313,   -1,  315,   -1,  312,  313,   -1,  315,  257,  258,
   -1,  260,  261,  257,  258,   -1,  260,  261,  267,   -1,
   -1,   -1,  271,  267,   -1,   -1,  275,  271,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  286,   -1,   -1,
   -1,   -1,  286,   -1,   -1,   -1,  257,  258,  297,  260,
  261,   -1,   -1,  297,  303,   -1,  267,   -1,   -1,  303,
  271,   -1,   -1,  312,  313,   -1,  315,   -1,  312,  313,
   -1,  315,   -1,   -1,   -1,  286,   -1,  257,  258,   -1,
  260,  261,   -1,   -1,   -1,   -1,  297,  267,   -1,   -1,
   -1,  271,  303,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  312,  313,   -1,  315,   -1,  286,   -1,  257,  258,
   -1,  260,  261,   -1,   -1,   -1,   -1,  297,  267,   -1,
   -1,   -1,  271,  303,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  312,  313,   -1,  315,   -1,  286,   -1,   -1,
   -1,  257,  258,   -1,  260,  261,  257,  258,  297,  260,
  261,  267,   -1,   -1,  303,  271,  267,   -1,   -1,   -1,
  271,   -1,   -1,  312,  313,   -1,  315,   -1,   -1,   -1,
  286,   -1,   -1,   -1,   -1,  286,   -1,   -1,   -1,   -1,
   -1,  297,   -1,   -1,   -1,   -1,  297,  303,   -1,   -1,
   -1,   -1,  303,   -1,   -1,   -1,  312,  313,   -1,  315,
   -1,  312,  313,   -1,  315,   -1,   -1,   -1,  257,  258,
   -1,  260,  261,   -1,   -1,   -1,   -1,   -1,  267,   -1,
   -1,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  286,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  297,   -1,
   -1,   -1,   -1,   -1,  303,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  312,  313,   -1,  315,
};
#define YYFINAL 1
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 326
#if YYDEBUG
#if defined(__cplusplus) || defined(__STDC__)
const char * const yyname[] =
#else
char *yyname[] =
#endif
	{
"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"CREATE","ADD","PORT","BIND",
"CLONE","DOT","BLOCK","OPEN","RESET","DEFAULT","SET","ACTION","PERSONALITY",
"RANDOM","ANNOTATE","NO","FINSCAN","FRAGMENT","DROP","OLD","NEW","COLON",
"PROXY","UPTIME","DROPRATE","IN","SYN","UID","GID","ROUTE","ENTRY","LINK","NET",
"UNREACH","SLASH","LATENCY","MS","LOSS","BANDWIDTH","SUBSYSTEM","OPTION","TO",
"SHARED","NETWORK","TUNNEL","TARPIT","DYNAMIC","USE","IF","OTHERWISE","EQUAL",
"SOURCE","OS","IP","BETWEEN","DELETE","LIST","ETHERNET","DHCP","ON","MAXFDS",
"DASH","TIME","INTERNAL","STRING","CMDSTRING","IPSTRING","NUMBER","PROTO",
"FLOAT",
};
#if defined(__cplusplus) || defined(__STDC__)
const char * const yyrule[] =
#else
char *yyrule[] =
#endif
	{"$accept : config",
"config :",
"config : config creation",
"config : config addition",
"config : config delete",
"config : config subsystem",
"config : config binding",
"config : config set",
"config : config annotate",
"config : config route",
"config : config option",
"config : config ui",
"creation : CREATE STRING",
"creation : CREATE DEFAULT",
"creation : DYNAMIC STRING",
"delete : DELETE template",
"delete : DELETE template PROTO PORT NUMBER",
"addition : ADD template PROTO PORT NUMBER action",
"addition : ADD template USE template IF condition",
"addition : ADD template OTHERWISE USE template",
"subsystem : ADD template SUBSYSTEM CMDSTRING shared",
"binding : BIND ipaddr template",
"binding : BIND condition ipaddr template",
"binding : BIND ipaddr TO STRING",
"binding : DHCP template ON STRING",
"binding : DHCP template ON STRING ETHERNET CMDSTRING",
"binding : CLONE STRING template",
"set : SET template DEFAULT PROTO ACTION action",
"set : SET template PERSONALITY personality",
"set : SET template ETHERNET CMDSTRING",
"set : SET template UPTIME NUMBER",
"set : SET template DROPRATE IN rate",
"set : SET template DROPRATE SYN rate",
"set : SET template MAXFDS NUMBER",
"set : SET template UID NUMBER",
"set : SET template UID NUMBER GID NUMBER",
"annotate : ANNOTATE personality finscan",
"annotate : ANNOTATE personality fragment",
"route : ROUTE ENTRY ipaddr",
"route : ROUTE ENTRY ipaddr NETWORK ipnet",
"route : ROUTE ipaddr ADD NET ipnet ipaddr latency packetloss bandwidth randomearlydrop",
"route : ROUTE ipaddr ADD NET ipnet TUNNEL ipaddr ipaddr",
"route : ROUTE ipaddr LINK ipnet",
"route : ROUTE ipaddr UNREACH ipnet",
"finscan : FINSCAN",
"finscan : NO FINSCAN",
"fragment : FRAGMENT DROP",
"fragment : FRAGMENT OLD",
"fragment : FRAGMENT NEW",
"ipaddr : IPSTRING",
"ipaddr : CMDSTRING",
"ipnet : ipaddr SLASH NUMBER",
"ipaddrplusport : ipaddr COLON NUMBER",
"action : flags STRING",
"action : flags CMDSTRING",
"action : flags INTERNAL CMDSTRING",
"action : flags PROXY ipaddrplusport",
"action : flags PROXY STRING COLON NUMBER",
"action : flags PROXY STRING COLON STRING",
"action : BLOCK",
"action : RESET",
"action : flags OPEN",
"template : STRING",
"template : DEFAULT",
"template : ipaddr",
"personality : CMDSTRING",
"personality : RANDOM",
"rate : FLOAT",
"rate : NUMBER",
"latency :",
"latency : LATENCY NUMBER MS",
"packetloss :",
"packetloss : LOSS rate",
"bandwidth :",
"bandwidth : BANDWIDTH NUMBER NUMBER",
"bandwidth : BANDWIDTH NUMBER",
"randomearlydrop :",
"randomearlydrop : DROP BETWEEN NUMBER MS DASH NUMBER MS",
"option : OPTION STRING STRING NUMBER",
"option : OPTION STRING STRING FLOAT",
"option : OPTION STRING STRING STRING",
"option : OPTION STRING STRING SLASH STRING",
"ui : LIST",
"ui : LIST template",
"shared :",
"shared : SHARED",
"flags :",
"flags : TARPIT",
"condition : SOURCE OS EQUAL CMDSTRING",
"condition : SOURCE IP EQUAL ipaddr",
"condition : SOURCE IP EQUAL ipnet",
"condition : TIME timecondition",
"timecondition : BETWEEN time DASH time",
"time : NUMBER COLON NUMBER STRING",
};
#endif
#ifdef YYSTACKSIZE
#undef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 10000
#define YYMAXDEPTH 10000
#endif
#endif
#define YYINITSTACKSIZE 200
int yydebug;
int yynerrs;
int yyerrflag;
int yychar;
short *yyssp;
YYSTYPE *yyvsp;
YYSTYPE yyval;
YYSTYPE yylval;
short *yyss;
short *yysslim;
YYSTYPE *yyvs;
int yystacksize;
#line 952 "parse.y"

static void
dhcp_template(struct template *tmpl, char *interface, char *mac_addr)
{
	struct interface *inter;
	struct template *newtmpl;
	struct addr addr;
	extern int need_dhcp;
	extern int need_arp;

	if (mac_addr == NULL && tmpl->ethernet_addr == NULL) {
		yyerror("Need an ethernet address for DHCP.");
		return;
	}

	/* Find the right interface */
	if ((inter = interface_find(interface)) == NULL) {
		yyerror("Interface \"%s\" does not exist.", interface);
		return;
	}
	if (inter->if_ent.intf_link_addr.addr_type != ADDR_TYPE_ETH) {
		yyerror("Interface \"%s\" does not support arp.", interface);
		return;
	}

	/* Need to find a temporary IP address */
	if (template_get_dhcp_address(&addr) == -1) {
		yyerror("Failed to obtain temporary IP address.");
		return;
	}

	newtmpl = template_clone(addr_ntoa(&addr), tmpl, inter, 1);
	if (newtmpl == NULL) {
		yyerror("Binding to %s failed", addr_ntoa(&addr));
		return;
	}

	if (mac_addr != NULL) {
		/*
		 * This is more complicated than it should be.
		 * 1. Remove existing ARP table entries.
		 * 2. Set new ethernet MAC address
		 * 3. Assign interface to template
		 * 4. Post new ARP table entry.
		 */
		template_remove_arp(newtmpl);

		newtmpl->ethernet_addr = ethernetcode_make_address(mac_addr);
		if (newtmpl->ethernet_addr == NULL) {
			yyerror("Unknown ethernet vendor \"%s\"", mac_addr);
		}

		newtmpl->inter = inter;

		/* We need to update the ARP binding */
		template_post_arp(newtmpl, &addr);
	}

	/* Wow - now we can assign the DHCP object to it */
	if (dhcp_getconf(newtmpl) == -1) {
		yyerror("Failed to start DHCP on %s",
		    inter->if_ent.intf_name);
		return;
	}

	need_arp = need_dhcp = 1;
}

int
yyerror(char *fmt, ...)
{
	va_list ap;
	errors = 1;

	va_start(ap, fmt);
	if (buffer == NULL) {
		fprintf(stderr, "%s:%d: ", filename, lineno);
		vfprintf(stderr, fmt, ap);
		fprintf(stderr, "\n");
	} else {
		char *data;
		if (vasprintf(&data, fmt, ap) == -1)
			err(1, "%s: vasprintf", __func__);
		evbuffer_add_printf(buffer, "%s: %s\n", filename, data);
		free(data);
	}
	va_end(ap);
	return (0);
}

int
yywarn(char *fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);
	if (buffer == NULL) {
		fprintf(stderr, "%s:%d: ", filename, lineno);
		vfprintf(stderr, fmt, ap);
		fprintf(stderr, "\n");
	} else {
		char *data;
		if (vasprintf(&data, fmt, ap) == -1)
			err(1, "%s: vasprintf", __func__);
		evbuffer_add_printf(buffer, "%s: %s\n", filename, data);
		free(data);
	}
	va_end(ap);
	return (0);
}

int
yyprintf(char *fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);
	if (buffer == NULL) {
		vfprintf(stdout, fmt, ap);
	} else {
		char *data;
		if (vasprintf(&data, fmt, ap) == -1)
			err(1, "%s: vasprintf", __func__);
		evbuffer_add_printf(buffer, "%s", data);
		free(data);
	}
	va_end(ap);
	return (0);
}

int
parse_configuration(FILE *input, char *name)
{
	extern FILE *yyin;

	buffer = NULL;
	errors = 0;
	lineno = 1;
	filename = name;
	yyin = input;
	yyparse();
	return (errors ? -1 : 0);
}

/*
 * Parse from memory.  Error output is buffered
 */

int
parse_line(struct evbuffer *output, char *line)
{
	void *yybuf;

	buffer = output;
	errors = 0;
	lineno = 1;
	filename = "<stdin>";
	yybuf = yy_scan_string(line);
	yyparse();
	yy_delete_buffer(yybuf);
	return (errors ? -1 : 0);
}
#line 718 "y.tab.c"
/* allocate initial stack or double stack size, up to YYMAXDEPTH */
#if defined(__cplusplus) || defined(__STDC__)
static int yygrowstack(void)
#else
static int yygrowstack()
#endif
{
    int newsize, i;
    short *newss;
    YYSTYPE *newvs;

    if ((newsize = yystacksize) == 0)
        newsize = YYINITSTACKSIZE;
    else if (newsize >= YYMAXDEPTH)
        return -1;
    else if ((newsize *= 2) > YYMAXDEPTH)
        newsize = YYMAXDEPTH;
    i = yyssp - yyss;
    newss = yyss ? (short *)realloc(yyss, newsize * sizeof *newss) :
      (short *)malloc(newsize * sizeof *newss);
    if (newss == NULL)
        goto bail;
    yyss = newss;
    yyssp = newss + i;
    newvs = yyvs ? (YYSTYPE *)realloc(yyvs, newsize * sizeof *newvs) :
      (YYSTYPE *)malloc(newsize * sizeof *newvs);
    if (newvs == NULL)
        goto bail;
    yyvs = newvs;
    yyvsp = newvs + i;
    yystacksize = newsize;
    yysslim = yyss + newsize - 1;
    return 0;
bail:
    if (yyss)
            free(yyss);
    if (yyvs)
            free(yyvs);
    yyss = yyssp = NULL;
    yyvs = yyvsp = NULL;
    yystacksize = 0;
    return -1;
}

#define YYABORT goto yyabort
#define YYREJECT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab
int
#if defined(__cplusplus) || defined(__STDC__)
yyparse(void)
#else
yyparse()
#endif
{
    int yym, yyn, yystate;
#if YYDEBUG
#if defined(__cplusplus) || defined(__STDC__)
    const char *yys;
#else /* !(defined(__cplusplus) || defined(__STDC__)) */
    char *yys;
#endif /* !(defined(__cplusplus) || defined(__STDC__)) */

    if ((yys = getenv("YYDEBUG")))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif /* YYDEBUG */

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    if (yyss == NULL && yygrowstack()) goto yyoverflow;
    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if ((yyn = yydefred[yystate]) != 0) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, reading %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: state %d, shifting to state %d\n",
                    YYPREFIX, yystate, yytable[yyn]);
#endif
        if (yyssp >= yysslim && yygrowstack())
        {
            goto yyoverflow;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
#if defined(lint) || defined(__GNUC__)
    goto yynewerror;
#endif
yynewerror:
    yyerror("syntax error");
#if defined(lint) || defined(__GNUC__)
    goto yyerrlab;
#endif
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: state %d, error recovery shifting\
 to state %d\n", YYPREFIX, *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yysslim && yygrowstack())
                {
                    goto yyoverflow;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: error recovery discarding state %d\n",
                            YYPREFIX, *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, error recovery discards token %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: state %d, reducing by rule %d (%s)\n",
                YYPREFIX, yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    yyval = yyvsp[1-yym];
    switch (yyn)
    {
case 12:
#line 164 "parse.y"
{
		if (template_create(yyvsp[0].string) == NULL)
			yyerror("Template \"%s\" exists already", yyvsp[0].string);
		free(yyvsp[0].string);
	}
break;
case 13:
#line 170 "parse.y"
{
		if (template_create("default") == NULL)
			yyerror("Template \"default\" exists already");
	}
break;
case 14:
#line 175 "parse.y"
{		
		struct template *tmpl;
		if ((tmpl = template_create(yyvsp[0].string)) == NULL)
			yyerror("Template \"%s\" exists already", yyvsp[0].string);
		tmpl->flags |= TEMPLATE_DYNAMIC;
		free(yyvsp[0].string);
	}
break;
case 15:
#line 185 "parse.y"
{
		if (yyvsp[0].tmpl != NULL)
			template_free(yyvsp[0].tmpl);
	}
break;
case 16:
#line 190 "parse.y"
{
		struct port *port;
		if ((port = port_find(yyvsp[-3].tmpl, yyvsp[-2].number, yyvsp[0].number)) == NULL) {
			yyerror("Cannot find port %d in \"%s\"",
			    yyvsp[0].number, yyvsp[-3].tmpl->name);
		} else {
			port_free(yyvsp[-3].tmpl, port);
		}
	}
break;
case 17:
#line 201 "parse.y"
{
		if (yyvsp[-4].tmpl != NULL && template_add(yyvsp[-4].tmpl, yyvsp[-3].number, yyvsp[-1].number, &yyvsp[0].action) == -1)
			yyerror("Can not add port %d to template \"%s\"",
			    yyvsp[-1].number, yyvsp[-4].tmpl != NULL ? yyvsp[-4].tmpl->name : "<unknown>");
		if (yyvsp[0].action.action)
			free(yyvsp[0].action.action);
	}
break;
case 18:
#line 209 "parse.y"
{	
		if (yyvsp[-4].tmpl == NULL || yyvsp[-2].tmpl == NULL)
			break;
		if (!(yyvsp[-4].tmpl->flags & TEMPLATE_DYNAMIC))
			yyerror("Cannot add templates to non-dynamic template \"%s\"", yyvsp[-4].tmpl->name);
		template_insert_dynamic(yyvsp[-4].tmpl, yyvsp[-2].tmpl, &yyvsp[0].condition);
	}
break;
case 19:
#line 217 "parse.y"
{	
		if (yyvsp[-3].tmpl == NULL || yyvsp[0].tmpl == NULL)
			break;
		if (!(yyvsp[-3].tmpl->flags & TEMPLATE_DYNAMIC))
			yyerror("Cannot add templates to non-dynamic template \"%s\"", yyvsp[-3].tmpl->name);
		template_insert_dynamic(yyvsp[-3].tmpl, yyvsp[0].tmpl, NULL);
	}
break;
case 20:
#line 226 "parse.y"
{
		struct addr tmp;
		int isaddr;

		isaddr = addr_aton(yyvsp[-3].tmpl->name, &tmp) == -1 ? 0 : 1;

		yyvsp[-1].string[strlen(yyvsp[-1].string) - 1] = '\0';
		if (yyvsp[-3].tmpl != NULL &&
		    template_subsystem(yyvsp[-3].tmpl, yyvsp[-1].string+1, isaddr, yyvsp[0].number) == -1)
			yyerror("Can not add subsystem \"%s\" to template \"%s\"",
			    yyvsp[-1].string+1, yyvsp[-3].tmpl != NULL ? yyvsp[-3].tmpl->name : "<unknown>");
		free(yyvsp[-1].string);
	}
break;
case 21:
#line 241 "parse.y"
{
		/* Bind to an IP address and start subsystems */
		if (yyvsp[0].tmpl == NULL) {
			yyerror("Unknown template");
			break;
		}

		if (yyvsp[0].tmpl->ethernet_addr != NULL) {
			struct interface *inter;
			inter = interface_find_responsible(&yyvsp[-1].addr);
			if (inter == NULL ||
			    inter->if_ent.intf_link_addr.addr_type != ADDR_TYPE_ETH) {
				yyerror("Template \"%s\" is configured with "
				    "ethernet address but there is no "
				    "interface that can reach %s",
				    yyvsp[0].tmpl->name, addr_ntoa(&yyvsp[-1].addr));
				break;
			}
		}

		if (template_clone(addr_ntoa(&yyvsp[-1].addr), yyvsp[0].tmpl, NULL, 1) == NULL) {
			yyerror("Binding to %s failed", addr_ntoa(&yyvsp[-1].addr));
			break;
		}
	}
break;
case 22:
#line 267 "parse.y"
{
		struct template *tmpl;

		/* Special magic */
		if ((tmpl = template_find(addr_ntoa(&yyvsp[-1].addr))) != NULL) {
			if (!(tmpl->flags & TEMPLATE_DYNAMIC)) {
				yyerror("Template \"%s\" already specified as "
				    "non-dynamic template", addr_ntoa(&yyvsp[-1].addr));
				break;
			}
		} else if ((tmpl = template_create(addr_ntoa(&yyvsp[-1].addr))) == NULL) {
			yyerror("Could not create template \"%s\"",
			    addr_ntoa(&yyvsp[-1].addr));
			break;
		}

		/* 
		 * Add this point we do have the right template.
		 * We just need to add the proper condition.
		 */
		template_insert_dynamic(tmpl, yyvsp[0].tmpl, &yyvsp[-2].condition);
	}
break;
case 23:
#line 290 "parse.y"
{
		struct interface *inter;
		struct template *tmpl;

		/* Bind an IP address to an external interface */
		if ((inter = interface_find(yyvsp[0].string)) == NULL) {
			yyerror("Interface \"%s\" does not exist.", yyvsp[0].string);
			free(yyvsp[0].string);
			break;
		}
		if (inter->if_ent.intf_link_addr.addr_type != ADDR_TYPE_ETH) {
			yyerror("Interface \"%s\" does not support arp.", yyvsp[0].string);
			free(yyvsp[0].string);
			break;
		}

		if ((tmpl = template_create(addr_ntoa(&yyvsp[-2].addr))) == NULL) {
			yyerror("Template \"%s\" exists already",
			    addr_ntoa(&yyvsp[-2].addr));
			break;
		}

		/* Make this template external. */
		tmpl->flags |= TEMPLATE_EXTERNAL;
		tmpl->inter = inter;
		free(yyvsp[0].string);
	}
break;
case 24:
#line 318 "parse.y"
{		
		/* Automagically assign DHCP address */
		dhcp_template(yyvsp[-2].tmpl, yyvsp[0].string, NULL);
		free(yyvsp[0].string);
	}
break;
case 25:
#line 324 "parse.y"
{		
		/* Automagically assign DHCP address with MAC address */
		yyvsp[0].string[strlen(yyvsp[0].string) - 1] = '\0';
		dhcp_template(yyvsp[-4].tmpl, yyvsp[-2].string, yyvsp[0].string + 1);
		free(yyvsp[-2].string);
		free(yyvsp[0].string);
	}
break;
case 26:
#line 332 "parse.y"
{
		/* Just clone.  This is not the final destination yet */
		if (yyvsp[0].tmpl == NULL || template_clone(yyvsp[-1].string, yyvsp[0].tmpl, NULL, 0) == NULL)
			yyerror("Cloning to %s failed", yyvsp[-1].string);
		free(yyvsp[-1].string);
	}
break;
case 27:
#line 340 "parse.y"
{
		struct action *action;

		if (yyvsp[-4].tmpl == NULL) {
			yyerror("No template");
			break;
		}
		
		if ((action = honeyd_protocol(yyvsp[-4].tmpl, yyvsp[-2].number)) == NULL) {
			yyerror("Bad protocol");
			break;
		}

		port_action_clone(action, &yyvsp[0].action);
		if (yyvsp[0].action.action != NULL)
			free(yyvsp[0].action.action);
	}
break;
case 28:
#line 358 "parse.y"
{
		if (yyvsp[-2].tmpl == NULL || yyvsp[0].pers == NULL)
			break;
		yyvsp[-2].tmpl->person = personality_clone(yyvsp[0].pers);
	}
break;
case 29:
#line 364 "parse.y"
{
		extern int need_arp;
		if (yyvsp[-2].tmpl == NULL || yyvsp[0].string == NULL)
			break;
		yyvsp[0].string[strlen(yyvsp[0].string) - 1] = '\0';
		yyvsp[-2].tmpl->ethernet_addr = ethernetcode_make_address(yyvsp[0].string + 1);
		if (yyvsp[-2].tmpl->ethernet_addr == NULL) {
			yyerror("Unknown ethernet vendor \"%s\"", yyvsp[0].string + 1);
		}
		free (yyvsp[0].string);

		need_arp = 1;
	}
break;
case 30:
#line 378 "parse.y"
{
		if (yyvsp[-2].tmpl == NULL || yyvsp[0].number == 0)
			break;
		yyvsp[-2].tmpl->timestamp = yyvsp[0].number * 2;
	}
break;
case 31:
#line 384 "parse.y"
{
		if (yyvsp[-3].tmpl == NULL)
			break;
		if (yyvsp[0].floatp > 100) {
			yyerror("Droprate too high: %f", yyvsp[0].floatp);
			break;
		}

		yyvsp[-3].tmpl->drop_inrate = yyvsp[0].floatp * 100;
	}
break;
case 32:
#line 395 "parse.y"
{
		if (yyvsp[-3].tmpl == NULL)
			break;
		if (yyvsp[0].floatp > 100) {
			yyerror("Droprate too high: %f", yyvsp[0].floatp);
			break;
		}

		yyvsp[-3].tmpl->drop_synrate = yyvsp[0].floatp * 100;
	}
break;
case 33:
#line 406 "parse.y"
{
		if (yyvsp[-2].tmpl == NULL)
			break;
		if (yyvsp[0].number <= 3) {
			yyerror("Bad number of max file descriptors %d", yyvsp[0].number);
			break;
		}
		yyvsp[-2].tmpl->max_nofiles = yyvsp[0].number;
	}
break;
case 34:
#line 416 "parse.y"
{
		if (yyvsp[-2].tmpl == NULL)
			break;
		if (!yyvsp[0].number) {
			yyerror("Bad uid %d", yyvsp[0].number);
			break;
		}
		yyvsp[-2].tmpl->uid = yyvsp[0].number;
		honeyd_use_uid(yyvsp[0].number);
	}
break;
case 35:
#line 427 "parse.y"
{
		if (yyvsp[-4].tmpl == NULL)
			break;
		if (!yyvsp[-2].number || !yyvsp[0].number) {
			yyerror("Bad uid %d, gid %d", yyvsp[-2].number, yyvsp[0].number);
			break;
		}
		yyvsp[-4].tmpl->uid = yyvsp[-2].number;
		yyvsp[-4].tmpl->gid = yyvsp[0].number;
		honeyd_use_uid(yyvsp[-2].number);
		honeyd_use_gid(yyvsp[0].number);
	}
break;
case 36:
#line 441 "parse.y"
{
		if (yyvsp[-1].pers == NULL)
			break;
		yyvsp[-1].pers->disallow_finscan = !yyvsp[0].number;
	}
break;
case 37:
#line 447 "parse.y"
{
		if (yyvsp[-1].pers == NULL)
			break;
		yyvsp[-1].pers->fragp = yyvsp[0].fragp;
	}
break;
case 38:
#line 454 "parse.y"
{
		if (router_start(&yyvsp[0].addr, NULL) == -1)
			yyerror("Defining entry point failed: %s",
			    addr_ntoa(&yyvsp[0].addr));
	}
break;
case 39:
#line 460 "parse.y"
{
		if (router_start(&yyvsp[-2].addr, &yyvsp[0].addr) == -1)
			yyerror("Defining entry point failed: %s",
			    addr_ntoa(&yyvsp[-2].addr));
	}
break;
case 40:
#line 466 "parse.y"
{
		struct router *r, *newr;
		struct addr defroute;

		if ((r = router_find(&yyvsp[-8].addr)) == NULL &&
		    (r = router_new(&yyvsp[-8].addr)) == NULL) {
			yyerror("Cannot make forward reference for router %s",
			    addr_ntoa(&yyvsp[-8].addr));
			break;
		}
		if ((newr = router_find(&yyvsp[-4].addr)) == NULL)
			newr = router_new(&yyvsp[-4].addr);
		if (router_add_net(r, &yyvsp[-5].addr, newr, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-1].number, &yyvsp[0].drop) == -1)
			yyerror("Could not add route to %s", addr_ntoa(&yyvsp[-5].addr));

		if (yyvsp[-1].number == 0 && yyvsp[0].drop.high != 0)
			yywarn("Ignoring drop between statement without "
			       "specified bandwidth.");

		addr_pton("0.0.0.0/0", &defroute);
		defroute.addr_bits = 0; /* work around libdnet bug */

		/* Only insert a reverse route, if the current route is
		 * not the default route.
		 */
		if (addr_cmp(&defroute, &yyvsp[-5].addr) != 0 &&
		    router_add_net(newr, &defroute, r, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-1].number, &yyvsp[0].drop) == -1)
			yyerror("Could not add default route to %s",
			    addr_ntoa(&yyvsp[-5].addr));
	}
break;
case 41:
#line 497 "parse.y"
{
		struct router *r;

		if ((r = router_find(&yyvsp[-6].addr)) == NULL &&
		    (r = router_new(&yyvsp[-6].addr)) == NULL) {
			yyerror("Cannot make forward reference for router %s",
			    addr_ntoa(&yyvsp[-6].addr));
			break;
		}
		if (router_add_tunnel(r, &yyvsp[-3].addr, &yyvsp[-1].addr, &yyvsp[0].addr) == -1)
			yyerror("Could not add tunnel to %s", addr_ntoa(&yyvsp[0].addr));
	}
break;
case 42:
#line 510 "parse.y"
{
		struct router *r;

		if ((r = router_find(&yyvsp[-2].addr)) == NULL &&
		    (r = router_new(&yyvsp[-2].addr)) == NULL) {
			yyerror("Cannot make forward reference for router %s",
			    addr_ntoa(&yyvsp[-2].addr));
			break;
		}
		if (router_add_link(r, &yyvsp[0].addr) == -1)
			yyerror("Could not add link %s", addr_ntoa(&yyvsp[0].addr));
	}
break;
case 43:
#line 523 "parse.y"
{
		struct router *r;

		if ((r = router_find(&yyvsp[-2].addr)) == NULL &&
		    (r = router_new(&yyvsp[-2].addr)) == NULL) {
			yyerror("Cannot make forward reference for router %s",
			    addr_ntoa(&yyvsp[-2].addr));
			break;
		}
		if (router_add_unreach(r, &yyvsp[0].addr) == -1)
			yyerror("Could not add unreachable net %s",
			    addr_ntoa(&yyvsp[0].addr));
	}
break;
case 44:
#line 537 "parse.y"
{ yyval.number = 1; }
break;
case 45:
#line 538 "parse.y"
{ yyval.number = 0; }
break;
case 46:
#line 540 "parse.y"
{ yyval.fragp = FRAG_DROP; }
break;
case 47:
#line 541 "parse.y"
{ yyval.fragp = FRAG_OLD; }
break;
case 48:
#line 542 "parse.y"
{ yyval.fragp = FRAG_NEW; }
break;
case 49:
#line 545 "parse.y"
{
		if (addr_pton(yyvsp[0].string, &yyval.addr) < 0)
			yyerror("Illegal IP address %s", yyvsp[0].string);
		free(yyvsp[0].string);
	}
break;
case 50:
#line 551 "parse.y"
{
		struct addrinfo ai, *aitop;

		memset(&ai, 0, sizeof (ai));
		ai.ai_family = AF_INET;
		ai.ai_socktype = 0;
		ai.ai_flags = 0;

		/* Remove quotation marks */
		yyvsp[0].string[strlen(yyvsp[0].string) - 1] = '\0';
		if (getaddrinfo(yyvsp[0].string+1, NULL, &ai, &aitop) != 0) {
			yyerror("getaddrinfo failed: %s", yyvsp[0].string+1);
			break;
		}
		addr_ston(aitop->ai_addr, &yyval.addr);
		freeaddrinfo(aitop);
		free(yyvsp[0].string);
	}
break;
case 51:
#line 571 "parse.y"
{
		char src[25];
		struct addr b;
		snprintf(src, sizeof(src), "%s/%d",
		    addr_ntoa(&yyvsp[-2].addr), yyvsp[0].number);
		if (addr_pton(src, &yyval.addr) < 0)
			yyerror("Illegal IP network %s", src);
		/* Fix libdnet error */
		if (yyvsp[0].number == 0)
			yyval.addr.addr_bits = 0;

		/* Test if this is a legal network */
		addr_net(&yyval.addr, &b);
		b.addr_bits = yyval.addr.addr_bits;
		if (memcmp(&yyval.addr.addr_ip, &b.addr_ip, IP_ADDR_LEN)) {
			yyval.addr = b;
			yywarn("Bad network mask in %s", src);
		}
	}
break;
case 52:
#line 592 "parse.y"
{
		if (curtype == -1) {
			yyerror("Bad port type");
			break;
		}
		yyval.ai = cmd_proxy_getinfo(addr_ntoa(&yyvsp[-2].addr), curtype, yyvsp[0].number);
		curtype = -1;
		if (yyval.ai == NULL)
			yyerror("Illegal IP address port pair");
	}
break;
case 53:
#line 604 "parse.y"
{
		memset(&yyval.action, 0, sizeof(yyval.action));
		yyval.action.action = yyvsp[0].string;
		yyval.action.flags = yyvsp[-1].number;
		yyval.action.status = PORT_OPEN;
	}
break;
case 54:
#line 611 "parse.y"
{
		memset(&yyval.action, 0, sizeof(yyval.action));
		yyvsp[0].string[strlen(yyvsp[0].string) - 1] = '\0';
		if ((yyval.action.action = strdup(yyvsp[0].string + 1)) == NULL)
			yyerror("Out of memory");
		yyval.action.status = PORT_OPEN;
		yyval.action.flags = yyvsp[-1].number;
		free(yyvsp[0].string);
	}
break;
case 55:
#line 621 "parse.y"
{
#ifdef HAVE_PYTHON
		memset(&yyval.action, 0, sizeof(yyval.action));
		yyvsp[0].string[strlen(yyvsp[0].string) - 1] = '\0';
		if ((yyval.action.action_extend = pyextend_load_module(yyvsp[0].string+1)) == NULL)
			yyerror("Bad python module: \"%s\"", yyvsp[0].string+1);
		yyval.action.status = PORT_PYTHON;
		yyval.action.flags = yyvsp[-2].number;
		free(yyvsp[0].string);
#else
		yyerror("Python support is not available.");
#endif
	}
break;
case 56:
#line 635 "parse.y"
{
		memset(&yyval.action, 0, sizeof(yyval.action));
		yyval.action.status = PORT_PROXY;
		yyval.action.action = NULL;
		yyval.action.aitop = yyvsp[0].ai;
		yyval.action.flags = yyvsp[-2].number;
	}
break;
case 57:
#line 643 "parse.y"
{
		memset(&yyval.action, 0, sizeof(yyval.action));
		yyval.action.status = PORT_PROXY;
		yyval.action.action = NULL;
		yyval.action.aitop = NULL;
		yyval.action.flags = yyvsp[-4].number;
		if (yyvsp[-2].string[0] != '$') {
			if (curtype == -1) {
				yyerror("Bad port type");
				break;
			}
			yyval.action.aitop = cmd_proxy_getinfo(yyvsp[-2].string, curtype, yyvsp[0].number);
			curtype = -1;
			if (yyval.action.aitop == NULL)
				yyerror("Illegal host name in proxy");
		} else {
			char proxy[1024];

			snprintf(proxy, sizeof(proxy), "%s:%d", yyvsp[-2].string, yyvsp[0].number);
			yyval.action.action = strdup(proxy);
			if (yyval.action.action == NULL)
				yyerror("Out of memory");
		}
		free(yyvsp[-2].string);
	}
break;
case 58:
#line 669 "parse.y"
{
		char proxy[1024];
		memset(&yyval.action, 0, sizeof(yyval.action));
		yyval.action.status = PORT_PROXY;
		yyval.action.action = NULL;
		yyval.action.aitop = NULL;
		yyval.action.flags = yyvsp[-4].number;

		snprintf(proxy, sizeof(proxy), "%s:%s", yyvsp[-2].string, yyvsp[0].string);
		yyval.action.action = strdup(proxy);
		if (yyval.action.action == NULL)
				yyerror("Out of memory");
		free(yyvsp[-2].string);
		free(yyvsp[0].string);
	}
break;
case 59:
#line 685 "parse.y"
{
		memset(&yyval.action, 0, sizeof(yyval.action));
		yyval.action.status = PORT_BLOCK;
		yyval.action.action = NULL;
	}
break;
case 60:
#line 691 "parse.y"
{
		memset(&yyval.action, 0, sizeof(yyval.action));
		yyval.action.status = PORT_RESET;
		yyval.action.action = NULL;
	}
break;
case 61:
#line 697 "parse.y"
{
		memset(&yyval.action, 0, sizeof(yyval.action));
		yyval.action.status = PORT_OPEN;
		yyval.action.action = NULL;
		yyval.action.flags = yyvsp[-1].number;
	}
break;
case 62:
#line 706 "parse.y"
{
		yyval.tmpl = template_find(yyvsp[0].string);
		if (yyval.tmpl == NULL)
			yyerror("Unknown template \"%s\"", yyvsp[0].string);
		free(yyvsp[0].string);
	}
break;
case 63:
#line 713 "parse.y"
{
		yyval.tmpl = template_find("default");
		if (yyval.tmpl == NULL)
			yyerror("Unknown template \"%s\"", "default");
	}
break;
case 64:
#line 719 "parse.y"
{
		yyval.tmpl = template_find(addr_ntoa(&yyvsp[0].addr));
		if (yyval.tmpl == NULL)
			yyerror("Unknown template \"%s\"", addr_ntoa(&yyvsp[0].addr));
	}
break;
case 65:
#line 726 "parse.y"
{
		yyvsp[0].string[strlen(yyvsp[0].string) - 1] = '\0';
		yyval.pers = personality_find(yyvsp[0].string+1);
		if (yyval.pers == NULL)
			yyerror("Unknown personality \"%s\"", yyvsp[0].string+1);
		free(yyvsp[0].string);
	}
break;
case 66:
#line 734 "parse.y"
{
		yyval.pers = personality_random();
		if (yyval.pers == NULL)
			yyerror("Random personality failed");
	}
break;
case 67:
#line 741 "parse.y"
{
		yyval.floatp = yyvsp[0].floatp;
	}
break;
case 68:
#line 745 "parse.y"
{
		yyval.floatp = yyvsp[0].number;
	}
break;
case 69:
#line 749 "parse.y"
{ yyval.number = 0; }
break;
case 70:
#line 751 "parse.y"
{
		yyval.number = yyvsp[-1].number;
	}
break;
case 71:
#line 755 "parse.y"
{ yyval.number = 0; }
break;
case 72:
#line 757 "parse.y"
{
		yyval.number = yyvsp[0].floatp * 100;
	}
break;
case 73:
#line 761 "parse.y"
{ yyval.number = 0; }
break;
case 74:
#line 763 "parse.y"
{
		yyval.number = yyvsp[-1].number * yyvsp[0].number;
	}
break;
case 75:
#line 767 "parse.y"
{
		yyval.number = yyvsp[0].number;
	}
break;
case 76:
#line 771 "parse.y"
{ memset(&yyval.drop, 0, sizeof(yyval.drop)); }
break;
case 77:
#line 773 "parse.y"
{
		if (yyvsp[-1].number <= yyvsp[-4].number)
			yyerror("Incorrect thresholds. First number needs to "
				"be smaller than second number.");
		yyval.drop.low = yyvsp[-4].number;
		yyval.drop.high = yyvsp[-1].number;
	}
break;
case 78:
#line 782 "parse.y"
{
		struct honeyd_plugin_cfg cfg;

		memset(&cfg, 0, sizeof(struct honeyd_plugin_cfg));
		cfg.cfg_int = yyvsp[0].number;
		cfg.cfg_type = HD_CONFIG_INT;
		plugins_config_item_add(yyvsp[-2].string, yyvsp[-1].string, &cfg);
		
		free(yyvsp[-2].string); free(yyvsp[-1].string);
	}
break;
case 79:
#line 793 "parse.y"
{
		struct honeyd_plugin_cfg cfg;

		memset(&cfg, 0, sizeof(struct honeyd_plugin_cfg));
		cfg.cfg_flt = yyvsp[0].floatp;
		cfg.cfg_type = HD_CONFIG_FLT;
		plugins_config_item_add(yyvsp[-2].string, yyvsp[-1].string, &cfg);

		free(yyvsp[-2].string); free(yyvsp[-1].string);
        }
break;
case 80:
#line 804 "parse.y"
{
		struct honeyd_plugin_cfg cfg;

		memset(&cfg, 0, sizeof(struct honeyd_plugin_cfg));
		cfg.cfg_str = yyvsp[0].string;
		cfg.cfg_type = HD_CONFIG_STR;
		plugins_config_item_add(yyvsp[-2].string, yyvsp[-1].string, &cfg);

		free(yyvsp[-2].string); free(yyvsp[-1].string); free(yyvsp[0].string);
        }
break;
case 81:
#line 816 "parse.y"
{
		struct honeyd_plugin_cfg cfg;
		char path[MAXPATHLEN];

		snprintf(path, sizeof(path), "/%s", yyvsp[0].string);

		memset(&cfg, 0, sizeof(struct honeyd_plugin_cfg));
		cfg.cfg_str = path;
		cfg.cfg_type = HD_CONFIG_STR;
		plugins_config_item_add(yyvsp[-3].string, yyvsp[-2].string, &cfg);

		free(yyvsp[-3].string); free(yyvsp[-2].string); free(yyvsp[0].string);
        }
break;
case 82:
#line 832 "parse.y"
{
	extern struct templtree templates;
	struct template *tmpl;
	int count = 0;

	SPLAY_FOREACH(tmpl, templtree, &templates) {
		count++;
		yyprintf("%4d. %s (%s)\n",
		    count,
		    tmpl->name,
		    tmpl->person != NULL ? tmpl->person->name : "undefined");
	}
}
break;
case 83:
#line 846 "parse.y"
{
	if (yyvsp[0].tmpl != NULL) {
		yyprintf("template %s:\n", yyvsp[0].tmpl->name);
		yyprintf("\tpersonality: %s\n",
		    yyvsp[0].tmpl->person != NULL ? yyvsp[0].tmpl->person->name : "undefined");
		if (yyvsp[0].tmpl->ethernet_addr != NULL)
			yyprintf("\tethernet address: %s\n",
			    addr_ntoa(yyvsp[0].tmpl->ethernet_addr));
		yyprintf("\tIP id: %d\n", yyvsp[0].tmpl->id);
		yyprintf("\tTCP seq: %ld\n", yyvsp[0].tmpl->seq);
		yyprintf("\tTCP drop: in: %d syn: %d\n",
		    yyvsp[0].tmpl->drop_inrate, yyvsp[0].tmpl->drop_synrate);
		yyprintf("\trefcnt: %d\n", yyvsp[0].tmpl->refcnt);
	}
}
break;
case 84:
#line 863 "parse.y"
{
	yyval.number = 0;
}
break;
case 85:
#line 867 "parse.y"
{
	yyval.number = 1;
}
break;
case 86:
#line 873 "parse.y"
{
	yyval.number = 0;
}
break;
case 87:
#line 877 "parse.y"
{
	yyval.number = PORT_TARPIT;
}
break;
case 88:
#line 883 "parse.y"
{
		pf_osfp_t fp;
		yyvsp[0].string[strlen(yyvsp[0].string) - 1] = '\0';
		if ((fp = pfctl_get_fingerprint(yyvsp[0].string+1)) == PF_OSFP_NOMATCH)
			yyerror("Unknown fingerprint \"%s\"", yyvsp[0].string+1);
		if ((yyval.condition.match_arg = malloc(sizeof(fp))) == NULL)
			yyerror("Out of memory");
		memcpy(yyval.condition.match_arg, &fp, sizeof(fp));
		yyval.condition.match = condition_match_osfp;
		yyval.condition.match_arglen = sizeof(fp);
		free (yyvsp[0].string);
	}
break;
case 89:
#line 896 "parse.y"
{
		if ((yyval.condition.match_arg = malloc(sizeof(struct addr))) == NULL)
			yyerror("Out of memory");
		memcpy(yyval.condition.match_arg, &yyvsp[0].addr, sizeof(struct addr));
		yyval.condition.match = condition_match_addr;
		yyval.condition.match_arglen = sizeof(struct addr);
	}
break;
case 90:
#line 904 "parse.y"
{
		if ((yyval.condition.match_arg = malloc(sizeof(struct addr))) == NULL)
			yyerror("Out of memory");
		memcpy(yyval.condition.match_arg, &yyvsp[0].addr, sizeof(struct addr));
		yyval.condition.match = condition_match_addr;
		yyval.condition.match_arglen = sizeof(struct addr);
	}
break;
case 91:
#line 912 "parse.y"
{
		if ((yyval.condition.match_arg = malloc(sizeof(struct condition_time))) == NULL)
			yyerror("Out of memory");
		memcpy(yyval.condition.match_arg, &yyvsp[0].timecondition, sizeof(struct condition_time));
		yyval.condition.match = condition_match_time;
		yyval.condition.match_arglen = sizeof(struct condition_time);
	}
break;
case 92:
#line 922 "parse.y"
{
		yyval.timecondition.tm_start = yyvsp[-2].time;
		yyval.timecondition.tm_end = yyvsp[0].time;
	}
break;
case 93:
#line 929 "parse.y"
{
		int ispm = -1;
		int hour, minute;

		if (strcmp(yyvsp[0].string, "am") == 0) {
			ispm = 0;
		} else if (strcmp(yyvsp[0].string, "pm") == 0) {
			ispm = 1;
		} else {
			yyerror("Bad time specifier, use 'am' or 'pm': %s", yyvsp[0].string);
			break;
		}
		free (yyvsp[0].string);

		hour = yyvsp[-3].number + (ispm ? 12 : 0);
		minute = yyvsp[-1].number;

		memset(&yyval.time, 0, sizeof(yyval.time));
		yyval.time.tm_hour = hour;
		yyval.time.tm_min = minute;
	}
break;
#line 1836 "y.tab.c"
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: after reduction, shifting from state 0 to\
 state %d\n", YYPREFIX, YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
            if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("%sdebug: state %d, reading %d (%s)\n",
                        YYPREFIX, YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: after reduction, shifting from state %d \
to state %d\n", YYPREFIX, *yyssp, yystate);
#endif
    if (yyssp >= yysslim && yygrowstack())
    {
        goto yyoverflow;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    if (yyss)
            free(yyss);
    if (yyvs)
            free(yyvs);
    yyss = yyssp = NULL;
    yyvs = yyvsp = NULL;
    yystacksize = 0;
    return (1);
yyaccept:
    if (yyss)
            free(yyss);
    if (yyvs)
            free(yyvs);
    yyss = yyssp = NULL;
    yyvs = yyvsp = NULL;
    yystacksize = 0;
    return (0);
}
