#include <windows.h>
#include <process.h>
#include <stdio.h>

#include <timer.h>
using namespace HL;

int main (int argc, char * argv[])
{
  Timer t;
  if (argc < 2) {
    printf ("must have at least one argument!\n");
    return -1;
  }
  LPTSTR str = GetCommandLine();
  while (*str != ' ') {
    str++;
  }
  while (*str == ' ') {
    str++;
  }

  STARTUPINFO si;
  PROCESS_INFORMATION pi;
  
  ZeroMemory( &si, sizeof(si) );
  si.cb = sizeof(si);
  ZeroMemory( &pi, sizeof(pi) );
  
  if( !CreateProcess( NULL,   // No module name (use command line). 
		      str, // Command line. 
		      NULL,             // Process handle not inheritable. 
		      NULL,             // Thread handle not inheritable. 
		      FALSE,            // Set handle inheritance to FALSE. 
		      CREATE_SUSPENDED,                // No creation flags. 
		      NULL,             // Use parent's environment block. 
		      NULL,             // Use parent's starting directory. 
		      &si,              // Pointer to STARTUPINFO structure.
		      &pi )             // Pointer to PROCESS_INFORMATION structure.
      )   return 0;
  SetPriorityClass (pi.hProcess, REALTIME_PRIORITY_CLASS);

  t.start();
  ResumeThread (pi.hThread);
  WaitForSingleObject (pi.hProcess, INFINITE);
  t.stop();

  double timeElapsed = (double) t; // temp_cycles / mhz;
  printf ("\nTime elapsed = %lf seconds.\n", timeElapsed);
  return 0;
}

#if 0
  CreateProcess ();
  t.start();
  //  ticks = RDTSC();
  int r = _spawnvp ( _P_WAIT, argv[1], &argv[1] );
  // ticks = RDTSC() - ticks;
  t.stop();

  double timeElapsed = (double) t; // temp_cycles / mhz;
  printf ("\nTime elapsed = %lf seconds.\n", timeElapsed);
  //char buf[255];
  //_i64toa (ticks, buf, 10);
  //printf ("\nClock ticks  = %s.\n", buf);
  return 0;
}
#endif
