/* this is the oss soundcard driver for gnometoaster */


/* compile this if oss support is enabled only */
#include "config.h"
#ifdef HAVE_OSS

#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <signal.h>
#include <fcntl.h>
#include <unistd.h>
#ifndef __FreeBSD__
#include <linux/soundcard.h>
#else
#include <machine/soundcard.h>
#define SNDCTL_DSP_CHANNELS SNDCTL_DSP_STEREO
#endif

#include "audio.h"
#include "piping.h"
#include "stdfiletrack.h"

#include "defaultentries.h"

/* Uncomment for debugging */
#define DEBUG

int audio_oss_open(gpointer data)
{
   audio_driver *driver=(audio_driver*)data;
   
   int speed=44100;
   int channels=2;
   /* give Big Endian a try first as this would be the ideal format
    * (we don't have to spawn a byteswap thread in this case) */
   int format=AFMT_S16_BE;
   
   int inp=-1;
   
   if (driver->descriptor==-1)
     {	
	driver->descriptor=open("/dev/dsp",O_WRONLY);
	if (driver->descriptor!=-1)
	  {
	     int format_mask=0;
	     
	     ioctl(driver->descriptor,SNDCTL_DSP_RESET);
	     ioctl(driver->descriptor,SNDCTL_DSP_SPEED,&speed);
	     ioctl(driver->descriptor,SNDCTL_DSP_CHANNELS,&channels);
	     ioctl(driver->descriptor,SNDCTL_DSP_GETFMTS,&format_mask);
	     /* if Big Endian is not supported, retreat to using 
	      * little Endian */
	     if (!(format_mask&AFMT_S16_BE))
	       format=AFMT_S16_LE;	     	     
	     ioctl(driver->descriptor,SNDCTL_DSP_SAMPLESIZE,&format);
   
/* <some constants from soundcard.h:>
 *			   IOCTLS:
 *			   SNDCTL_DSP_RESET
 *			   SNDCTL_DSP_SPEED 44100
 *			   SNDCTL_DSP_SAMPLESIZE 
 *			      AFMT_S16_LE
 *			      AFMT_S16_BE
 *			      AFMT_U16_LE
 *			      AFMT_U16_BE
 *			   SNDCTL_DSP_CHANNELS 2
 */

	     /* only spawn byteswap thread if our sound destination is
	      * little Endian (like all Soundblaster devices etc.) */
	     if (format==AFMT_S16_LE)
	       {		  
		  driver->data=(gpointer)piping_create_function(stdfiletrack_byteswap,		
								NULL,
								&inp,
								&driver->descriptor,
								NULL);
		  driver->descriptor=inp;
	       };
		  
	  };	
	return driver->descriptor;
     }
   else
     return -1;
   /* return -1 if sound device is in use */
};
			   
void audio_oss_close(gpointer data)
{
   int status;
   audio_driver *driver=(audio_driver*)data;

   if (driver->descriptor!=-1)
     {	
	close(driver->descriptor);
	driver->descriptor=-1;
	/* wait for byteswap to finish */
	if ((int)driver->data!=-1)
	  {
	     /* say good by, byteswap */
	     kill((int)driver->data,SIGTERM);
	     waitpid((int)driver->data,&status,0);
	  };	     
     };
};

void audio_oss_init()
{
   audio_driver_register(audio_driver_create(DEFAULTENTRIES_AUDIO_DEFAULT_OSS,
					     audio_oss_open,
					     audio_oss_close,
					     (gpointer)-1));
};
			 
#endif   
	  
			   
