/*  GTKtalog.
 *  Copyright (C) 1999-2000  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gnome.h>
#ifndef GNOME1
#include <gdk-pixbuf/gdk-pixbuf.h>
#endif

#include "about.h"
#include "config_common.h"

void
about_gtktalog ()
{
  GtkWidget *aboutbox;
  const gchar *authors[3] = { "Mathieu VILLEGAS", "Yves METTIER", NULL };
#ifndef GNOME1
GdkPixbuf *logo;
  const gchar *documenters[5] =
    { "Jean-Baptiste Julien", "Gordon TAYLOR", "Yves METTIER",
"Philippe DAVADIE", NULL };
#endif

#ifdef GNOME1
  aboutbox = gnome_about_new (PACKAGE, VERSION,
			      "(C) 1999-2003 Mathieu VILLEGAS - Yves METTIER",
			      authors,
			      GTKTALOGWEB "\n",
			      DATA_DIR "/gtktalog/icons/logo.xpm");
#else
logo = gdk_pixbuf_new_from_file(DATA_DIR "/gtktalog/icons/logo.xpm",NULL);
  aboutbox = gnome_about_new (PACKAGE, VERSION,
			      "Copyright (C) 1999-2003 Mathieu VILLEGAS - Yves METTIER",
			      "The GNOME disk cataloguer",
			      authors, documenters,
			      "ca: Jesus Climent <jesus.climent@simauria.upv.es>\n"
			      "cs: David Necas (Yeti) <yeti@physics.muni.cz>\n"
			      "de: Gtz Waschk <waschk@informatik.uni-rostock.de>\n"
			      "es: Carlos Nieves nega <cnieves@iname.com>\n"
			      "fr: Yves Mettier <ymettier@libertysurf.fr>\n"
			      "hu: Szkovcs Rbert <szo@yossarian.elte.hu>\n"
			      "it: Roberto Rosselli Del Turco <rosselli@ling.unipi.it>\n"
			      "ja: Kazuya NUMATA <kaznum@gol.com>\n"
			      "nl: Panagiotis Issaris <panagiotis.issaris@advalvas.be>\n"
			      "pl: Robert Gomuka <carramba@zeus.polsl.gliwice.pl>\n"
			      "ru: Sergey A. Ribalchenko <fisher@obu.ck.ua>\n"
			      "sk: Zdenko Podobn <zdpo@mailbox.sk>\n"
			      "sv: Dennis Bjrklund <db@zigo.dhs.org>\n",
			      logo);
#endif
  gtk_window_set_modal (GTK_WINDOW (aboutbox), TRUE);
  gtk_window_set_transient_for (GTK_WINDOW (aboutbox),
				GTK_WINDOW (main_window));
  gtk_widget_show (aboutbox);
}
