/* wcomp.h
 * Written by Dr. Tom <tomh@po.crl.go.jp>
 * 
 * Released under the terms of the GNU General Public License
 * as part of GTKeyboard
 */

#include "file_manip.h"
#include <errno.h>

#ifndef WCOMP_H
#define WCOMP_H

/* The words are kept in a splay tree.  Each word also has a count, which
is the number of times the word has been splayed (i.e., used). */

typedef struct wcomp_tree_node {
     struct wcomp_tree_node *left;
     struct wcomp_tree_node *right;
     struct wcomp_tree_node *parent;
     int count;
     char *key;
} WCompTree;

/* This structure is used by searches to record the position and depth
of a word in the tree.  Lower depth means more recently used. */

typedef struct wcomp_cursor {
     WCompTree *t;
     int depth;
} WCompCursor;

extern WCompTree *wcomp_splay(char *w, WCompTree *t);
extern WCompTree *wcomp_insert(char *w, WCompTree *t);
extern void wcomp_find(char *w, WCompTree *t, WCompCursor *);
extern void wcomp_next(WCompCursor *);

/* (Opaque) structure used to hold the completer's state. */

typedef struct {
     WCompTree *root;        /* the (current) root of the splay tree */
     WCompCursor *topncurs;  /* internal array of MRU completions */
     int topnsize;           /* max size of above array */
     int topn;               /* how many in above array */
     char **topnlist;        /* MRU array returned by wcomp_complete() */
     char *unambig;          /* unambiguous completion buffer */
     char *word;             /* copy of last word passed to wcomp_lookup() */
     int maxwordlen;         /* length of longest word in tree */
     int nwords;             /* total number of words in the tree */
#ifndef BUFFER_WORDLIST
     char *wordlist;         /* in-memory copy of the whole wordlist, when
                                we aren't malloc()ing each word */
#endif
} WComp;

extern WComp *wcomp_open(char *name);
extern void wcomp_free(WComp *wcomp);
extern int wcomp_lookup(WComp *wcomp, char *w);
extern int wcomp_set_topnsize(WComp *wcomp, int size);
extern char **wcomp_complete(WComp *wcomp, char *w);
extern void wcomp_use(WComp *wcomp, char *w);
extern void wcomp_write_cache(WComp *wcomp, FILE *out);
extern void wcomp_read_cache(WComp *wcomp, FILE *in);

#endif /* WCOMP_H */
