/* irxevent.h
 * For GTKeyboard
 * written by David Allen s2mdalle@titan.vcu.edu http://opop.nols.com/
 * Released under the terms of the GNU General Public License.  See
 * COPYING for more information.
 */

#define IRXEVENT_H
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <sys/time.h>
#include <unistd.h>

#define NO_KEYCODE_PRESENT(x)    (x->keycode == 0)
#define NO_KEYSYM_PRESENT(x)     (x->keysym == NoSymbol || \
			          x->keysym == (KeySym) NULL)

#define ERROR_CHECK_KEYCODE(XEV) if(XEV->keycode==0){\
                                 fprintf(Q,"IRXEVENT Warning: Keycode 0\n");\
                                 fflush(Q); return(0);}
#define ERROR_CHECK_KEYSYM(FOO)  if(FOO->keysym==NoSymbol){\
                              fprintf(Q,"IRXEVENT Warning: KeySymNoSymbol\n");\
                                 fflush(Q);}

#ifdef IRXEVENT_C

#if 0
const char *key_delimiter ="-";
char *progname;
#endif
const char *active_window_name ="CurrentWindow";

Window root;
XEvent xev;
Window w;

static const char *zero_keycode = "
This key is not defined for your current keyboard mapping.
In order to make this key work in a foreign window, you must
remap your physical keyboard to this layout.  Choose
\"Remap Keyboard\" from the \"Misc\" menu to do this.
";
#endif /* IRXEVENT_C */

/* fake_timestamp is static in irxevent.c */
Window find_window                    (Window top,char *name);
int make_key                          (char *keyname,XKeyEvent *xev);
void sendkey                          (char *keyname,Window w);
void keysym_sendkey                   (KeySym somesym, Window w);
void gtkeyboard_XEvent_common_setup   (XKeyEvent *xev);
KeySym character_to_keysym            (char i);
